/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.RangePartitioning;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.ForwardingBigQueryFileOutputCommitter;
import com.google.cloud.hadoop.io.bigquery.output.ForwardingBigQueryFileOutputFormat;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryRecordWriter;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sink.Operation;
import io.cdap.plugin.gcp.bigquery.sink.PartitionType;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryOutputFormat
extends ForwardingBigQueryFileOutputFormat<StructuredRecord, NullWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryOutputFormat.class);

    public RecordWriter<StructuredRecord, NullWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        return this.getRecordWriter(taskAttemptContext, this.getOutputSchema(configuration));
    }

    public RecordWriter<StructuredRecord, NullWritable> getRecordWriter(TaskAttemptContext taskAttemptContext, Schema schema) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        return new BigQueryRecordWriter(this.getDelegate(configuration).getRecordWriter(taskAttemptContext), BigQueryOutputConfiguration.getFileFormat((Configuration)configuration), schema);
    }

    private Schema getOutputSchema(Configuration configuration) throws IOException {
        String schemaJson = configuration.get("cdap.bq.sink.output.schema");
        if (schemaJson == null) {
            return null;
        }
        return Schema.parseJson((String)schemaJson);
    }

    public OutputCommitter createCommitter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        OutputCommitter delegateCommitter = this.getDelegate(conf).getOutputCommitter(context);
        return new BigQueryOutputCommitter(context, delegateCommitter);
    }

    private static BigQuery getBigQuery(Configuration config) throws IOException {
        String projectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, (String)"mapred.bq.project.id");
        GoogleCredentials credentials = GCPUtils.loadCredentialsFromConf(config);
        return GCPUtils.getBigQuery(projectId, (Credentials)credentials);
    }

    public static class BigQueryOutputCommitter
    extends ForwardingBigQueryFileOutputCommitter {
        private BigQueryHelper bigQueryHelper;
        private Operation operation;
        private TableReference temporaryTableReference;
        private List<String> tableKeyList;
        private List<String> orderedByList;
        private List<String> tableFieldsList;
        private String partitionFilter;
        private boolean allowSchemaRelaxation;
        private boolean allowSchemaRelaxationOnEmptyOutput;
        private static final int BQ_IMPORT_MAX_BATCH_SIZE = 10000;

        BigQueryOutputCommitter(TaskAttemptContext context, OutputCommitter delegate) throws IOException {
            super(context, delegate);
            try {
                BigQueryFactory bigQueryFactory = new BigQueryFactory();
                this.bigQueryHelper = bigQueryFactory.getBigQueryHelper(context.getConfiguration());
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed to create Bigquery client.", e);
            }
        }

        public void commitJob(JobContext jobContext) throws IOException {
            super.commitJob(jobContext);
            Configuration conf = jobContext.getConfiguration();
            TableReference destTable = BigQueryOutputCommitter.getTableReference(conf);
            String destProjectId = BigQueryOutputConfiguration.getJobProjectId((Configuration)conf);
            String writeDisposition = BigQueryOutputConfiguration.getWriteDisposition((Configuration)conf);
            Optional<TableSchema> destSchema = BigQueryOutputCommitter.getTableSchema(conf);
            String kmsKeyName = BigQueryOutputConfiguration.getKmsKeyName((Configuration)conf);
            BigQueryFileFormat outputFileFormat = BigQueryOutputConfiguration.getFileFormat((Configuration)conf);
            List sourceUris = this.getOutputFileURIs();
            this.allowSchemaRelaxation = conf.getBoolean("cdap.bq.sink.allow.schema.relaxation", false);
            this.allowSchemaRelaxationOnEmptyOutput = conf.getBoolean("cdap.bq.sink.allow.schema.relaxationoemptyoutput", false);
            LOG.debug("Allow schema relaxation: '{}'", (Object)this.allowSchemaRelaxation);
            PartitionType partitionType = (PartitionType)conf.getEnum("cdap.bq.sink.partition.type", (Enum)PartitionType.NONE);
            LOG.debug("Create Partitioned Table type: '{}'", (Object)partitionType);
            RangePartitioning.Range range = partitionType == PartitionType.INTEGER ? this.createRangeForIntegerPartitioning(conf) : null;
            String partitionByField = conf.get("cdap.bq.sink.partition.by.field", null);
            LOG.debug("Partition Field: '{}'", (Object)partitionByField);
            boolean requirePartitionFilter = conf.getBoolean("cdap.bq.sink.require.partition.filter", false);
            LOG.debug("Require partition filter: '{}'", (Object)requirePartitionFilter);
            this.operation = Operation.valueOf(conf.get("cdap.bq.sink.operation"));
            String clusteringOrder = conf.get("cdap.bq.sink.clustering.order", null);
            List<String> clusteringOrderList = Arrays.stream(clusteringOrder != null ? clusteringOrder.split(",") : new String[]{}).map(String::trim).collect(Collectors.toList());
            String tableKey = conf.get("cdap.bq.sink.table.key", null);
            this.tableKeyList = Arrays.stream(tableKey != null ? tableKey.split(",") : new String[]{}).map(String::trim).collect(Collectors.toList());
            String dedupedBy = conf.get("cdap.bq.sink.dedupe.by", null);
            this.orderedByList = Arrays.stream(dedupedBy != null ? dedupedBy.split(",") : new String[]{}).collect(Collectors.toList());
            String tableFields = conf.get("cdap.bq.sink.table.fields", null);
            this.tableFieldsList = Arrays.stream(tableFields != null ? tableFields.split(",") : new String[]{}).map(String::trim).collect(Collectors.toList());
            this.partitionFilter = conf.get("cdap.bq.sink.partition.filter", null);
            LOG.debug("Partition filter: '{}'", (Object)this.partitionFilter);
            boolean tableExists = conf.getBoolean("cdap.bq.sink.destination.table.exists", false);
            try {
                this.importFromGcs(destProjectId, destTable, destSchema.orElse(null), kmsKeyName, outputFileFormat, writeDisposition, sourceUris, partitionType, range, partitionByField, requirePartitionFilter, clusteringOrderList, tableExists, conf);
            }
            catch (Exception e) {
                throw new IOException("Failed to import GCS into BigQuery. ", e);
            }
            this.cleanup(jobContext);
        }

        private String getJobIdForImportGCS(Configuration conf) {
            if (!Operation.INSERT.equals((Object)this.operation)) {
                return UUID.randomUUID().toString();
            }
            String savedJobId = conf.get("cdap.bq.sink.job.id");
            if (savedJobId == null || savedJobId.isEmpty()) {
                return UUID.randomUUID().toString();
            }
            return savedJobId;
        }

        private JobId getJobIdForUpdateUpsert(Configuration conf) {
            String savedJobId = conf.get("cdap.bq.sink.job.id");
            if (savedJobId == null || savedJobId.isEmpty()) {
                return JobId.of((String)UUID.randomUUID().toString());
            }
            return JobId.of((String)savedJobId);
        }

        public void abortJob(JobContext context, JobStatus.State state) throws IOException {
            super.abortJob(context, state);
            this.cleanup(context);
        }

        private void importFromGcs(String projectId, TableReference tableRef, @Nullable TableSchema schema, @Nullable String kmsKeyName, BigQueryFileFormat sourceFormat, String writeDisposition, List<String> gcsPaths, PartitionType partitionType, @Nullable RangePartitioning.Range range, @Nullable String partitionByField, boolean requirePartitionFilter, List<String> clusteringOrderList, boolean tableExists, Configuration conf) throws IOException, InterruptedException {
            LOG.info("Importing into table '{}' from {} paths; path[0] is '{}'; awaitCompletion: {}", new Object[]{BigQueryStrings.toString((TableReference)tableRef), gcsPaths.size(), gcsPaths.isEmpty() ? "(empty)" : gcsPaths.get(0), true});
            String jobId = this.getJobIdForImportGCS(conf);
            if (gcsPaths.isEmpty()) {
                if (!this.bigQueryHelper.tableExists(tableRef)) {
                    Table table = new Table();
                    table.setSchema(schema);
                    table.setTableReference(tableRef);
                    this.bigQueryHelper.getRawBigquery().tables().insert(tableRef.getProjectId(), tableRef.getDatasetId(), table).execute();
                } else if (this.allowSchemaRelaxationOnEmptyOutput) {
                    Table table = this.bigQueryHelper.getTable(tableRef);
                    table.setSchema(schema);
                    this.bigQueryHelper.getRawBigquery().tables().update(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId(), table).execute();
                }
                return;
            }
            JobConfigurationLoad loadConfig = new JobConfigurationLoad();
            loadConfig.setSourceFormat(sourceFormat.getFormatIdentifier());
            loadConfig.setUseAvroLogicalTypes(Boolean.valueOf(true));
            if (!this.allowSchemaRelaxation && tableExists) {
                loadConfig.setSchema(this.bigQueryHelper.getTable(tableRef).getSchema());
            } else {
                loadConfig.setSchema(schema);
            }
            HashMap<String, String> fieldDescriptions = new HashMap<String, String>();
            if (JobInfo.WriteDisposition.WRITE_TRUNCATE.equals((Object)JobInfo.WriteDisposition.valueOf((String)writeDisposition)) && tableExists) {
                List<TableFieldSchema> tableFieldSchemas = Optional.ofNullable(this.bigQueryHelper.getTable(tableRef)).map(it -> it.getSchema()).map(it -> it.getFields()).orElse(Collections.emptyList());
                tableFieldSchemas.forEach(it -> {
                    if (!Strings.isNullOrEmpty((String)it.getDescription())) {
                        fieldDescriptions.put(it.getName(), it.getDescription());
                    }
                });
            }
            if (!tableExists) {
                switch (partitionType) {
                    case TIME: {
                        TimePartitioning timePartitioning = this.createTimePartitioning(partitionByField, requirePartitionFilter);
                        loadConfig.setTimePartitioning(timePartitioning);
                        break;
                    }
                    case INTEGER: {
                        RangePartitioning rangePartitioning = this.createRangePartitioning(partitionByField, range);
                        if (requirePartitionFilter) {
                            this.createTableWithRangePartitionAndRequirePartitionFilter(tableRef, schema, rangePartitioning);
                            break;
                        }
                        loadConfig.setRangePartitioning(rangePartitioning);
                        break;
                    }
                }
                if (PartitionType.NONE != partitionType && !clusteringOrderList.isEmpty()) {
                    Clustering clustering = new Clustering();
                    clustering.setFields(clusteringOrderList);
                    loadConfig.setClustering(clustering);
                }
            }
            if (!tableExists && Operation.UPSERT.equals((Object)this.operation)) {
                this.operation = Operation.INSERT;
            }
            if (Operation.INSERT.equals((Object)this.operation) && this.allowSchemaRelaxation && !JobInfo.WriteDisposition.WRITE_TRUNCATE.equals((Object)JobInfo.WriteDisposition.valueOf((String)writeDisposition))) {
                loadConfig.setSchemaUpdateOptions(Arrays.asList(JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION.name(), JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION.name()));
            }
            if (!Strings.isNullOrEmpty((String)kmsKeyName)) {
                loadConfig.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKeyName));
            }
            if (loadConfig.getSchema() == null) {
                LOG.info("No import schema provided, auto detecting schema.");
                loadConfig.setAutodetect(Boolean.valueOf(true));
            } else {
                LOG.info("Using schema '{}' for the load job config.", (Object)loadConfig.getSchema());
            }
            Dataset dataset = (Dataset)this.bigQueryHelper.getRawBigquery().datasets().get(tableRef.getProjectId(), tableRef.getDatasetId()).execute();
            this.temporaryTableReference = null;
            if (this.operation.equals((Object)Operation.INSERT) && gcsPaths.size() <= 10000) {
                loadConfig.setSourceUris(gcsPaths);
                loadConfig.setWriteDisposition(writeDisposition);
                loadConfig.setDestinationTable(tableRef);
                JobConfiguration config = new JobConfiguration();
                config.setLoad(loadConfig);
                config.setLabels(BigQueryUtil.getJobTags("bq_sink_plugin"));
                this.triggerBigqueryJob(projectId, jobId, dataset, config, tableRef);
            } else {
                this.loadInBatchesInTempTable(tableRef, loadConfig, gcsPaths, projectId, jobId, dataset);
                if (this.operation.equals((Object)Operation.INSERT)) {
                    this.handleInsertOperation(tableRef, writeDisposition, loadConfig.getDestinationEncryptionConfiguration(), projectId, jobId, dataset, tableExists);
                } else {
                    this.handleUpdateUpsertOperation(tableRef, tableExists, kmsKeyName, this.getJobIdForUpdateUpsert(conf), projectId, dataset);
                }
            }
            this.setTemporaryTableExpiration();
            this.updateFieldDescriptions(writeDisposition, tableRef, fieldDescriptions);
            LOG.info("Imported into table '{}' from {} paths; path[0] is '{}'", new Object[]{BigQueryStrings.toString((TableReference)tableRef), gcsPaths.size(), gcsPaths.isEmpty() ? "(empty)" : gcsPaths.get(0)});
        }

        private void triggerBigqueryJob(String projectId, String jobId, Dataset dataset, JobConfiguration jobConfiguration, TableReference tableRef) throws IOException, InterruptedException {
            JobReference jobReference = new JobReference().setProjectId(projectId).setJobId(jobId).setLocation(dataset.getLocation());
            Job job = new Job();
            job.setConfiguration(jobConfiguration);
            job.setJobReference(jobReference);
            this.bigQueryHelper.insertJobOrFetchDuplicate(projectId, job);
            BigQueryOutputCommitter.waitForJobCompletion(this.bigQueryHelper, projectId, jobReference, tableRef, this.operation);
        }

        private void loadInBatchesInTempTable(TableReference tableRef, JobConfigurationLoad loadConfig, List<String> gcsPaths, String projectId, String jobId, Dataset dataset) throws IOException, InterruptedException {
            LOG.info(" Importing into a temporary table first in batches of 10000");
            String temporaryTableName = tableRef.getTableId() + "_" + UUID.randomUUID().toString().replaceAll("-", "_");
            this.temporaryTableReference = new TableReference().setDatasetId(tableRef.getDatasetId()).setProjectId(tableRef.getProjectId()).setTableId(temporaryTableName);
            loadConfig.setDestinationTable(this.temporaryTableReference);
            loadConfig.setWriteDisposition(JobInfo.WriteDisposition.WRITE_APPEND.toString());
            List gcsPathsInBatches = Lists.partition(gcsPaths, (int)10000);
            int jobcount = 1;
            for (List gcsPathBatch : gcsPathsInBatches) {
                LOG.debug(" Running for Batch {} with number of gcs paths : {}", (Object)jobcount, (Object)gcsPathBatch.size());
                loadConfig.setSourceUris(gcsPathBatch);
                JobConfiguration config = new JobConfiguration();
                config.setLoad(loadConfig);
                config.setLabels(BigQueryUtil.getJobTags("bq_sink_plugin"));
                this.triggerBigqueryJob(projectId, jobId + "_" + jobcount, dataset, config, tableRef);
                ++jobcount;
            }
        }

        private void setTemporaryTableExpiration() throws IOException {
            if (this.temporaryTableReference != null && this.bigQueryHelper.tableExists(this.temporaryTableReference)) {
                long expirationMillis = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
                Table table = this.bigQueryHelper.getTable(this.temporaryTableReference).setExpirationTime(Long.valueOf(expirationMillis));
                this.bigQueryHelper.getRawBigquery().tables().update(this.temporaryTableReference.getProjectId(), this.temporaryTableReference.getDatasetId(), this.temporaryTableReference.getTableId(), table).execute();
            }
        }

        private static void waitForJobCompletion(BigQueryHelper bigQueryHelper, String projectId, JobReference jobReference, TableReference tableRef, @Nullable Operation operation) throws IOException, InterruptedException {
            Bigquery bigquery = bigQueryHelper.getRawBigquery();
            Sleeper sleeper = Sleeper.DEFAULT;
            ExponentialBackOff pollBackOff = new ExponentialBackOff.Builder().setMaxIntervalMillis(BigQueryUtils.POLL_WAIT_INTERVAL_MAX_MILLIS).setInitialIntervalMillis(BigQueryUtils.POLL_WAIT_INITIAL_MILLIS).setMaxElapsedTimeMillis(BigQueryUtils.POLL_WAIT_MAX_ELAPSED_MILLIS).build();
            long startTime = System.currentTimeMillis();
            boolean notDone = true;
            while (notDone) {
                ExponentialBackOff operationBackOff = new ExponentialBackOff.Builder().build();
                Bigquery.Jobs.Get get = bigquery.jobs().get(projectId, jobReference.getJobId()).setLocation(jobReference.getLocation());
                Job pollJob = (Job)ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)get), (BackOff)operationBackOff, (RetryDeterminer)RetryDeterminer.RATE_LIMIT_ERRORS, IOException.class, (Sleeper)sleeper);
                long elapsedTime = System.currentTimeMillis() - startTime;
                LOG.debug("Job status ({} ms) {}: {}", new Object[]{elapsedTime, jobReference.getJobId(), pollJob.getStatus().getState()});
                if (pollJob.getStatus().getState().equals("DONE")) {
                    int numOfErrors;
                    String errorMessage;
                    notDone = false;
                    if (pollJob.getStatus().getErrorResult() == null) continue;
                    if (Operation.UPDATE.equals((Object)operation) && !bigQueryHelper.tableExists(tableRef)) {
                        LOG.warn("BigQuery Table {} does not exist. The operation update will not write any records to the table.", (Object)String.format("%s.%s.%s", tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId()));
                        return;
                    }
                    List errors = pollJob.getStatus().getErrors();
                    if (errors == null || errors.isEmpty()) {
                        errorMessage = pollJob.getStatus().getErrorResult().getMessage();
                        numOfErrors = 1;
                    } else {
                        errorMessage = ((ErrorProto)errors.get(errors.size() - 1)).getMessage();
                        numOfErrors = errors.size();
                    }
                    throw new IOException(String.format("Error occurred while importing data to BigQuery '%s'. There are total %s error(s) for BigQuery job %s. Please look at BigQuery job logs for more information.", errorMessage, numOfErrors, jobReference.getJobId()));
                }
                long millisToWait = pollBackOff.nextBackOffMillis();
                if (millisToWait == -1L) {
                    throw new IOException(String.format("Job %s failed to complete after %s millis.", jobReference.getJobId(), elapsedTime));
                }
                Thread.sleep(millisToWait);
                Progressable progressable = () -> {};
                progressable.progress();
            }
        }

        private static TableReference getTableReference(Configuration conf) throws IOException {
            String projectId = BigQueryOutputConfiguration.getProjectId((Configuration)conf);
            String datasetId = ConfigurationUtil.getMandatoryConfig((Configuration)conf, (String)"mapred.bq.output.dataset.id");
            String tableId = ConfigurationUtil.getMandatoryConfig((Configuration)conf, (String)"mapred.bq.output.table.id");
            return new TableReference().setProjectId(projectId).setDatasetId(datasetId).setTableId(tableId);
        }

        private static Optional<TableSchema> getTableSchema(Configuration conf) throws IOException {
            String fieldsJson = conf.get("mapred.bq.output.table.schema");
            if (!Strings.isNullOrEmpty((String)fieldsJson)) {
                try {
                    TableSchema tableSchema = BigQueryOutputCommitter.createTableSchemaFromFields(fieldsJson);
                    return Optional.of(tableSchema);
                }
                catch (IOException e) {
                    throw new IOException("Unable to parse key 'mapred.bq.output.table.schema'.", e);
                }
            }
            return Optional.empty();
        }

        private void handleInsertOperation(TableReference tableRef, String writeDisposition, EncryptionConfiguration encryptionConfiguration, String projectId, String jobId, Dataset dataset, boolean tableExists) throws IOException, InterruptedException {
            if (this.allowSchemaRelaxation && tableExists) {
                this.updateTableSchema(tableRef);
            }
            JobConfigurationTableCopy tableCopyConfig = new JobConfigurationTableCopy();
            tableCopyConfig.setDestinationTable(tableRef);
            tableCopyConfig.setSourceTable(this.temporaryTableReference);
            tableCopyConfig.setWriteDisposition(writeDisposition);
            tableCopyConfig.setDestinationEncryptionConfiguration(encryptionConfiguration);
            JobConfiguration config = new JobConfiguration();
            config.setCopy(tableCopyConfig);
            config.setLabels(BigQueryUtil.getJobTags("bq_sink_plugin"));
            this.triggerBigqueryJob(projectId, jobId, dataset, config, tableRef);
        }

        private void handleUpdateUpsertOperation(TableReference tableRef, boolean tableExists, @Nullable String cmekKey, JobId jobId, String projectId, Dataset dataset) throws IOException, InterruptedException {
            if (this.allowSchemaRelaxation && tableExists) {
                this.updateTableSchema(tableRef);
            }
            TableId sourceTableId = TableId.of((String)this.temporaryTableReference.getProjectId(), (String)this.temporaryTableReference.getDatasetId(), (String)this.temporaryTableReference.getTableId());
            TableId destinationTableId = TableId.of((String)tableRef.getProjectId(), (String)tableRef.getDatasetId(), (String)tableRef.getTableId());
            String query = BigQuerySinkUtils.generateUpdateUpsertQuery(this.operation, sourceTableId, destinationTableId, this.tableFieldsList, this.tableKeyList, this.orderedByList, this.partitionFilter);
            LOG.info("Update/Upsert query: " + query);
            JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery();
            jobConfigurationQuery.setQuery(query);
            jobConfigurationQuery.setUseLegacySql(Boolean.valueOf(false));
            EncryptionConfiguration encryptionConfiguration = new EncryptionConfiguration();
            encryptionConfiguration.setKmsKeyName(cmekKey);
            jobConfigurationQuery.setDestinationEncryptionConfiguration(encryptionConfiguration);
            JobConfiguration jobConfiguration = new JobConfiguration();
            jobConfiguration.setLabels(BigQueryUtil.getJobTags("bq_sink_plugin"));
            jobConfiguration.setQuery(jobConfigurationQuery);
            this.triggerBigqueryJob(projectId, jobId.getJob(), dataset, jobConfiguration, tableRef);
        }

        private void updateTableSchema(TableReference tableRef) {
            LOG.debug("Update/Upsert table schema update");
            BigQuery bigquery = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
            TableId sourceTableId = TableId.of((String)this.temporaryTableReference.getDatasetId(), (String)this.temporaryTableReference.getTableId());
            TableId destinationTableId = TableId.of((String)tableRef.getDatasetId(), (String)tableRef.getTableId());
            com.google.cloud.bigquery.Table sourceTable = bigquery.getTable(sourceTableId, new BigQuery.TableOption[0]);
            com.google.cloud.bigquery.Table destinationTable = bigquery.getTable(destinationTableId, new BigQuery.TableOption[0]);
            if (destinationTable == null) {
                LOG.warn("Unable to update schema for table {}.{}.{} , table does not exist.", new Object[]{destinationTableId.getProject(), destinationTableId.getDataset(), destinationTableId.getTable()});
                return;
            }
            FieldList sourceFields = sourceTable.getDefinition().getSchema().getFields();
            this.tableFieldsList = sourceFields.stream().map(Field::getName).collect(Collectors.toList());
            BigQuerySinkUtils.relaxTableSchema(bigquery, sourceTable, destinationTable);
        }

        private static TableSchema createTableSchemaFromFields(String fieldsJson) throws IOException {
            ArrayList fields = new ArrayList();
            JsonParser parser = JacksonFactory.getDefaultInstance().createJsonParser(fieldsJson);
            parser.parseArrayAndClose(fields, TableFieldSchema.class);
            return new TableSchema().setFields(fields);
        }

        private void updateFieldDescriptions(String writeDisposition, TableReference tableRef, Map<String, String> fieldDescriptions) throws IOException {
            if (JobInfo.WriteDisposition.WRITE_TRUNCATE.equals((Object)JobInfo.WriteDisposition.valueOf((String)writeDisposition))) {
                Table table = this.bigQueryHelper.getTable(tableRef);
                List<TableFieldSchema> tableFieldSchemas = Optional.ofNullable(table).map(Table::getSchema).map(TableSchema::getFields).orElse(Collections.emptyList());
                tableFieldSchemas.forEach(it -> Optional.ofNullable(fieldDescriptions.get(it.getName())).ifPresent(arg_0 -> ((TableFieldSchema)it).setDescription(arg_0)));
                this.bigQueryHelper.getRawBigquery().tables().update(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId(), table).execute();
            }
        }

        protected void cleanup(JobContext context) throws IOException {
            super.cleanup(context);
            if (this.temporaryTableReference != null && this.bigQueryHelper.tableExists(this.temporaryTableReference)) {
                this.bigQueryHelper.getRawBigquery().tables().delete(this.temporaryTableReference.getProjectId(), this.temporaryTableReference.getDatasetId(), this.temporaryTableReference.getTableId()).execute();
            }
        }

        private RangePartitioning.Range createRangeForIntegerPartitioning(Configuration conf) {
            long rangeStart = conf.getLong("cdap.bq.sink.partition.integer.range.start", 0L);
            long rangeEnd = conf.getLong("cdap.bq.sink.partition.integer.range.end", 0L);
            long rangeInterval = conf.getLong("cdap.bq.sink.partition.integer.range.interval", 0L);
            RangePartitioning.Range range = new RangePartitioning.Range();
            range.setStart(Long.valueOf(rangeStart));
            range.setEnd(Long.valueOf(rangeEnd));
            range.setInterval(Long.valueOf(rangeInterval));
            return range;
        }

        private TimePartitioning createTimePartitioning(@Nullable String partitionByField, boolean requirePartitionFilter) {
            TimePartitioning timePartitioning = new TimePartitioning();
            timePartitioning.setType("DAY");
            if (partitionByField != null) {
                timePartitioning.setField(partitionByField);
            }
            timePartitioning.setRequirePartitionFilter(Boolean.valueOf(requirePartitionFilter));
            return timePartitioning;
        }

        private void createTableWithRangePartitionAndRequirePartitionFilter(TableReference tableRef, @Nullable TableSchema schema, RangePartitioning rangePartitioning) throws IOException {
            Table table = new Table();
            table.setSchema(schema);
            table.setTableReference(tableRef);
            table.setRequirePartitionFilter(Boolean.valueOf(true));
            table.setRangePartitioning(rangePartitioning);
            this.bigQueryHelper.getRawBigquery().tables().insert(tableRef.getProjectId(), tableRef.getDatasetId(), table).execute();
        }

        private RangePartitioning createRangePartitioning(@Nullable String partitionByField, @Nullable RangePartitioning.Range range) {
            RangePartitioning rangePartitioning = new RangePartitioning();
            rangePartitioning.setRange(range);
            if (partitionByField != null) {
                rangePartitioning.setField(partitionByField);
            }
            return rangePartitioning;
        }
    }
}

