/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryOutputFormat;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class BigQueryOutputFormatProvider
implements OutputFormatProvider {
    protected Configuration configuration;
    protected Schema tableSchema;

    protected BigQueryOutputFormatProvider() {
    }

    public BigQueryOutputFormatProvider(Configuration configuration, Schema tableSchema) {
        this.configuration = configuration;
        this.tableSchema = tableSchema;
    }

    public String getOutputFormatClassName() {
        return BigQueryOutputFormat.class.getName();
    }

    public Map<String, String> getOutputFormatConfiguration() {
        Map<String, String> configToMap = BigQueryUtil.configToMap(this.configuration);
        if (this.tableSchema != null) {
            configToMap.put("cdap.bq.sink.output.schema", this.tableSchema.toString());
        }
        return configToMap;
    }
}

