/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.gson.stream.JsonWriter;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class BigQueryRecordToJson {
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");

    public static void write(JsonWriter writer, String name, Object object, Schema fieldSchema) throws IOException {
        BigQueryRecordToJson.write(writer, name, false, object, fieldSchema);
    }

    private static void write(JsonWriter writer, String name, boolean isArrayItem, Object object, Schema fieldSchema) throws IOException {
        Schema schema = BigQueryUtil.getNonNullableSchema(fieldSchema);
        switch (schema.getType()) {
            case NULL: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: 
            case BYTES: {
                BigQueryRecordToJson.writeSimpleTypes(writer, name, isArrayItem, object, schema);
                break;
            }
            case ARRAY: {
                BigQueryRecordToJson.writeArray(writer, name, object, schema);
                break;
            }
            case RECORD: {
                BigQueryRecordToJson.writeRecord(writer, name, object, schema);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Field '%s' is of unsupported type '%s'", name, fieldSchema.getType()));
            }
        }
    }

    private static void writeSimpleTypes(JsonWriter writer, String name, boolean isArrayItem, Object object, Schema schema) throws IOException {
        if (!isArrayItem) {
            writer.name(name);
        }
        if (object == null) {
            writer.nullValue();
            return;
        }
        Schema.LogicalType logicalType = schema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType) {
                case DATE: {
                    writer.value(Objects.requireNonNull(LocalDate.ofEpochDay(((Integer)object).longValue()).toString()));
                    break;
                }
                case TIME_MILLIS: {
                    writer.value(TIME_FORMATTER.format(Objects.requireNonNull(LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((Integer)object).intValue())))));
                    break;
                }
                case TIME_MICROS: {
                    writer.value(TIME_FORMATTER.format(Objects.requireNonNull(LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos((Long)object)))));
                    break;
                }
                case TIMESTAMP_MILLIS: {
                    writer.value(DATETIME_FORMATTER.format(Objects.requireNonNull(BigQueryRecordToJson.getZonedDateTime((Long)object, TimeUnit.MILLISECONDS))));
                    break;
                }
                case TIMESTAMP_MICROS: {
                    writer.value(DATETIME_FORMATTER.format(Objects.requireNonNull(BigQueryRecordToJson.getZonedDateTime((Long)object, TimeUnit.MICROSECONDS))));
                    break;
                }
                case DECIMAL: {
                    writer.value(Objects.requireNonNull(BigQueryRecordToJson.getDecimal(name, (byte[])object, schema)).toPlainString());
                    break;
                }
                case DATETIME: {
                    writer.value(Objects.requireNonNull(object.toString()));
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Field '%s' is of unsupported type '%s'", name, logicalType.getToken()));
                }
            }
            return;
        }
        switch (schema.getType()) {
            case NULL: {
                writer.nullValue();
                break;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                writer.value((Number)object);
                break;
            }
            case BOOLEAN: {
                writer.value(((Boolean)object).booleanValue());
                break;
            }
            case STRING: {
                writer.value(object.toString());
                break;
            }
            case BYTES: {
                if (object instanceof byte[]) {
                    writer.value(Base64.getEncoder().encodeToString((byte[])object));
                    break;
                }
                if (object instanceof ByteBuffer) {
                    writer.value(Base64.getEncoder().encodeToString(Bytes.toBytes((ByteBuffer)((ByteBuffer)object))));
                    break;
                }
                throw new IllegalStateException(String.format("Expected value of Field '%s' to be bytes but got '%s'", name, object.getClass().getSimpleName()));
            }
            default: {
                throw new IllegalStateException(String.format("Field '%s' is of unsupported type '%s'", name, schema.getType()));
            }
        }
    }

    private static void writeArray(JsonWriter writer, String name, @Nullable Object value, Schema fieldSchema) throws IOException {
        writer.name(name);
        writer.beginArray();
        if (value != null) {
            List<Object> collection;
            if (value instanceof Collection) {
                collection = (List<Object>)value;
            } else if (value instanceof Object[]) {
                collection = Arrays.asList((Object[])value);
            } else {
                throw new IllegalArgumentException(String.format("A value for the field '%s' is of type '%s' when it is expected to be a Collection or array.", name, value.getClass().getSimpleName()));
            }
            Schema componentSchema = BigQueryUtil.getNonNullableSchema(Objects.requireNonNull(fieldSchema.getComponentSchema()));
            if (BigQueryUtil.UNSUPPORTED_ARRAY_TYPES.contains(componentSchema.getType())) {
                throw new IllegalArgumentException(String.format("Field '%s' is an array of '%s', which is not a valid BigQuery type.", name, componentSchema));
            }
            for (Object e : collection) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Field '%s' contains null values in its array, which is not allowed by BigQuery.", name));
                }
                if (e instanceof StructuredRecord) {
                    StructuredRecord record = (StructuredRecord)e;
                    BigQueryRecordToJson.processRecord(writer, record, Objects.requireNonNull(record.getSchema().getFields()));
                    continue;
                }
                BigQueryRecordToJson.write(writer, name, true, e, componentSchema);
            }
        }
        writer.endArray();
    }

    private static void writeRecord(JsonWriter writer, String name, @Nullable Object value, Schema fieldSchema) throws IOException {
        if (value == null) {
            writer.name(name);
            writer.nullValue();
            return;
        }
        if (!(value instanceof StructuredRecord)) {
            throw new IllegalStateException(String.format("Value is of type '%s', expected type is '%s'", value.getClass().getSimpleName(), StructuredRecord.class.getSimpleName()));
        }
        writer.name(name);
        BigQueryRecordToJson.processRecord(writer, (StructuredRecord)value, Objects.requireNonNull(fieldSchema.getFields()));
    }

    private static void processRecord(JsonWriter writer, StructuredRecord record, List<Schema.Field> fields) throws IOException {
        writer.beginObject();
        for (Schema.Field field : fields) {
            BigQueryRecordToJson.write(writer, field.getName(), record.get(field.getName()), field.getSchema());
        }
        writer.endObject();
    }

    private static ZonedDateTime getZonedDateTime(long ts, TimeUnit unit) {
        long mod = unit.convert(1L, TimeUnit.SECONDS);
        int fraction = (int)(ts % mod);
        long tsInSeconds = unit.toSeconds(ts);
        Instant instant = Instant.ofEpochSecond(tsInSeconds, unit.toNanos(fraction));
        return ZonedDateTime.ofInstant(instant, ZoneId.ofOffset("UTC", ZoneOffset.UTC));
    }

    private static BigDecimal getDecimal(String name, byte[] value, Schema schema) {
        int scale = schema.getScale();
        BigDecimal decimal = new BigDecimal(new BigInteger(value), scale);
        if (decimal.precision() > 77 || decimal.scale() > 38) {
            throw new IllegalArgumentException(String.format("Numeric Field '%s' has invalid precision '%s' and scale '%s'. Precision must be at most '%s' and scale must be at most '%s'.", name, decimal.precision(), decimal.scale(), 77, 38));
        }
        return decimal;
    }

    private BigQueryRecordToJson() {
    }
}

