/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.common.RecordConverter;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryAvroConverter;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryJsonConverter;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class BigQueryRecordWriter
extends RecordWriter<StructuredRecord, NullWritable> {
    private final RecordWriter delegate;
    private final BigQueryFileFormat fileFormat;
    private final Schema outputSchema;
    private RecordConverter recordConverter;

    public BigQueryRecordWriter(RecordWriter delegate, BigQueryFileFormat fileFormat, @Nullable Schema outputSchema) {
        this.delegate = delegate;
        this.fileFormat = fileFormat;
        this.outputSchema = outputSchema;
        this.initRecordConverter();
    }

    private void initRecordConverter() {
        if (this.fileFormat == BigQueryFileFormat.NEWLINE_DELIMITED_JSON) {
            this.recordConverter = new BigQueryJsonConverter();
            return;
        }
        this.recordConverter = new BigQueryAvroConverter();
    }

    public void write(StructuredRecord structuredRecord, NullWritable nullWriter) throws IOException, InterruptedException {
        this.delegate.write(this.recordConverter.transform((Object)structuredRecord, this.outputSchema), (Object)nullWriter);
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.delegate.close(taskAttemptContext);
    }
}

