/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.bigquery.sink.AbstractBigQuerySinkConfig;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sink.Operation;
import io.cdap.plugin.gcp.bigquery.sink.PartitionType;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.CmekUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigQuerySinkConfig
extends AbstractBigQuerySinkConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySinkConfig.class);
    private static final String WHERE = "WHERE";
    public static final Set<Schema.Type> SUPPORTED_CLUSTERING_TYPES = ImmutableSet.of((Object)Schema.Type.INT, (Object)Schema.Type.LONG, (Object)Schema.Type.STRING, (Object)Schema.Type.BOOLEAN, (Object)Schema.Type.BYTES);
    private static final Pattern FIELD_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    public static final String NAME_TABLE = "table";
    public static final String NAME_SCHEMA = "schema";
    public static final String NAME_TABLE_KEY = "relationTableKey";
    public static final String NAME_DEDUPE_BY = "dedupeBy";
    public static final String NAME_PARTITION_BY_FIELD = "partitionByField";
    public static final String NAME_CLUSTERING_ORDER = "clusteringOrder";
    public static final String NAME_OPERATION = "operation";
    public static final String PARTITION_FILTER = "partitionFilter";
    public static final String NAME_PARTITIONING_TYPE = "partitioningType";
    public static final String NAME_RANGE_START = "rangeStart";
    public static final String NAME_RANGE_END = "rangeEnd";
    public static final String NAME_RANGE_INTERVAL = "rangeInterval";
    public static final int MAX_NUMBER_OF_COLUMNS = 4;
    @Name(value="table")
    @Macro
    @Description(value="The table to write to. A table contains individual records organized in rows. Each record is composed of columns (also called fields). Every table is defined by a schema that describes the column names, data types, and other information.")
    private String table;
    @Name(value="schema")
    @Macro
    @Nullable
    @Description(value="The schema of the data to write. If provided, must be compatible with the table schema.")
    private String schema;
    @Macro
    @Nullable
    @Description(value="DEPRECATED!. Whether to create the BigQuery table with time partitioning. This value is ignored if the table already exists. When this is set to false, value of Partitioning type will be used. Use 'Partitioning type' property")
    protected Boolean createPartitionedTable;
    @Name(value="partitioningType")
    @Macro
    @Nullable
    @Description(value="Specifies the partitioning type. Can either be Integer or Time or None. Ignored when table already exists")
    protected String partitioningType;
    @Name(value="rangeStart")
    @Macro
    @Nullable
    @Description(value="Start value for range partitioning. The start value is inclusive. Ignored when table already exists")
    protected Long rangeStart;
    @Name(value="rangeEnd")
    @Macro
    @Nullable
    @Description(value="End value for range partitioning. The end value is exclusive. Ignored when table already exists")
    protected Long rangeEnd;
    @Name(value="rangeInterval")
    @Macro
    @Nullable
    @Description(value="Interval value for range partitioning. The interval value must be a positive integer.Ignored when table already exists")
    protected Long rangeInterval;
    @Name(value="partitionByField")
    @Macro
    @Nullable
    @Description(value="Partitioning column for the BigQuery table. This should be left empty if the BigQuery table is an ingestion-time partitioned table.")
    protected String partitionByField;
    @Name(value="operation")
    @Macro
    @Nullable
    @Description(value="Type of write operation to perform. This can be set to Insert, Update or Upsert.")
    protected String operation;
    @Name(value="relationTableKey")
    @Macro
    @Nullable
    @Description(value="List of fields that determines relation between tables during Update and Upsert operations.")
    protected String relationTableKey;
    @Name(value="dedupeBy")
    @Macro
    @Nullable
    @Description(value="Column names and sort order used to choose which input record to update/upsert when there are multiple input records with the same key. For example, if this is set to 'updated_time desc', then if there are multiple input records with the same key, the one with the largest value for 'updated_time' will be applied.")
    protected String dedupeBy;
    @Macro
    @Nullable
    @Description(value="Whether to create a table that requires a partition filter. This value is ignored if the table already exists.")
    protected Boolean partitionFilterRequired;
    @Name(value="clusteringOrder")
    @Macro
    @Nullable
    @Description(value="List of fields that determines the sort order of the data. Fields must be of type INT, LONG, STRING, DATE, TIMESTAMP, BOOLEAN or DECIMAL. Tables cannot be clustered on more than 4 fields. This value is only used when the BigQuery table is automatically created and ignored if the table already exists.")
    protected String clusteringOrder;
    @Name(value="partitionFilter")
    @Macro
    @Nullable
    @Description(value="Partition filter that can be used for partition elimination during Update or Upsert operations.This value is ignored if operation is not UPDATE or UPSERT.")
    protected String partitionFilter;

    @VisibleForTesting
    public BigQuerySinkConfig(@Nullable String referenceName, String dataset, String table, @Nullable String bucket, @Nullable String schema, @Nullable String partitioningType, @Nullable Long rangeStart, @Nullable Long rangeEnd, @Nullable Long rangeInterval, @Nullable String gcsChunkSize) {
        super(null, dataset, null, bucket);
        this.referenceName = referenceName;
        this.table = table;
        this.schema = schema;
        this.partitioningType = partitioningType;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.rangeInterval = rangeInterval;
        this.gcsChunkSize = gcsChunkSize;
    }

    private BigQuerySinkConfig(@Nullable String referenceName, @Nullable String project, @Nullable String serviceAccountType, @Nullable String serviceFilePath, @Nullable String serviceAccountJson, @Nullable String dataset, @Nullable String table, @Nullable String location, @Nullable String cmekKey, @Nullable String bucket) {
        super(new BigQueryConnectorConfig(project, project, serviceAccountType, serviceFilePath, serviceAccountJson), dataset, cmekKey, bucket);
        this.referenceName = referenceName;
        this.table = table;
        this.location = location;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public boolean shouldCreatePartitionedTable() {
        return this.getPartitioningType() != PartitionType.NONE;
    }

    @Nullable
    public String getPartitionByField() {
        return Strings.isNullOrEmpty((String)this.partitionByField) ? null : this.partitionByField;
    }

    public boolean isPartitionFilterRequired() {
        return this.partitionFilterRequired == null ? false : this.partitionFilterRequired;
    }

    @Nullable
    public String getClusteringOrder() {
        return Strings.isNullOrEmpty((String)this.clusteringOrder) ? null : this.clusteringOrder;
    }

    public Operation getOperation() {
        return Strings.isNullOrEmpty((String)this.operation) ? Operation.INSERT : Operation.valueOf(this.operation.toUpperCase());
    }

    @Nullable
    public String getRelationTableKey() {
        return Strings.isNullOrEmpty((String)this.relationTableKey) ? null : this.relationTableKey;
    }

    @Nullable
    public String getDedupeBy() {
        return Strings.isNullOrEmpty((String)this.dedupeBy) ? null : this.dedupeBy;
    }

    @Nullable
    public String getPartitionFilter() {
        if (Strings.isNullOrEmpty((String)this.partitionFilter)) {
            return null;
        }
        this.partitionFilter = this.partitionFilter.trim();
        if (this.partitionFilter.toUpperCase().startsWith(WHERE)) {
            this.partitionFilter = this.partitionFilter.substring(WHERE.length());
        }
        return this.partitionFilter;
    }

    @Nullable
    public Long getRangeStart() {
        return this.rangeStart;
    }

    @Nullable
    public Long getRangeEnd() {
        return this.rangeEnd;
    }

    @Nullable
    public Long getRangeInterval() {
        return this.rangeInterval;
    }

    public PartitionType getPartitioningType() {
        if (this.createPartitionedTable != null && this.createPartitionedTable.booleanValue()) {
            return PartitionType.TIME;
        }
        return Strings.isNullOrEmpty((String)this.partitioningType) ? PartitionType.TIME : PartitionType.valueOf(this.partitioningType.toUpperCase());
    }

    @Nullable
    public Schema getSchema(FailureCollector collector) {
        if (Strings.isNullOrEmpty((String)this.schema)) {
            return null;
        }
        try {
            return Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(NAME_SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    @Override
    public void validate(FailureCollector collector, Map<String, String> arguments) {
        super.validate(collector, arguments);
        if (!this.containsMacro(NAME_TABLE)) {
            BigQueryUtil.validateTable(this.table, NAME_TABLE, collector);
        }
        if (this.getWriteDisposition().equals((Object)JobInfo.WriteDisposition.WRITE_TRUNCATE) && !this.getOperation().equals((Object)Operation.INSERT)) {
            collector.addFailure("Truncate must only be used with operation 'Insert'.", "Set Truncate to false, or change the Operation to 'Insert'.").withConfigProperty("truncateTable").withConfigProperty(NAME_OPERATION);
        }
    }

    public void validate(@Nullable Schema inputSchema, @Nullable Schema outputSchema, FailureCollector collector, Map<String, String> arguments) {
        this.validate(collector, arguments);
        if (!this.containsMacro(NAME_SCHEMA)) {
            Schema schema = outputSchema == null ? inputSchema : outputSchema;
            this.validatePartitionProperties(schema, collector);
            this.validateClusteringOrder(schema, collector);
            this.validateOperationProperties(schema, collector);
            if (outputSchema == null) {
                return;
            }
            List<String> schemaFields = Objects.requireNonNull(schema.getFields()).stream().map(Schema.Field::getName).map(String::toLowerCase).collect(Collectors.toList());
            Set<String> duplicatedFields = BigQuerySinkUtils.getDuplicatedFields(schemaFields);
            for (Schema.Field field : outputSchema.getFields()) {
                String name = field.getName();
                if (!FIELD_PATTERN.matcher(name).matches()) {
                    collector.addFailure(String.format("Output field '%s' must only contain alphanumeric characters and '_'.", name), null).withOutputSchemaField(name);
                }
                if (!field.getSchema().isNullable() && inputSchema != null && inputSchema.getField(field.getName()) == null) {
                    collector.addFailure(String.format("Required output field '%s' must be present in input schema.", field.getName()), "Change the field to be nullable.").withOutputSchemaField(name);
                }
                if (!duplicatedFields.contains(name.toLowerCase())) continue;
                collector.addFailure(String.format("Output field '%s' is duplicated.", name), "BigQuery is case insensitive and does not allow two fields with the same name.").withOutputSchemaField(name);
            }
        }
    }

    private void validatePartitionProperties(@Nullable Schema schema, FailureCollector collector) {
        if (this.tryGetProject() == null) {
            return;
        }
        String project = this.getDatasetProject();
        String dataset = this.getDataset();
        String tableName = this.getTable();
        String serviceAccount = this.getServiceAccount();
        if (project == null || dataset == null || tableName == null || serviceAccount == null) {
            return;
        }
        Table table = BigQueryUtil.getBigQueryTable(project, dataset, tableName, serviceAccount, this.isServiceAccountFilePath(), collector);
        if (table != null) {
            StandardTableDefinition tableDefinition = (StandardTableDefinition)table.getDefinition();
            TimePartitioning timePartitioning = tableDefinition.getTimePartitioning();
            if (timePartitioning == null && this.createPartitionedTable != null && this.createPartitionedTable.booleanValue()) {
                LOG.warn(String.format("The plugin is configured to auto-create a partitioned table, but table '%s' already exists without partitioning. Please verify the partitioning configuration.", table.getTableId().getTable()));
            }
            RangePartitioning rangePartitioning = tableDefinition.getRangePartitioning();
            if (timePartitioning == null && rangePartitioning == null && this.shouldCreatePartitionedTable()) {
                LOG.warn(String.format("The plugin is configured to auto-create a partitioned table, but table '%s' already exists without partitioning. Please verify the partitioning configuration.", table.getTableId().getTable()));
            } else if (timePartitioning != null) {
                this.validateTimePartitionTableWithInputConfiguration(table, timePartitioning, collector);
            } else if (rangePartitioning != null) {
                this.validateRangePartitionTableWithInputConfiguration(table, rangePartitioning, collector);
            }
            this.validateColumnForPartition(this.partitionByField, schema, collector);
            return;
        }
        if (this.shouldCreatePartitionedTable()) {
            this.validateColumnForPartition(this.partitionByField, schema, collector);
        }
    }

    private void validateTimePartitionTableWithInputConfiguration(Table table, TimePartitioning timePartitioning, FailureCollector collector) {
        PartitionType partitioningType = this.getPartitioningType();
        if (partitioningType == PartitionType.TIME && timePartitioning.getField() != null && !timePartitioning.getField().equals(this.partitionByField)) {
            collector.addFailure(String.format("Destination table '%s' is partitioned by column '%s'.", table.getTableId().getTable(), timePartitioning.getField()), String.format("Set the partition field to '%s'.", timePartitioning.getField())).withConfigProperty(NAME_PARTITION_BY_FIELD);
        } else if (partitioningType != PartitionType.TIME) {
            LOG.warn(String.format("The plugin is configured to %s, but table '%s' already exists with Time partitioning. Please verify the partitioning configuration.", partitioningType == PartitionType.INTEGER ? "auto-create a Integer partitioned table" : "auto-create table without partition", table.getTableId().getTable()));
        }
    }

    private void validateRangePartitionTableWithInputConfiguration(Table table, RangePartitioning rangePartitioning, FailureCollector collector) {
        PartitionType partitioningType = this.getPartitioningType();
        if (partitioningType != PartitionType.INTEGER) {
            LOG.warn(String.format("The plugin is configured to %s, but table '%s' already exists with Integer partitioning. Please verify the partitioning configuration.", partitioningType == PartitionType.TIME ? "auto-create a Time partitioned table" : "auto-create table without partition", table.getTableId().getTable()));
        } else if (rangePartitioning.getField() != null && !rangePartitioning.getField().equals(this.partitionByField)) {
            collector.addFailure(String.format("Destination table '%s' is partitioned by column '%s'.", table.getTableId().getTable(), rangePartitioning.getField()), String.format("Set the partition field to '%s'.", rangePartitioning.getField())).withConfigProperty(NAME_PARTITION_BY_FIELD);
        }
    }

    private void validateColumnForPartition(@Nullable String columnName, @Nullable Schema schema, FailureCollector collector) {
        if (this.containsMacro(NAME_PARTITION_BY_FIELD) || this.containsMacro(NAME_PARTITIONING_TYPE) || schema == null) {
            return;
        }
        PartitionType partitioningType = this.getPartitioningType();
        if (Strings.isNullOrEmpty((String)columnName)) {
            if (partitioningType == PartitionType.INTEGER) {
                collector.addFailure("Partition column not provided.", "Set the column for integer partitioning.").withConfigProperty(NAME_PARTITION_BY_FIELD);
            }
            return;
        }
        Schema.Field field = schema.getField(columnName);
        if (field == null) {
            collector.addFailure(String.format("Partition column '%s' must be present in the schema.", columnName), "Change the Partition column to be one of the schema fields.").withConfigProperty(NAME_PARTITION_BY_FIELD);
            return;
        }
        Schema fieldSchema = field.getSchema();
        Schema schema2 = fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
        if (partitioningType == PartitionType.TIME) {
            this.validateTimePartitioningColumn(columnName, collector, fieldSchema);
        } else if (partitioningType == PartitionType.INTEGER) {
            this.validateIntegerPartitioningColumn(columnName, collector, fieldSchema);
            this.validateIntegerPartitioningRange(this.getRangeStart(), this.getRangeEnd(), this.getRangeInterval(), collector);
        }
    }

    private void validateIntegerPartitioningColumn(String columnName, FailureCollector collector, Schema fieldSchema) {
        if (fieldSchema.getType() != Schema.Type.INT && fieldSchema.getType() != Schema.Type.LONG) {
            collector.addFailure(String.format("Partition column '%s' is of invalid type '%s'.", columnName, fieldSchema.getDisplayName()), "Partition column must be a int  or long.").withConfigProperty(NAME_PARTITION_BY_FIELD).withOutputSchemaField(columnName).withInputSchemaField(columnName);
        }
    }

    private void validateTimePartitioningColumn(String columnName, FailureCollector collector, Schema fieldSchema) {
        Schema.LogicalType logicalType = fieldSchema.getLogicalType();
        if (logicalType != Schema.LogicalType.DATE && logicalType != Schema.LogicalType.TIMESTAMP_MICROS && logicalType != Schema.LogicalType.TIMESTAMP_MILLIS) {
            collector.addFailure(String.format("Partition column '%s' is of invalid type '%s'.", columnName, fieldSchema.getDisplayName()), "Partition column must be a date or timestamp.").withConfigProperty(NAME_PARTITION_BY_FIELD).withOutputSchemaField(columnName).withInputSchemaField(columnName);
        }
    }

    private void validateIntegerPartitioningRange(Long rangeStart, Long rangeEnd, Long rangeInterval, FailureCollector collector) {
        if (!this.containsMacro(NAME_RANGE_START) && rangeStart == null) {
            collector.addFailure("Range Start is not defined.", "For Integer Partitioning, Range Start must be defined.").withConfigProperty(NAME_RANGE_START);
        }
        if (!this.containsMacro(NAME_RANGE_END) && rangeEnd == null) {
            collector.addFailure("Range End is not defined.", "For Integer Partitioning, Range End must be defined.").withConfigProperty(NAME_RANGE_END);
        }
        if (!this.containsMacro(NAME_RANGE_INTERVAL)) {
            if (rangeInterval == null) {
                collector.addFailure("Range Interval is not defined.", "For Integer Partitioning, Range Interval must be defined.").withConfigProperty(NAME_RANGE_INTERVAL);
            } else if (rangeInterval <= 0L) {
                collector.addFailure("Range Interval is not a positive number.", "Range interval must be a valid positive integer.").withConfigProperty(NAME_RANGE_INTERVAL);
            }
        }
    }

    private void validateClusteringOrder(@Nullable Schema schema, FailureCollector collector) {
        if (!this.shouldCreatePartitionedTable() || Strings.isNullOrEmpty((String)this.clusteringOrder) || schema == null) {
            return;
        }
        if (!this.containsMacro(NAME_PARTITION_BY_FIELD) && !this.containsMacro(NAME_CLUSTERING_ORDER) && !Strings.isNullOrEmpty((String)this.clusteringOrder) && Strings.isNullOrEmpty((String)this.partitionByField)) {
            collector.addFailure(String.format("Clustering order cannot be validated.", new Object[0]), "Partition field must have a value.");
            return;
        }
        List columnsNames = Arrays.stream(this.clusteringOrder.split(",")).map(String::trim).collect(Collectors.toList());
        if (columnsNames.size() > 4) {
            collector.addFailure(String.format("Found '%d' number of clustering fields.", columnsNames.size()), String.format("Expected at most '%d' clustering fields.", 4)).withConfigProperty(NAME_CLUSTERING_ORDER);
            return;
        }
        for (String column : columnsNames) {
            Schema.Field field = schema.getField(column);
            if (field == null) {
                collector.addFailure(String.format("Clustering field '%s' does not exist in the schema.", column), "Ensure all clustering fields exist in the schema.").withConfigElement(NAME_CLUSTERING_ORDER, column);
                continue;
            }
            Schema nonNullSchema = BigQueryUtil.getNonNullableSchema(field.getSchema());
            Schema.Type type = nonNullSchema.getType();
            Schema.LogicalType logicalType = nonNullSchema.getLogicalType();
            if (SUPPORTED_CLUSTERING_TYPES.contains(type) || BigQuerySinkUtils.isSupportedLogicalType(logicalType)) continue;
            collector.addFailure(String.format("Field '%s' is of unsupported type '%s'.", column, nonNullSchema.getDisplayName()), "Supported types are : string, bytes, int, long, boolean, date, timestamp and decimal.").withConfigElement(NAME_CLUSTERING_ORDER, column).withInputSchemaField(column).withOutputSchemaField(column);
        }
    }

    private void validateOperationProperties(@Nullable Schema schema, FailureCollector collector) {
        if (this.containsMacro(NAME_OPERATION) || this.containsMacro(NAME_TABLE_KEY) || this.containsMacro(NAME_DEDUPE_BY)) {
            return;
        }
        Operation operation = this.getOperation();
        if (Arrays.stream(Operation.values()).noneMatch(operation::equals)) {
            collector.addFailure(String.format("Operation has incorrect value '%s'.", new Object[]{operation}), "Set the operation to 'Insert', 'Update', or 'Upsert'.").withConfigElement(NAME_OPERATION, operation.name().toLowerCase());
            return;
        }
        if (Operation.INSERT.equals((Object)operation)) {
            return;
        }
        if ((Operation.UPDATE.equals((Object)operation) || Operation.UPSERT.equals((Object)operation)) && this.getRelationTableKey() == null) {
            collector.addFailure("Table key must be set if the operation is 'Update' or 'Upsert'.", null).withConfigProperty(NAME_TABLE_KEY).withConfigProperty(NAME_OPERATION);
            return;
        }
        if (schema == null) {
            return;
        }
        List fields = Objects.requireNonNull(schema.getFields()).stream().map(Schema.Field::getName).collect(Collectors.toList());
        List<String> keyFields = Arrays.stream(Objects.requireNonNull(this.getRelationTableKey()).split(",")).map(String::trim).collect(Collectors.toList());
        for (String keyField : keyFields) {
            if (fields.contains(keyField)) continue;
            collector.addFailure(String.format("Table key field '%s' does not exist in the schema.", keyField), "Change the Table key field to be one of the schema fields.").withConfigElement(NAME_TABLE_KEY, keyField);
        }
        Map<String, Integer> keyMap = BigQuerySinkUtils.calculateDuplicates(keyFields);
        keyMap.keySet().stream().filter(key -> (Integer)keyMap.get(key) != 1).forEach(key -> collector.addFailure(String.format("Table key field '%s' is duplicated.", key), String.format("Remove duplicates of Table key field '%s'.", key)).withConfigElement(NAME_TABLE_KEY, key));
        if ((Operation.UPDATE.equals((Object)operation) || Operation.UPSERT.equals((Object)operation)) && this.getDedupeBy() != null) {
            List<String> dedupeByList = Arrays.stream(Objects.requireNonNull(this.getDedupeBy()).split(",")).collect(Collectors.toList());
            dedupeByList.stream().filter(v -> !fields.contains(v.split(" ")[0])).forEach(v -> collector.addFailure(String.format("Dedupe by field '%s' does not exist in the schema.", v.split(" ")[0]), "Change the Dedupe by field to be one of the schema fields.").withConfigElement(NAME_DEDUPE_BY, v));
            Map<String, Integer> orderedByFieldMap = BigQuerySinkUtils.calculateDuplicates(dedupeByList);
            Map<String, String> orderedByFieldValueMap = dedupeByList.stream().collect(Collectors.toMap(p -> p.split(" ")[0], p -> p, (x, y) -> y));
            orderedByFieldMap.keySet().stream().filter(key -> (Integer)orderedByFieldMap.get(key) != 1).forEach(key -> collector.addFailure(String.format("Dedupe by field '%s' is duplicated.", key), String.format("Remove duplicates of Dedupe by field '%s'.", key)).withConfigElement(NAME_DEDUPE_BY, (String)orderedByFieldValueMap.get(key)));
        }
    }

    @Override
    void validateCmekKey(FailureCollector failureCollector, Map<String, String> arguments) {
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.cmekKey, arguments, failureCollector);
        if (this.containsMacro("location") || this.containsMacro(NAME_TABLE) || Strings.isNullOrEmpty((String)this.table)) {
            return;
        }
        this.validateCmekKeyLocation(cmekKeyName, this.getTable(), this.location, failureCollector);
    }

    boolean shouldConnect() {
        return !this.containsMacro("dataset") && !this.containsMacro(NAME_TABLE) && this.connection != null && this.connection.canConnect() && !this.containsMacro(NAME_SCHEMA);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String referenceName;
        private String serviceAccountType;
        private String serviceFilePath;
        private String serviceAccountJson;
        private String project;
        private String dataset;
        private String table;
        private String cmekKey;
        private String location;
        private String bucket;

        public Builder setReferenceName(@Nullable String referenceName) {
            this.referenceName = referenceName;
            return this;
        }

        public Builder setProject(@Nullable String project) {
            this.project = project;
            return this;
        }

        public Builder setServiceAccountType(@Nullable String serviceAccountType) {
            this.serviceAccountType = serviceAccountType;
            return this;
        }

        public Builder setServiceFilePath(@Nullable String serviceFilePath) {
            this.serviceFilePath = serviceFilePath;
            return this;
        }

        public Builder setServiceAccountJson(@Nullable String serviceAccountJson) {
            this.serviceAccountJson = serviceAccountJson;
            return this;
        }

        public Builder setDataset(@Nullable String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTable(@Nullable String table) {
            this.table = table;
            return this;
        }

        public Builder setCmekKey(@Nullable String cmekKey) {
            this.cmekKey = cmekKey;
            return this;
        }

        public Builder setLocation(@Nullable String location) {
            this.location = location;
            return this;
        }

        public Builder setBucket(@Nullable String bucket) {
            this.bucket = bucket;
            return this;
        }

        public BigQuerySinkConfig build() {
            return new BigQuerySinkConfig(this.referenceName, this.project, this.serviceAccountType, this.serviceFilePath, this.serviceAccountJson, this.dataset, this.table, this.location, this.cmekKey, this.bucket);
        }
    }
}

