/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DelegatingMultiSinkOutputCommitter
extends OutputCommitter {
    private final Map<String, OutputCommitter> committerMap;
    private final Map<String, Schema> schemaMap;
    private final String projectName;
    private final String datasetName;
    private final String bucketName;
    private final String bucketPathUniqueId;

    public DelegatingMultiSinkOutputCommitter(String projectName, String datasetName, String bucketName, String bucketPathUniqueId) {
        this.projectName = projectName;
        this.datasetName = datasetName;
        this.bucketName = bucketName;
        this.bucketPathUniqueId = bucketPathUniqueId;
        this.committerMap = new HashMap<String, OutputCommitter>();
        this.schemaMap = new HashMap<String, Schema>();
    }

    public void addCommitterAndSchema(OutputCommitter committer, String tableName, Schema schema, TaskAttemptContext context) throws IOException, InterruptedException {
        this.committerMap.put(tableName, committer);
        this.schemaMap.put(tableName, schema);
        committer.setupJob((JobContext)context);
        committer.setupTask(context);
    }

    public void setupJob(JobContext jobContext) throws IOException {
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
        if (this.committerMap.isEmpty()) {
            return false;
        }
        boolean needsTaskCommit = true;
        for (OutputCommitter committer : this.committerMap.values()) {
            needsTaskCommit = needsTaskCommit && committer.needsTaskCommit(taskAttemptContext);
        }
        return needsTaskCommit;
    }

    public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        for (String tableName : this.committerMap.keySet()) {
            this.configureContext((JobContext)taskAttemptContext, tableName);
            this.committerMap.get(tableName).commitTask(taskAttemptContext);
        }
    }

    public void commitJob(JobContext jobContext) throws IOException {
        for (String tableName : this.committerMap.keySet()) {
            this.configureContext(jobContext, tableName);
            this.committerMap.get(tableName).commitJob(jobContext);
        }
    }

    public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        IOException ioe = null;
        for (OutputCommitter committer : this.committerMap.values()) {
            try {
                committer.abortTask(taskAttemptContext);
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        IOException ioe = null;
        for (OutputCommitter committer : this.committerMap.values()) {
            try {
                committer.abortJob(jobContext, state);
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void configureContext(JobContext context, String tableName) throws IOException {
        Schema schema = this.schemaMap.get(tableName);
        List<BigQueryTableFieldSchema> fields = BigQuerySinkUtils.getBigQueryTableFieldsFromSchema(schema);
        String gcsPath = BigQuerySinkUtils.getTemporaryGcsPath(this.bucketName, this.bucketPathUniqueId, tableName);
        BigQuerySinkUtils.configureMultiSinkOutput(context.getConfiguration(), DatasetId.of((String)this.projectName, (String)this.datasetName), tableName, gcsPath, fields);
    }
}

