/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.cloud.bigquery.DatasetId;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.plugin.gcp.bigquery.sink.DelegatingMultiSinkOutputCommitter;
import io.cdap.plugin.gcp.bigquery.sink.DelegatingMultiSinkRecordWriter;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DelegatingMultiSinkOutputFormat
extends OutputFormat<StructuredRecord, NullWritable> {
    private static final String TABLENAME_FIELD = "bq.delegating.multi.tablename.field";
    private static final String BUCKET_NAME = "bq.delegating.multi.bucket";
    private static final String BUCKET_PATH_UNIQUE_ID = "bq.delegating.multi.bucket.path.uuid";
    private static final String PROJECT_NAME = "bq.delegating.multi.project";
    private static final String DATASET_NAME = "bq.delegating.multi.dataset";
    private DelegatingMultiSinkOutputCommitter delegatingMultiSinkOutputCommitter = null;

    public static void configure(Configuration conf, String filterField, String bucketName, String projectName, String datasetName) {
        conf.set(TABLENAME_FIELD, filterField);
        conf.set(BUCKET_NAME, bucketName);
        conf.set(BUCKET_PATH_UNIQUE_ID, UUID.randomUUID().toString());
        conf.set(PROJECT_NAME, projectName);
        conf.set(DATASET_NAME, datasetName);
    }

    public RecordWriter<StructuredRecord, NullWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) {
        Configuration conf = taskAttemptContext.getConfiguration();
        String tableNameField = conf.get(TABLENAME_FIELD);
        String bucketName = conf.get(BUCKET_NAME);
        String bucketPathUniqueId = conf.get(BUCKET_PATH_UNIQUE_ID);
        String projectName = conf.get(PROJECT_NAME);
        String datasetName = conf.get(DATASET_NAME);
        return new DelegatingMultiSinkRecordWriter(taskAttemptContext, tableNameField, bucketName, bucketPathUniqueId, DatasetId.of((String)projectName, (String)datasetName), this.getOutputCommitterInstance(taskAttemptContext));
    }

    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) {
        return this.getOutputCommitterInstance(taskAttemptContext);
    }

    private DelegatingMultiSinkOutputCommitter getOutputCommitterInstance(TaskAttemptContext taskAttemptContext) {
        if (this.delegatingMultiSinkOutputCommitter == null) {
            Configuration conf = taskAttemptContext.getConfiguration();
            String projectName = conf.get(PROJECT_NAME);
            String datasetName = conf.get(DATASET_NAME);
            String bucketName = conf.get(BUCKET_NAME);
            String bucketPathUniqueId = conf.get(BUCKET_PATH_UNIQUE_ID);
            this.delegatingMultiSinkOutputCommitter = new DelegatingMultiSinkOutputCommitter(projectName, datasetName, bucketName, bucketPathUniqueId);
        }
        return this.delegatingMultiSinkOutputCommitter;
    }
}

