/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryOutputFormat;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sink.DelegatingMultiSinkOutputCommitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DelegatingMultiSinkRecordWriter
extends RecordWriter<StructuredRecord, NullWritable> {
    private final TaskAttemptContext initialContext;
    private final String tableNameField;
    private final String bucketName;
    private final String bucketPathUniqueId;
    private final DatasetId datasetId;
    private final Map<String, RecordWriter<StructuredRecord, NullWritable>> delegateMap;
    private final DelegatingMultiSinkOutputCommitter delegatingOutputCommitter;

    public DelegatingMultiSinkRecordWriter(TaskAttemptContext initialContext, String tableNameField, String bucketName, String bucketPathUniqueId, DatasetId datasetId, DelegatingMultiSinkOutputCommitter delegatingMultiSinkOutputCommitter) {
        this.initialContext = initialContext;
        this.tableNameField = tableNameField;
        this.bucketName = bucketName;
        this.bucketPathUniqueId = bucketPathUniqueId;
        this.datasetId = datasetId;
        this.delegateMap = new HashMap<String, RecordWriter<StructuredRecord, NullWritable>>();
        this.delegatingOutputCommitter = delegatingMultiSinkOutputCommitter;
    }

    public void write(StructuredRecord key, NullWritable value) throws IOException, InterruptedException {
        String tableName = (String)key.get(this.tableNameField);
        RecordWriter<StructuredRecord, NullWritable> delegate = this.delegateMap.containsKey(tableName) ? this.delegateMap.get(tableName) : this.getRecordWriterDelegate(tableName, key.getSchema());
        delegate.write((Object)key, (Object)value);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        for (RecordWriter<StructuredRecord, NullWritable> delegate : this.delegateMap.values()) {
            delegate.close(context);
        }
        this.delegatingOutputCommitter.commitTask(this.initialContext);
        this.delegatingOutputCommitter.commitJob((JobContext)this.initialContext);
    }

    public RecordWriter<StructuredRecord, NullWritable> getRecordWriterDelegate(String tableName, Schema schema) throws IOException, InterruptedException {
        List<BigQueryTableFieldSchema> fields = BigQuerySinkUtils.getBigQueryTableFieldsFromSchema(schema);
        String gcsPath = BigQuerySinkUtils.getTemporaryGcsPath(this.bucketName, this.bucketPathUniqueId, tableName);
        BigQuerySinkUtils.configureMultiSinkOutput(this.initialContext.getConfiguration(), this.datasetId, tableName, gcsPath, fields);
        BigQueryOutputFormat bqOutputFormat = new BigQueryOutputFormat();
        OutputCommitter bqOutputCommitter = bqOutputFormat.getOutputCommitter(this.initialContext);
        this.delegatingOutputCommitter.addCommitterAndSchema(bqOutputCommitter, tableName, schema, this.initialContext);
        RecordWriter<StructuredRecord, NullWritable> delegate = bqOutputFormat.getRecordWriter(this.initialContext, schema);
        this.delegateMap.put(tableName, delegate);
        return delegate;
    }
}

