/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryOutputFormat;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MultiSinkOutputFormatProvider
implements OutputFormatProvider {
    private static final String FILTER_FIELD = "bq.multi.record.filter.field";
    private static final String FILTER_VALUE = "bq.multi.record.filter.value";
    private final Configuration config;

    public MultiSinkOutputFormatProvider(Configuration config, String tableName, io.cdap.cdap.api.data.schema.Schema tableSchema, String filterField) {
        this.config = new Configuration(config);
        this.config.set(FILTER_VALUE, tableName);
        this.config.set(FILTER_FIELD, filterField);
        this.config.set("cdap.bq.sink.output.schema", tableSchema.toString());
    }

    public String getOutputFormatClassName() {
        return MultiSinkOutputFormatDelegate.class.getName();
    }

    public Map<String, String> getOutputFormatConfiguration() {
        Map<String, String> map = BigQueryUtil.configToMap(this.config);
        map.put("mapreduce.job.output.key.class", AvroKey.class.getName());
        return map;
    }

    public static class FilterRecordWriter
    extends RecordWriter<StructuredRecord, NullWritable> {
        private final String filterField;
        private final String filterValue;
        private final io.cdap.cdap.api.data.schema.Schema schema;
        private final RecordWriter<StructuredRecord, NullWritable> delegate;

        public FilterRecordWriter(String filterField, String filterValue, io.cdap.cdap.api.data.schema.Schema schema, RecordWriter<StructuredRecord, NullWritable> delegate) {
            this.filterField = filterField;
            this.filterValue = filterValue;
            this.schema = schema;
            this.delegate = delegate;
        }

        public void write(StructuredRecord key, NullWritable value) throws IOException, InterruptedException {
            Object objectValue = key.get(this.filterField);
            if (objectValue == null) {
                return;
            }
            String name = (String)objectValue;
            String[] split = name.split("\\.");
            if (split.length == 2) {
                name = split[1];
            }
            if (!this.filterValue.equalsIgnoreCase(name)) {
                return;
            }
            StructuredRecord.Builder builder = StructuredRecord.builder((io.cdap.cdap.api.data.schema.Schema)this.schema);
            key.getSchema().getFields().stream().filter(entry -> !this.filterField.equals(entry.getName())).filter(entry -> this.schema.getField(entry.getName()) != null).forEach(entry -> builder.set(entry.getName(), key.get(entry.getName())));
            this.delegate.write((Object)builder.build(), (Object)value);
        }

        private Schema getAvroSchema(io.cdap.cdap.api.data.schema.Schema cdapSchema) {
            return new Schema.Parser().parse(cdapSchema.toString());
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.delegate.close(context);
        }
    }

    public static class MultiSinkOutputFormatDelegate
    extends OutputFormat<StructuredRecord, NullWritable> {
        private final OutputFormat<StructuredRecord, NullWritable> delegate = new BigQueryOutputFormat();

        public RecordWriter<StructuredRecord, NullWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            Configuration conf = taskAttemptContext.getConfiguration();
            String filterField = conf.get(MultiSinkOutputFormatProvider.FILTER_FIELD);
            String filterValue = conf.get(MultiSinkOutputFormatProvider.FILTER_VALUE);
            io.cdap.cdap.api.data.schema.Schema schema = io.cdap.cdap.api.data.schema.Schema.parseJson((String)conf.get("cdap.bq.sink.output.schema"));
            RecordWriter recordWriter = this.delegate.getRecordWriter(taskAttemptContext);
            return new FilterRecordWriter(filterField, filterValue, schema, (RecordWriter<StructuredRecord, NullWritable>)recordWriter);
        }

        public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
            this.delegate.checkOutputSpecs(jobContext);
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return this.delegate.getOutputCommitter(taskAttemptContext);
        }
    }
}

