/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.source;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.common.RecordConverter;
import io.cdap.plugin.gcp.bigquery.source.BigQuerySourceConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;

public class BigQueryAvroToStructuredTransformer
extends RecordConverter<GenericRecord, StructuredRecord> {
    private Schema genericRecordSchema;

    public StructuredRecord transform(GenericRecord genericRecord) throws IOException {
        if (this.genericRecordSchema == null) {
            this.genericRecordSchema = Schema.parseJson((String)genericRecord.getSchema().toString());
        }
        return this.transform(genericRecord, this.genericRecordSchema);
    }

    public StructuredRecord transform(GenericRecord genericRecord, Schema structuredSchema) throws IOException {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)structuredSchema);
        for (Schema.Field field : structuredSchema.getFields()) {
            String fieldName = field.getName();
            Object value = this.convertField(genericRecord.get(fieldName), field);
            builder.set(fieldName, value);
        }
        return builder.build();
    }

    @Nullable
    protected Object convertField(Object field, Schema fieldSchema) throws IOException {
        Schema.Type fieldType;
        block16: {
            if (field == null) {
                return null;
            }
            fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
            fieldType = fieldSchema.getType();
            Schema.LogicalType logicalType = fieldSchema.getLogicalType();
            try {
                if (logicalType == null) break block16;
                switch (logicalType) {
                    case DATE: {
                        return Math.toIntExact(LocalDate.parse(field.toString()).toEpochDay());
                    }
                    case TIME_MILLIS: {
                        return Math.toIntExact(TimeUnit.NANOSECONDS.toMillis(LocalTime.parse(field.toString()).toNanoOfDay()));
                    }
                    case TIME_MICROS: {
                        return TimeUnit.NANOSECONDS.toMicros(LocalTime.parse(field.toString()).toNanoOfDay());
                    }
                    case TIMESTAMP_MILLIS: 
                    case TIMESTAMP_MICROS: {
                        return field;
                    }
                    case DATETIME: {
                        try {
                            LocalDateTime.parse(field.toString());
                        }
                        catch (DateTimeParseException exception) {
                            throw new UnexpectedFormatException(String.format("Datetime field with value '%s' is not in ISO-8601 format.", fieldSchema.getDisplayName(), field.toString()), (Throwable)exception);
                        }
                        return field.toString();
                    }
                    case DECIMAL: {
                        ByteBuffer value = (ByteBuffer)field;
                        byte[] bytes = new byte[value.remaining()];
                        int pos = value.position();
                        value.get(bytes);
                        value.position(pos);
                        return bytes;
                    }
                }
                throw new UnexpectedFormatException("Field type '" + fieldSchema.getDisplayName() + "' is not supported.");
            }
            catch (ArithmeticException e) {
                throw new IOException("Field type %s has value that is too large." + fieldType);
            }
        }
        if (!BigQuerySourceConfig.SUPPORTED_TYPES.contains(fieldType)) {
            throw new UnexpectedFormatException("Field type " + fieldType + " is not supported.");
        }
        if (fieldSchema.getType() == Schema.Type.RECORD && field instanceof List) {
            List valuesList = (List)field;
            ArrayList<Object> resultList = new ArrayList<Object>(valuesList.size());
            for (Object value : valuesList) {
                resultList.add(super.convertField(value, fieldSchema));
            }
            return resultList;
        }
        return super.convertField(field, fieldSchema);
    }

    protected Object convertBytes(Object field) {
        return field instanceof ByteBuffer ? (Object)Bytes.toBytes((ByteBuffer)((ByteBuffer)field)) : field;
    }
}

