/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.source;

import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.util.AccessTokenProviderClassFromConfigFactory;
import com.google.cloud.hadoop.util.CredentialFromAccessTokenProviderClassFactory;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class BigQueryFactoryWithScopes
extends BigQueryFactory {
    private final List<String> scopes;

    public BigQueryFactoryWithScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public Credential createBigQueryCredential(Configuration config) throws GeneralSecurityException, IOException {
        Credential credential = CredentialFromAccessTokenProviderClassFactory.credential((AccessTokenProviderClassFromConfigFactory)new AccessTokenProviderClassFromConfigFactory().withOverridePrefix("mapred.bq"), (Configuration)config, this.scopes);
        if (credential != null) {
            return credential;
        }
        return ((HadoopCredentialConfiguration)((HadoopCredentialConfiguration.Builder)HadoopCredentialConfiguration.newBuilder().withConfiguration(config).withOverridePrefix("mapred.bq")).build()).getCredential(this.scopes);
    }
}

