/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.source;

import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.Storage;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Metadata;
import io.cdap.cdap.api.annotation.MetadataProperty;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Input;
import io.cdap.cdap.api.data.batch.InputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.StageConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchRuntimeContext;
import io.cdap.cdap.etl.api.batch.BatchSource;
import io.cdap.cdap.etl.api.batch.BatchSourceContext;
import io.cdap.cdap.etl.api.engine.sql.SQLEngineInput;
import io.cdap.cdap.etl.api.validation.ValidationFailure;
import io.cdap.plugin.common.Asset;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.gcp.bigquery.source.BigQueryAvroToStructuredTransformer;
import io.cdap.plugin.gcp.bigquery.source.BigQueryInputFormatProvider;
import io.cdap.plugin.gcp.bigquery.source.BigQuerySourceConfig;
import io.cdap.plugin.gcp.bigquery.source.BigQuerySourceUtils;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLEngine;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="batchsource")
@Name(value="BigQueryTable")
@Description(value="This source reads the entire contents of a BigQuery table. BigQuery is Google's serverless, highly scalable, enterprise data warehouse.Data is first written to a temporary location on Google Cloud Storage, then read into the pipeline from there.")
@Metadata(properties={@MetadataProperty(key="connector", value="BigQuery")})
public final class BigQuerySource
extends BatchSource<LongWritable, GenericData.Record, StructuredRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySource.class);
    private static final Gson GSON = new Gson();
    public static final String NAME = "BigQueryTable";
    private BigQuerySourceConfig config;
    private io.cdap.cdap.api.data.schema.Schema outputSchema;
    private Configuration configuration;
    private final BigQueryAvroToStructuredTransformer transformer = new BigQueryAvroToStructuredTransformer();
    private String bucketPath;

    public void configurePipeline(PipelineConfigurer configurer) {
        super.configurePipeline(configurer);
        StageConfigurer stageConfigurer = configurer.getStageConfigurer();
        FailureCollector collector = stageConfigurer.getFailureCollector();
        this.config.validate(collector);
        io.cdap.cdap.api.data.schema.Schema configuredSchema = this.config.getSchema(collector);
        if (!this.config.canConnect() || this.config.isServiceAccountFilePath().booleanValue() && this.config.autoServiceAccountUnavailable() || this.config.tryGetProject() == null && this.config.getDatasetProject() == null) {
            stageConfigurer.setOutputSchema(configuredSchema);
            return;
        }
        io.cdap.cdap.api.data.schema.Schema schema = this.getSchema(collector);
        this.validatePartitionProperties(collector);
        if (configuredSchema == null) {
            stageConfigurer.setOutputSchema(schema);
            return;
        }
        this.validateConfiguredSchema(configuredSchema, collector);
        stageConfigurer.setOutputSchema(configuredSchema);
    }

    public void prepareRun(BatchSourceContext context) throws Exception {
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(collector, context.getArguments().asMap());
        if (this.getBQSchema(collector).getFields().isEmpty()) {
            collector.addFailure(String.format("BigQuery table %s.%s does not have a schema.", this.config.getDataset(), this.config.getTable()), "Please edit the table to add a schema.");
            collector.getOrThrowException();
        }
        io.cdap.cdap.api.data.schema.Schema configuredSchema = this.getOutputSchema(collector);
        String serviceAccount = this.config.getServiceAccount();
        Credentials credentials = BigQuerySourceUtils.getCredentials(this.config.getConnection());
        BigQuery bigQuery = GCPUtils.getBigQuery(this.config.getProject(), credentials);
        Dataset dataset = bigQuery.getDataset(DatasetId.of((String)this.config.getDatasetProject(), (String)this.config.getDataset()), new BigQuery.DatasetOption[0]);
        Storage storage = GCPUtils.getStorage(this.config.getProject(), credentials);
        this.bucketPath = UUID.randomUUID().toString();
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.config.cmekKey, context.getArguments().asMap(), collector);
        collector.getOrThrowException();
        this.configuration = BigQueryUtil.getBigQueryConfig(serviceAccount, this.config.getProject(), cmekKeyName, this.config.getServiceAccountType());
        String bucketName = BigQueryUtil.getStagingBucketName(context.getArguments().asMap(), null, dataset, this.config.getBucket());
        String bucket = BigQuerySourceUtils.getOrCreateBucket(this.configuration, storage, bucketName, dataset, this.bucketPath, cmekKeyName);
        BigQuerySourceUtils.configureServiceAccount(this.configuration, this.config.getConnection());
        this.configureBigQuerySource();
        String temporaryGcsPath = BigQuerySourceUtils.getTemporaryGcsPath(bucket, this.bucketPath, this.bucketPath);
        BigQuerySourceUtils.configureBigQueryInput(this.configuration, DatasetId.of((String)this.config.getDatasetProject(), (String)this.config.getDataset()), this.config.getTable(), temporaryGcsPath);
        TableDefinition.Type sourceTableType = this.config.getSourceTableType();
        Asset asset = Asset.builder((String)this.config.getReferenceName()).setFqn(BigQueryUtil.getFQN(this.config.getDatasetProject(), this.config.getDataset(), this.config.getTable())).setLocation(dataset.getLocation()).build();
        this.emitLineage(context, configuredSchema, sourceTableType, this.config.getTable(), asset);
        this.setInputFormat(context, configuredSchema);
    }

    public void initialize(BatchRuntimeContext context) throws Exception {
        super.initialize(context);
        this.outputSchema = this.config.getSchema(context.getFailureCollector());
    }

    public void transform(KeyValue<LongWritable, GenericData.Record> input, Emitter<StructuredRecord> emitter) throws Exception {
        StructuredRecord transformed = this.outputSchema == null ? this.transformer.transform((GenericRecord)input.getValue()) : this.transformer.transform((GenericRecord)input.getValue(), this.outputSchema);
        emitter.emit((Object)transformed);
    }

    public void onRunFinish(boolean succeeded, BatchSourceContext context) {
        BigQuerySourceUtils.deleteGcsTemporaryDirectory(this.configuration, this.config.getBucket(), this.bucketPath);
        BigQuerySourceUtils.deleteBigQueryTemporaryTable(this.configuration, this.config);
    }

    private void configureBigQuerySource() {
        if (this.config.getPartitionFrom() != null) {
            this.configuration.set("cdap.bq.source.partition.from.date", this.config.getPartitionFrom());
        }
        if (this.config.getPartitionTo() != null) {
            this.configuration.set("cdap.bq.source.partition.to.date", this.config.getPartitionTo());
        }
        if (this.config.getFilter() != null) {
            this.configuration.set("cdap.bq.source.filter", this.config.getFilter());
        }
        if (this.config.getViewMaterializationProject() != null) {
            this.configuration.set("cdap.bq.source.view.materialization.project", this.config.getViewMaterializationProject());
        }
        if (this.config.getViewMaterializationDataset() != null) {
            this.configuration.set("cdap.bq.source.view.materialization.dataset", this.config.getViewMaterializationDataset());
        }
    }

    public io.cdap.cdap.api.data.schema.Schema getSchema(FailureCollector collector) {
        Schema bqSchema = this.getBQSchema(collector);
        return BigQueryUtil.getTableSchema(bqSchema, collector);
    }

    private void validateConfiguredSchema(io.cdap.cdap.api.data.schema.Schema configuredSchema, FailureCollector collector) {
        String dataset = this.config.getDataset();
        String tableName = this.config.getTable();
        String project = this.config.getDatasetProject();
        Schema bqSchema = this.getBQSchema(collector);
        FieldList fields = bqSchema.getFields();
        for (Schema.Field field : configuredSchema.getFields()) {
            try {
                Field bqField = fields.get(field.getName());
                ValidationFailure failure = BigQueryUtil.validateFieldSchemaMatches(bqField, field, dataset, tableName, BigQuerySourceConfig.SUPPORTED_TYPES, collector);
                if (failure == null) continue;
                failure.withOutputSchemaField(field.getName());
            }
            catch (IllegalArgumentException e) {
                collector.addFailure(String.format("Field '%s' is not present in table '%s:%s.%s'.", field.getName(), project, dataset, tableName), String.format("Remove field '%s' from the output schema.", field.getName())).withOutputSchemaField(field.getName());
            }
        }
        collector.getOrThrowException();
    }

    private Schema getBQSchema(FailureCollector collector) {
        String serviceAccount = this.config.getServiceAccount();
        String dataset = this.config.getDataset();
        String tableName = this.config.getTable();
        String project = this.config.getDatasetProject();
        Table table = BigQueryUtil.getBigQueryTable(project, dataset, tableName, serviceAccount, this.config.isServiceAccountFilePath(), collector);
        if (table == null) {
            collector.addFailure(String.format("BigQuery table '%s:%s.%s' does not exist.", project, dataset, tableName), "Ensure correct table name is provided.").withConfigProperty("table");
            throw collector.getOrThrowException();
        }
        Schema bqSchema = table.getDefinition().getSchema();
        if (bqSchema == null) {
            collector.addFailure(String.format("Cannot read from table '%s:%s.%s' because it has no schema.", project, dataset, table), "Alter the table to have a schema.").withConfigProperty("table");
            throw collector.getOrThrowException();
        }
        return bqSchema;
    }

    @Nullable
    private io.cdap.cdap.api.data.schema.Schema getOutputSchema(FailureCollector collector) {
        io.cdap.cdap.api.data.schema.Schema outputSchema = this.config.getSchema(collector);
        outputSchema = outputSchema == null ? this.getSchema(collector) : outputSchema;
        this.validatePartitionProperties(collector);
        this.validateConfiguredSchema(outputSchema, collector);
        return outputSchema;
    }

    private void validatePartitionProperties(FailureCollector collector) {
        TimePartitioning timePartitioning;
        String tableName;
        String dataset;
        String project = this.config.getDatasetProject();
        Table sourceTable = BigQueryUtil.getBigQueryTable(project, dataset = this.config.getDataset(), tableName = this.config.getTable(), this.config.getServiceAccount(), this.config.isServiceAccountFilePath(), collector);
        if (sourceTable == null) {
            return;
        }
        if (sourceTable.getDefinition() instanceof StandardTableDefinition && (timePartitioning = ((StandardTableDefinition)sourceTable.getDefinition()).getTimePartitioning()) == null) {
            return;
        }
        String partitionFromDate = this.config.getPartitionFrom();
        String partitionToDate = this.config.getPartitionTo();
        if (partitionFromDate == null && partitionToDate == null) {
            return;
        }
        LocalDate fromDate = null;
        if (partitionFromDate != null) {
            try {
                fromDate = LocalDate.parse(partitionFromDate);
            }
            catch (DateTimeException ex) {
                collector.addFailure("Invalid partition from date format.", "Ensure partition from date is of format 'yyyy-MM-dd'.").withConfigProperty("partitionFrom");
            }
        }
        LocalDate toDate = null;
        if (partitionToDate != null) {
            try {
                toDate = LocalDate.parse(partitionToDate);
            }
            catch (DateTimeException ex) {
                collector.addFailure("Invalid partition to date format.", "Ensure partition to date is of format 'yyyy-MM-dd'.").withConfigProperty("partitionTo");
            }
        }
        if (fromDate != null && toDate != null && fromDate.isAfter(toDate) && !fromDate.isEqual(toDate)) {
            collector.addFailure("'Partition From Date' must be before or equal 'Partition To Date'.", null).withConfigProperty("partitionFrom").withConfigProperty("partitionTo");
        }
    }

    private void setInputFormat(BatchSourceContext context, io.cdap.cdap.api.data.schema.Schema configuredSchema) {
        context.setInput(Input.of((String)this.config.getReferenceName(), (InputFormatProvider)new BigQueryInputFormatProvider(this.configuration)));
        ImmutableMap.Builder arguments = new ImmutableMap.Builder();
        if (configuredSchema == null) {
            LOG.debug("BigQuery SQL Engine Input was not initialized. Schema was empty.");
            return;
        }
        List fieldNames = configuredSchema.getFields().stream().map(f -> f.getName()).collect(Collectors.toList());
        arguments.put((Object)"config", (Object)GSON.toJson((Object)this.config)).put((Object)"schema", (Object)GSON.toJson((Object)configuredSchema)).put((Object)"fields", (Object)GSON.toJson(fieldNames));
        SQLEngineInput sqlEngineInput = new SQLEngineInput(this.config.referenceName, context.getStageName(), BigQuerySQLEngine.class.getName(), (Map)arguments.build());
        context.setInput((Input)sqlEngineInput);
    }

    private void emitLineage(BatchSourceContext context, io.cdap.cdap.api.data.schema.Schema schema, TableDefinition.Type sourceTableType, String table, Asset asset) {
        LineageRecorder lineageRecorder = new LineageRecorder((BatchContext)context, asset);
        lineageRecorder.createExternalDataset(schema);
        String type = "table";
        if (TableDefinition.Type.VIEW == sourceTableType) {
            type = "view";
        } else if (TableDefinition.Type.MATERIALIZED_VIEW == sourceTableType) {
            type = "materialized view";
        }
        if (schema.getFields() != null) {
            lineageRecorder.recordRead("Read", String.format("Read from BigQuery %s '%s'.", type, table), schema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toList()));
        }
    }
}

