/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.source;

import com.google.auth.Credentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.Storage;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.gcp.bigquery.common.BigQueryBaseConfig;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class BigQuerySourceConfig
extends BigQueryBaseConfig {
    private static final String VALID_DATE_FORMAT = "yyyy-MM-dd";
    private static final String SCHEME = "gs://";
    private static final String WHERE = "WHERE";
    public static final Set<Schema.Type> SUPPORTED_TYPES = ImmutableSet.of((Object)Schema.Type.LONG, (Object)Schema.Type.STRING, (Object)Schema.Type.DOUBLE, (Object)Schema.Type.BOOLEAN, (Object)Schema.Type.BYTES, (Object)Schema.Type.ARRAY, (Object[])new Schema.Type[]{Schema.Type.RECORD});
    public static final String NAME_TABLE = "table";
    public static final String NAME_SCHEMA = "schema";
    public static final String NAME_PARTITION_FROM = "partitionFrom";
    public static final String NAME_PARTITION_TO = "partitionTo";
    public static final String NAME_FILTER = "filter";
    public static final String NAME_ENABLE_QUERYING_VIEWS = "enableQueryingViews";
    public static final String NAME_VIEW_MATERIALIZATION_PROJECT = "viewMaterializationProject";
    public static final String NAME_VIEW_MATERIALIZATION_DATASET = "viewMaterializationDataset";
    @Name(value="referenceName")
    @Nullable
    @Description(value="This will be used to uniquely identify this source for lineage, annotating metadata, etc.")
    public String referenceName;
    @Name(value="table")
    @Macro
    @Description(value="The table to read from. A table contains individual records organized in rows. Each record is composed of columns (also called fields). Every table is defined by a schema that describes the column names, data types, and other information.")
    private String table;
    @Name(value="schema")
    @Macro
    @Nullable
    @Description(value="The schema of the table to read.")
    private String schema;
    @Name(value="partitionFrom")
    @Macro
    @Nullable
    @Description(value="It's inclusive partition start date. It should be a String with format \"yyyy-MM-dd\". This value is ignored if the table does not support partitioning.")
    private String partitionFrom;
    @Name(value="partitionTo")
    @Macro
    @Nullable
    @Description(value="It's inclusive partition end date. It should be a String with format \"yyyy-MM-dd\". This value is ignored if the table does not support partitioning.")
    private String partitionTo;
    @Name(value="filter")
    @Macro
    @Nullable
    @Description(value="The WHERE clause filters out rows by evaluating each row against boolean expression, and discards all rows that do not return TRUE (that is, rows that return FALSE or NULL).")
    private String filter;
    @Name(value="enableQueryingViews")
    @Macro
    @Nullable
    @Description(value="Whether to allow querying views. Since BigQuery views are not materialized by default, querying them may have a performance overhead.")
    private String enableQueryingViews;
    @Name(value="viewMaterializationProject")
    @Macro
    @Nullable
    @Description(value="The project name where the temporary table should be created. Defaults to the same project in which the table is located.")
    private String viewMaterializationProject;
    @Name(value="viewMaterializationDataset")
    @Macro
    @Nullable
    @Description(value="The dataset in the specified project where the temporary table should be created. Defaults to the same dataset in which the table is located.")
    private String viewMaterializationDataset;

    public String getTable() {
        return this.table;
    }

    public String getDatasetProject() {
        if (this.connection == null) {
            return ServiceOptions.getDefaultProjectId();
        }
        return this.connection.getDatasetProject();
    }

    public void validate(FailureCollector collector) {
        this.validate(collector, Collections.emptyMap());
    }

    public void validate(FailureCollector collector, Map<String, String> arguments) {
        if (!Strings.isNullOrEmpty((String)this.referenceName)) {
            IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        }
        ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
        String bucket = this.getBucket();
        if (!this.containsMacro("bucket")) {
            BigQueryUtil.validateBucket(bucket, "bucket", collector);
        }
        if (!this.containsMacro("dataset")) {
            BigQueryUtil.validateDataset(this.dataset, "dataset", collector);
        }
        if (null != this.partitionFrom) {
            this.validatePartitionDate(collector, this.partitionFrom, NAME_PARTITION_FROM);
        }
        if (null != this.partitionTo) {
            this.validatePartitionDate(collector, this.partitionTo, NAME_PARTITION_TO);
        }
        if (!this.containsMacro(NAME_TABLE)) {
            this.validateTable(collector);
        }
        if (!this.containsMacro("cmekKey")) {
            this.validateCmekKey(collector, arguments);
        }
    }

    void validateCmekKey(FailureCollector collector, Map<String, String> arguments) {
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.cmekKey, arguments, collector);
        if (cmekKeyName == null || !this.canConnect() || this.containsMacro("bucket")) {
            return;
        }
        DatasetId datasetId = DatasetId.of((String)this.getDatasetProject(), (String)this.getDataset());
        Credentials credentials = this.connection.getCredentials(collector);
        BigQuery bigQuery = GCPUtils.getBigQuery(this.getProject(), credentials);
        if (bigQuery == null) {
            return;
        }
        Dataset dataset = null;
        try {
            dataset = bigQuery.getDataset(datasetId, new BigQuery.DatasetOption[0]);
        }
        catch (Exception e) {
            return;
        }
        Storage storage = GCPUtils.getStorage(this.getProject(), credentials);
        if (dataset == null || storage == null) {
            return;
        }
        GCSPath gcsPath = Strings.isNullOrEmpty((String)this.bucket) ? null : GCSPath.from(this.bucket);
        CmekUtils.validateCmekKeyAndBucketLocation(storage, gcsPath, cmekKeyName, dataset.getLocation(), collector);
    }

    private void validateTable(FailureCollector collector) {
        TableDefinition.Type definition;
        BigQueryUtil.validateTable(this.table, NAME_TABLE, collector);
        if (this.canConnect() && (definition = this.getSourceTableType()) != null && definition == TableDefinition.Type.VIEW && !this.isEnableQueryingViews()) {
            collector.addFailure(String.format("'%s' is a 'View' :", this.table), "In order to enable query views, please enable 'Enable Querying Views'");
        }
    }

    private void validatePartitionDate(FailureCollector collector, String partitionDate, String fieldName) {
        SimpleDateFormat date = new SimpleDateFormat(VALID_DATE_FORMAT);
        date.setLenient(false);
        try {
            date.parse(partitionDate);
        }
        catch (ParseException e) {
            collector.addFailure(String.format("%s is not in a valid format.", partitionDate), String.format("Enter valid date in format: %s", VALID_DATE_FORMAT)).withConfigProperty(fieldName);
        }
    }

    public TableDefinition.Type getSourceTableType() {
        Table sourceTable = BigQueryUtil.getBigQueryTable(this.getDatasetProject(), this.getDataset(), this.table, this.getServiceAccount(), this.isServiceAccountFilePath());
        return sourceTable != null ? sourceTable.getDefinition().getType() : null;
    }

    @Nullable
    public Schema getSchema(FailureCollector collector) {
        try {
            return Strings.isNullOrEmpty((String)this.schema) ? null : Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(NAME_SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    @Nullable
    public String getPartitionFrom() {
        return Strings.isNullOrEmpty((String)this.partitionFrom) ? null : this.partitionFrom;
    }

    @Nullable
    public String getPartitionTo() {
        return Strings.isNullOrEmpty((String)this.partitionTo) ? null : this.partitionTo;
    }

    @Nullable
    public String getFilter() {
        if (this.filter != null) {
            this.filter = this.filter.trim();
            if (this.filter.isEmpty()) {
                return null;
            }
            if (this.filter.toUpperCase().startsWith(WHERE)) {
                this.filter = this.filter.substring(WHERE.length());
            }
        }
        return this.filter;
    }

    public boolean isEnableQueryingViews() {
        return "true".equalsIgnoreCase(this.enableQueryingViews);
    }

    @Nullable
    public String getViewMaterializationProject() {
        if (Strings.isNullOrEmpty((String)this.viewMaterializationProject)) {
            return this.getDatasetProject();
        }
        return this.viewMaterializationProject;
    }

    @Nullable
    public String getViewMaterializationDataset() {
        if (Strings.isNullOrEmpty((String)this.viewMaterializationDataset)) {
            return this.getDataset();
        }
        return this.viewMaterializationDataset;
    }

    public String getReferenceName() {
        return Strings.isNullOrEmpty((String)this.referenceName) ? ReferenceNames.normalizeFqn((String)BigQueryUtil.getFQN(this.getDatasetProject(), this.dataset, this.table)) : this.referenceName;
    }

    public boolean canConnect() {
        return !this.containsMacro(NAME_SCHEMA) && !this.containsMacro("dataset") && !this.containsMacro(NAME_TABLE) && this.connection != null && this.connection.canConnect();
    }

    private BigQuerySourceConfig(@Nullable BigQueryConnectorConfig connection, @Nullable String dataset, @Nullable String cmekKey, @Nullable String bucket, @Nullable String table) {
        super(connection, dataset, cmekKey, bucket);
        this.table = table;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BigQueryConnectorConfig connection;
        private String dataset;
        private String cmekKey;
        private String bucket;
        private String table;

        public Builder setConnection(@Nullable BigQueryConnectorConfig connection) {
            this.connection = connection;
            return this;
        }

        public Builder setDataset(@Nullable String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTable(@Nullable String table) {
            this.table = table;
            return this;
        }

        public Builder setCmekKey(@Nullable String cmekKey) {
            this.cmekKey = cmekKey;
            return this;
        }

        public Builder setBucket(@Nullable String bucket) {
            this.bucket = bucket;
            return this;
        }

        public BigQuerySourceConfig build() {
            return new BigQuerySourceConfig(this.connection, this.dataset, this.cmekKey, this.bucket, this.table);
        }
    }
}

