/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.source;

import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.bigquery.source.BigQuerySourceConfig;
import io.cdap.plugin.gcp.bigquery.source.PartitionedBigQueryInputFormat;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQuerySourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySourceUtils.class);
    public static final String GCS_BUCKET_FORMAT = "gs://%s";
    public static final String GS_PATH_FORMAT = "gs://%s/%s";
    private static final String TEMPORARY_BUCKET_FORMAT = "gs://%s/%s/hadoop/input/%s";
    private static final String BQ_TEMP_BUCKET_NAME_PREFIX = "bq-source-bucket-";
    private static final String BQ_TEMP_BUCKET_NAME_TEMPLATE = "bq-source-bucket-%s";
    private static final String BQ_TEMP_BUCKET_PATH_TEMPLATE = "gs://bq-source-bucket-%s";

    @Nullable
    public static Credentials getCredentials(BigQueryConnectorConfig config) throws IOException {
        return config.getServiceAccount() == null ? null : GCPUtils.loadServiceAccountCredentials(config.getServiceAccount(), config.isServiceAccountFilePath());
    }

    public static String getOrCreateBucket(Configuration configuration, Storage storage, @Nullable String bucket, Dataset dataset, String bucketPath, @Nullable CryptoKeyName cmekKeyName) throws IOException {
        if (bucket == null) {
            bucket = String.format(BQ_TEMP_BUCKET_NAME_TEMPLATE, bucketPath);
            configuration.setBoolean("fs.gs.bucket.delete.enable", true);
            GCPUtils.createBucket(storage, bucket, dataset.getLocation(), cmekKeyName);
        } else if (storage != null && storage.get(bucket, new Storage.BucketGetOption[0]) == null) {
            try {
                GCPUtils.createBucket(storage, bucket, dataset.getLocation(), cmekKeyName);
            }
            catch (StorageException e) {
                if (e.getCode() == 409) {
                    return bucket;
                }
                throw new IOException(String.format("Unable to create Cloud Storage bucket '%s' in the same location ('%s') as BigQuery dataset '%s'. Please use a bucket that is in the same location as the dataset.", bucket, dataset.getLocation(), dataset.getDatasetId().getDataset()), e);
            }
        }
        return bucket;
    }

    public static void configureServiceAccount(Configuration configuration, BigQueryConnectorConfig config) {
        if (config.getServiceAccount() != null) {
            configuration.set("cdap.bq.service.account", config.getServiceAccount());
            configuration.setBoolean("cdap.bq.service.account.isfile", config.isServiceAccountFilePath().booleanValue());
        }
    }

    public static void configureBigQueryInput(Configuration configuration, DatasetId dataset, String table, String gcsPath) throws IOException {
        LOG.debug("Using GCS path {} as temp storage for table {}.", (Object)gcsPath, (Object)table);
        configuration.set("fs.default.name", gcsPath);
        configuration.setBoolean("fs.gs.impl.disable.cache", true);
        configuration.setBoolean("fs.gs.metadata.cache.enable", false);
        String temporaryTableName = String.format("_%s_%s", table, UUID.randomUUID().toString().replaceAll("-", "_"));
        configuration.set("cdap.bq.source.temporary.table.name", temporaryTableName);
        PartitionedBigQueryInputFormat.setTemporaryCloudStorageDirectory((Configuration)configuration, (String)gcsPath);
        BigQueryConfiguration.configureBigQueryInput((Configuration)configuration, (String)dataset.getProject(), (String)dataset.getDataset(), (String)table);
    }

    public static String getTemporaryGcsPath(String bucket, String pathPrefix, String tableName) {
        return String.format(TEMPORARY_BUCKET_FORMAT, bucket, pathPrefix, tableName);
    }

    public static void deleteBigQueryTemporaryTable(Configuration configuration, BigQuerySourceConfig config) {
        String temporaryTable = configuration.get("cdap.bq.source.temporary.table.name");
        try {
            Credentials credentials = BigQuerySourceUtils.getCredentials(config.getConnection());
            BigQuery bigQuery = GCPUtils.getBigQuery(config.getProject(), credentials);
            bigQuery.delete(TableId.of((String)config.getDatasetProject(), (String)config.getDataset(), (String)temporaryTable));
            LOG.debug("Deleted temporary table '{}'", (Object)temporaryTable);
        }
        catch (IOException e) {
            LOG.error("Failed to load service account credentials: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void deleteGcsTemporaryDirectory(Configuration configuration, String bucket, String runId) {
        String gcsPath = bucket == null ? String.format(BQ_TEMP_BUCKET_PATH_TEMPLATE, runId) : String.format(GS_PATH_FORMAT, bucket, runId);
        try {
            BigQueryUtil.deleteTemporaryDirectory(configuration, gcsPath);
        }
        catch (IOException e) {
            LOG.error("Failed to delete temporary directory '{}': {}", (Object)gcsPath, (Object)e.getMessage());
        }
    }
}

