/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.source;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.hadoop.io.bigquery.AbstractBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.AvroBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.AvroRecordReader;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.cdap.plugin.gcp.bigquery.source.BigQueryFactoryWithScopes;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.Progressable;

public class PartitionedBigQueryInputFormat
extends AbstractBigQueryInputFormat<LongWritable, GenericData.Record> {
    private InputFormat<LongWritable, GenericData.Record> delegateInputFormat = new AvroBigQueryInputFormat();

    public ExportFileFormat getExportFileFormat() {
        return ExportFileFormat.AVRO;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        this.processQuery(context);
        return this.delegateInputFormat.getSplits(context);
    }

    public RecordReader<LongWritable, GenericData.Record> createDelegateRecordReader(InputSplit split, Configuration configuration) throws IOException, InterruptedException {
        Preconditions.checkState((boolean)(split instanceof FileSplit), (Object)"AvroBigQueryInputFormat requires FileSplit input splits");
        return new AvroRecordReader();
    }

    protected BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
        BigQueryFactoryWithScopes factory = new BigQueryFactoryWithScopes(GCPUtils.BIGQUERY_SCOPES);
        return factory.getBigQueryHelper(config);
    }

    private void processQuery(JobContext context) throws IOException, InterruptedException {
        BigQueryHelper bigQueryHelper;
        Configuration configuration = context.getConfiguration();
        try {
            bigQueryHelper = this.getBigQueryHelper(configuration);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create BigQuery client", gse);
        }
        Map mandatoryConfig = ConfigurationUtil.getMandatoryConfig((Configuration)configuration, (List)BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_INPUT);
        String projectId = (String)mandatoryConfig.get("mapred.bq.project.id");
        String datasetProjectId = (String)mandatoryConfig.get("mapred.bq.input.project.id");
        String datasetId = (String)mandatoryConfig.get("mapred.bq.input.dataset.id");
        String tableName = (String)mandatoryConfig.get("mapred.bq.input.table.id");
        String serviceAccount = configuration.get("cdap.bq.service.account", null);
        Boolean isServiceAccountFilePath = configuration.getBoolean("cdap.bq.service.account.isfile", true);
        String partitionFromDate = configuration.get("cdap.bq.source.partition.from.date", null);
        String partitionToDate = configuration.get("cdap.bq.source.partition.to.date", null);
        String filter = configuration.get("cdap.bq.source.filter", null);
        com.google.cloud.bigquery.Table bigQueryTable = BigQueryUtil.getBigQueryTable(datasetProjectId, datasetId, tableName, serviceAccount, isServiceAccountFilePath);
        TableDefinition.Type type = Objects.requireNonNull(bigQueryTable).getDefinition().getType();
        String query = type == TableDefinition.Type.VIEW || type == TableDefinition.Type.MATERIALIZED_VIEW || type == TableDefinition.Type.EXTERNAL ? this.generateQueryForMaterializingView(datasetProjectId, datasetId, tableName, filter) : this.generateQuery(partitionFromDate, partitionToDate, filter, projectId, datasetProjectId, datasetId, tableName, serviceAccount, isServiceAccountFilePath);
        if (query != null) {
            TableReference sourceTable = new TableReference().setDatasetId(datasetId).setProjectId(datasetProjectId).setTableId(tableName);
            String location = bigQueryHelper.getTable(sourceTable).getLocation();
            String temporaryTableName = configuration.get("cdap.bq.source.temporary.table.name");
            TableReference exportTableReference = this.createExportTableReference(type, datasetProjectId, datasetId, temporaryTableName, configuration);
            PartitionedBigQueryInputFormat.runQuery(configuration, bigQueryHelper, projectId, exportTableReference, query, location);
            configuration.set("mapred.bq.input.project.id", configuration.get("cdap.bq.source.view.materialization.project"));
            configuration.set("mapred.bq.input.dataset.id", configuration.get("cdap.bq.source.view.materialization.dataset"));
            configuration.set("mapred.bq.input.table.id", temporaryTableName);
        }
    }

    @VisibleForTesting
    String generateQuery(String partitionFromDate, String partitionToDate, String filter, String project, String datasetProject, String dataset, String table, @Nullable String serviceAccount, @Nullable Boolean isServiceAccountFilePath) {
        if (partitionFromDate == null && partitionToDate == null && filter == null) {
            return null;
        }
        String queryTemplate = "select * from `%s` where %s";
        com.google.cloud.bigquery.Table sourceTable = BigQueryUtil.getBigQueryTable(datasetProject, dataset, table, serviceAccount, isServiceAccountFilePath);
        StandardTableDefinition tableDefinition = (StandardTableDefinition)Objects.requireNonNull(sourceTable).getDefinition();
        TimePartitioning timePartitioning = tableDefinition.getTimePartitioning();
        if (timePartitioning == null && filter == null) {
            return null;
        }
        StringBuilder condition = new StringBuilder();
        if (timePartitioning != null) {
            String timePartitionCondition = BigQueryUtil.generateTimePartitionCondition(tableDefinition, partitionFromDate, partitionToDate);
            condition.append(timePartitionCondition);
        }
        if (filter != null) {
            if (condition.length() == 0) {
                condition.append(filter);
            } else {
                condition.append(" and (").append(filter).append(")");
            }
        }
        String tableName = datasetProject + "." + dataset + "." + table;
        return String.format(queryTemplate, tableName, condition.toString());
    }

    @VisibleForTesting
    String generateQueryForMaterializingView(String datasetProject, String dataset, String table, String filter) {
        String queryTemplate = "select * from `%s`%s";
        StringBuilder condition = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)filter)) {
            condition.append(String.format(" where %s", filter));
        }
        String tableName = datasetProject + "." + dataset + "." + table;
        return String.format(queryTemplate, tableName, condition.toString());
    }

    private TableReference createExportTableReference(TableDefinition.Type type, String datasetProjectId, String datasetId, String tableId, Configuration configuration) {
        TableReference tableReference = new TableReference().setTableId(tableId);
        tableReference.setProjectId(configuration.get("cdap.bq.source.view.materialization.project"));
        tableReference.setDatasetId(configuration.get("cdap.bq.source.view.materialization.dataset"));
        return tableReference;
    }

    private static void runQuery(Configuration configuration, BigQueryHelper bigQueryHelper, String projectId, TableReference tableRef, String query, String location) throws IOException, InterruptedException {
        JobConfigurationQuery queryConfig = new JobConfigurationQuery();
        queryConfig.setAllowLargeResults(Boolean.valueOf(true));
        queryConfig.setQuery(query);
        queryConfig.setUseLegacySql(Boolean.valueOf(false));
        queryConfig.setDestinationTable(tableRef);
        queryConfig.setCreateDisposition("CREATE_IF_NEEDED");
        queryConfig.setWriteDisposition("WRITE_EMPTY");
        JobConfiguration config = new JobConfiguration();
        config.setQuery(queryConfig);
        config.setLabels(BigQueryUtil.getJobTags("bq_source_plugin"));
        JobReference jobReference = PartitionedBigQueryInputFormat.getJobReference(configuration, bigQueryHelper, projectId, location);
        Job job = new Job();
        job.setConfiguration(config);
        job.setJobReference(jobReference);
        Job response = bigQueryHelper.insertJobOrFetchDuplicate(projectId, job);
        Progressable progressable = new Progressable(){

            public void progress() {
            }
        };
        BigQueryUtils.waitForJobCompletion((Bigquery)bigQueryHelper.getRawBigquery(), (String)projectId, (JobReference)jobReference, (Progressable)progressable);
        if (bigQueryHelper.tableExists(tableRef)) {
            long expirationMillis = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
            Table table = bigQueryHelper.getTable(tableRef).setExpirationTime(Long.valueOf(expirationMillis));
            bigQueryHelper.getRawBigquery().tables().update(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId(), table).execute();
        }
    }

    private static JobReference getJobReference(Configuration conf, BigQueryHelper bigQueryHelper, String projectId, @Nullable String location) {
        String savedJobId = conf.get("cdap.bq.sink.job.id");
        if (savedJobId == null || savedJobId.isEmpty()) {
            return bigQueryHelper.createJobReference(projectId, "querybasedexport", location);
        }
        return new JobReference().setProjectId(projectId).setJobId(savedJobId).setLocation(location);
    }
}

