/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetId;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Transform;
import io.cdap.cdap.etl.api.engine.sql.dataset.SQLPullDataset;
import io.cdap.cdap.etl.api.engine.sql.request.SQLPullRequest;
import io.cdap.plugin.gcp.bigquery.source.BigQueryInputFormatProvider;
import io.cdap.plugin.gcp.bigquery.source.BigQuerySourceUtils;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLDataset;
import io.cdap.plugin.gcp.bigquery.sqlengine.transform.PullTransform;
import io.cdap.plugin.gcp.bigquery.sqlengine.util.BigQuerySQLEngineUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;

public class BigQueryPullDataset
extends BigQueryInputFormatProvider
implements SQLPullDataset<StructuredRecord, LongWritable, GenericData.Record>,
BigQuerySQLDataset {
    private final BigQuery bigQuery;
    private final String datasetName;
    private final Schema schema;
    private final DatasetId bqDataset;
    private final String bqTable;
    private final String gcsPath;
    private Long numRows;

    private BigQueryPullDataset(Configuration configuration, String datasetName, Schema schema, BigQuery bigQuery, DatasetId bqDataset, String bqTable, String gcsPath) {
        super(configuration);
        this.datasetName = datasetName;
        this.schema = schema;
        this.bigQuery = bigQuery;
        this.bqDataset = bqDataset;
        this.bqTable = bqTable;
        this.gcsPath = gcsPath;
    }

    public static BigQueryPullDataset getInstance(SQLPullRequest pullRequest, Configuration baseConfiguration, BigQuery bigQuery, DatasetId bqDataset, String bqTable, String bucket, String runId) throws IOException {
        Configuration configuration = new Configuration(baseConfiguration);
        String gcsPath = BigQuerySQLEngineUtils.getGCSPath(bucket, runId, bqTable);
        BigQuerySourceUtils.configureBigQueryInput(configuration, bqDataset, bqTable, gcsPath);
        return new BigQueryPullDataset(configuration, pullRequest.getDatasetName(), pullRequest.getDatasetSchema(), bigQuery, bqDataset, bqTable, gcsPath);
    }

    public Transform<KeyValue<LongWritable, GenericData.Record>, StructuredRecord> fromKeyValue() {
        return new PullTransform(this.schema);
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getNumRows() {
        if (this.numRows == null) {
            this.numRows = BigQuerySQLEngineUtils.getNumRows(this.bigQuery, this.bqDataset, this.bqTable);
        }
        return this.numRows;
    }

    @Override
    public String getBigQueryProject() {
        return this.bqDataset.getProject();
    }

    @Override
    public String getBigQueryDataset() {
        return this.bqDataset.getDataset();
    }

    @Override
    public String getBigQueryTable() {
        return this.bqTable;
    }

    @Override
    @Nullable
    public String getJobId() {
        return null;
    }

    @Override
    public String getGCSPath() {
        return this.gcsPath;
    }
}

