/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Transform;
import io.cdap.cdap.etl.api.engine.sql.dataset.SQLPushDataset;
import io.cdap.cdap.etl.api.engine.sql.request.SQLPushRequest;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryOutputFormatProvider;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sink.Operation;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLDataset;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLEngineConfig;
import io.cdap.plugin.gcp.bigquery.sqlengine.transform.PushTransform;
import io.cdap.plugin.gcp.bigquery.sqlengine.util.BigQuerySQLEngineUtils;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;

public class BigQueryPushDataset
extends BigQueryOutputFormatProvider
implements SQLPushDataset<StructuredRecord, StructuredRecord, NullWritable>,
BigQuerySQLDataset {
    private final String datasetName;
    private final BigQuery bigQuery;
    private final DatasetId bqDataset;
    private final String bqTable;
    private final String gcsPath;
    private final String jobId;
    private Long numRows;

    private BigQueryPushDataset(String datasetName, Schema tableSchema, Configuration configuration, BigQuery bigQuery, DatasetId bqDataset, String bqTable, String jobId, String gcsPath) {
        super(configuration, tableSchema);
        this.datasetName = datasetName;
        this.bigQuery = bigQuery;
        this.bqDataset = bqDataset;
        this.bqTable = bqTable;
        this.jobId = jobId;
        this.gcsPath = gcsPath;
    }

    protected static BigQueryPushDataset getInstance(SQLPushRequest pushRequest, BigQuerySQLEngineConfig sqlEngineConfig, Configuration baseConfiguration, BigQuery bigQuery, DatasetId dataset, String bucket, String runId) throws IOException {
        String jobId = BigQuerySQLEngineUtils.newIdentifier();
        String table = BigQuerySQLEngineUtils.getNewTableName(runId);
        Configuration configuration = new Configuration(baseConfiguration);
        configuration.set("cdap.bq.sink.job.id", jobId);
        configuration.set("cdap.bq.sink.operation", Operation.INSERT.name());
        configuration.setBoolean("cdap.bq.sink.destination.table.exists", true);
        configuration.setBoolean("cdap.bq.sink.allow.schema.relaxation", true);
        configuration.setBoolean("cdap.bq.sink.allow.schema.relaxationoemptyoutput", true);
        String gcsPath = BigQuerySQLEngineUtils.getGCSPath(bucket, runId, table);
        List<BigQueryTableFieldSchema> fields = BigQuerySinkUtils.getBigQueryTableFieldsFromSchema(pushRequest.getDatasetSchema());
        BigQuerySinkUtils.configureOutput(configuration, dataset, table, gcsPath, fields);
        BigQuerySQLEngineUtils.createEmptyTable(sqlEngineConfig, bigQuery, dataset.getProject(), dataset.getDataset(), table);
        return new BigQueryPushDataset(pushRequest.getDatasetName(), pushRequest.getDatasetSchema(), configuration, bigQuery, dataset, table, jobId, gcsPath);
    }

    public Transform<StructuredRecord, KeyValue<StructuredRecord, NullWritable>> toKeyValue() {
        return new PushTransform();
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public Schema getSchema() {
        return this.tableSchema;
    }

    public long getNumRows() {
        if (this.numRows == null) {
            this.numRows = BigQuerySQLEngineUtils.getNumRows(this.bigQuery, this.bqDataset, this.bqTable);
        }
        return this.numRows;
    }

    @Override
    public String getBigQueryProject() {
        return this.bqDataset.getProject();
    }

    @Override
    public String getBigQueryDataset() {
        return this.bqDataset.getDataset();
    }

    @Override
    public String getBigQueryTable() {
        return this.bqTable;
    }

    @Override
    public String getGCSPath() {
        return this.gcsPath;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }
}

