/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine;

import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.engine.sql.SQLEngineException;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.gcp.bigquery.common.BigQueryBaseConfig;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.CmekUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class BigQuerySQLEngineConfig
extends BigQueryBaseConfig {
    public static final String NAME_LOCATION = "location";
    public static final String NAME_RETAIN_TABLES = "retainTables";
    public static final String NAME_TEMP_TABLE_TTL_HOURS = "tempTableTTLHours";
    public static final String NAME_JOB_PRIORITY = "jobPriority";
    public static final String NAME_INCLUDED_STAGES = "includedStages";
    public static final String NAME_EXCLUDED_STAGES = "excludedStages";
    public static final String NAME_USE_STORAGE_READ_API = "useStorageReadAPI";
    public static final String PRIORITY_BATCH = "batch";
    public static final String PRIORITY_INTERACTIVE = "interactive";
    private static final String SCHEME = "gs://";
    private static final String STAGE_SPLIT = "\u0001";
    @Name(value="location")
    @Macro
    @Nullable
    @Description(value="The location where the BigQuery dataset will get created. This value is ignored if the dataset or temporary bucket already exists.")
    protected String location;
    @Name(value="retainTables")
    @Macro
    @Nullable
    @Description(value="Select this option to retain all BigQuery temporary tables created during the pipeline run.")
    protected Boolean retainTables;
    @Name(value="tempTableTTLHours")
    @Macro
    @Nullable
    @Description(value="Set table TTL for temporary BigQuery tables, in number of hours. Tables will be deleted automatically on pipeline completion.")
    protected Integer tempTableTTLHours;
    @Name(value="jobPriority")
    @Macro
    @Nullable
    @Description(value="Priority used to execute BigQuery Jobs. The value must be 'batch' or 'interactive'. An interactive job is executed as soon as possible and counts towards the concurrent rate limit and the daily rate limit. A batch job is queued and started as soon as idle resources are available, usually within a few minutes. If the job hasn't started within 3 hours, its priority is changed to 'interactive'")
    private String jobPriority;
    @Name(value="useStorageReadAPI")
    @Macro
    @Nullable
    @Description(value="Select this option to use the BigQuery Storage Read API when extracting records from BigQuery during pipeline execution. This option can increase the performance of the BigQuery ELT Transformation Pushdown execution. The usage of this API incurrs additional costs. This requires Scala version 2.12 to be installed in the execution environment.")
    private Boolean useStorageReadAPI;
    @Name(value="includedStages")
    @Macro
    @Nullable
    @Description(value="Stages that should always be pushed down to the BigQuery ELT Transformation Pushdown engine, if supported by the engine. Each stage name should be in a separate line.")
    protected String includedStages;
    @Name(value="excludedStages")
    @Macro
    @Nullable
    @Description(value="Stages that should never be pushed down to the BigQuery ELT Transformation Pushdown engine, even when supported. Each stage name should be in a separate line.")
    protected String excludedStages;

    private BigQuerySQLEngineConfig(@Nullable BigQueryConnectorConfig connection, @Nullable String dataset, @Nullable String location, @Nullable String cmekKey, @Nullable String bucket) {
        super(connection, dataset, cmekKey, bucket);
        this.location = location;
    }

    private BigQuerySQLEngineConfig(@Nullable BigQueryConnectorConfig connection, @Nullable String datasetProject, @Nullable String dataset, @Nullable String location, @Nullable String cmekKey, @Nullable String bucket) {
        super(connection, dataset, cmekKey, bucket);
        this.location = location;
    }

    public Boolean shouldRetainTables() {
        return this.retainTables != null ? this.retainTables : false;
    }

    public Integer getTempTableTTLHours() {
        return this.tempTableTTLHours != null && this.tempTableTTLHours > 0 ? this.tempTableTTLHours : 72;
    }

    public Set<String> getIncludedStages() {
        return BigQuerySQLEngineConfig.splitStages(this.includedStages);
    }

    public Set<String> getExcludedStages() {
        return BigQuerySQLEngineConfig.splitStages(this.excludedStages);
    }

    @VisibleForTesting
    protected static Set<String> splitStages(String stages) {
        if (Strings.isNullOrEmpty((String)stages)) {
            return Collections.emptySet();
        }
        return Stream.of(stages.split(STAGE_SPLIT)).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toSet());
    }

    public Boolean shouldUseStorageReadAPI() {
        return this.useStorageReadAPI != null ? this.useStorageReadAPI : false;
    }

    public QueryJobConfiguration.Priority getJobPriority() {
        String priority = this.jobPriority != null ? this.jobPriority : PRIORITY_BATCH;
        return QueryJobConfiguration.Priority.valueOf((String)priority.toUpperCase());
    }

    public void validate() {
        if (!(this.jobPriority == null || this.containsMacro(NAME_JOB_PRIORITY) || PRIORITY_BATCH.equalsIgnoreCase(this.jobPriority) || PRIORITY_INTERACTIVE.equalsIgnoreCase(this.jobPriority))) {
            throw new SQLEngineException("Property 'jobPriority' must be 'batch' or 'interactive'");
        }
    }

    public void validate(FailureCollector failureCollector) {
        this.validate(failureCollector, Collections.emptyMap());
    }

    public void validate(FailureCollector failureCollector, Map<String, String> arguments) {
        this.validate();
        ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)failureCollector);
        String bucket = this.getBucket();
        if (!this.containsMacro("bucket")) {
            BigQueryUtil.validateBucket(bucket, "bucket", failureCollector);
        }
        if (!this.containsMacro("dataset")) {
            BigQueryUtil.validateDataset(this.dataset, "dataset", failureCollector);
        }
        if (!this.containsMacro("cmekKey")) {
            this.validateCmekKey(failureCollector, arguments);
        }
    }

    void validateCmekKey(FailureCollector failureCollector, Map<String, String> arguments) {
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.cmekKey, arguments, failureCollector);
        if (this.containsMacro(NAME_LOCATION)) {
            return;
        }
        this.validateCmekKeyLocation(cmekKeyName, null, this.location, failureCollector);
    }

    @Nullable
    public String getLocation() {
        return this.location;
    }

    public String getDatasetProject() {
        return this.connection == null ? null : this.connection.getDatasetProject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String cmekKey;
        private String location;
        private String bucket;
        private BigQueryConnectorConfig connection;

        public Builder setConnection(@Nullable BigQueryConnectorConfig connection) {
            this.connection = connection;
            return this;
        }

        public Builder setProject(@Nullable String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(@Nullable String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setCmekKey(@Nullable String cmekKey) {
            this.cmekKey = cmekKey;
            return this;
        }

        public Builder setLocation(@Nullable String location) {
            this.location = location;
            return this;
        }

        public Builder setBucket(@Nullable String bucket) {
            this.bucket = bucket;
            return this;
        }

        public BigQuerySQLEngineConfig build() {
            return new BigQuerySQLEngineConfig(this.connection, this.project, this.dataset, this.location, this.cmekKey, this.bucket);
        }
    }
}

