/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.metrics.Metrics;
import io.cdap.cdap.etl.api.engine.sql.SQLEngineException;
import io.cdap.cdap.etl.api.engine.sql.dataset.SQLDataset;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQueryJobType;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLDataset;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLEngineConfig;
import io.cdap.plugin.gcp.bigquery.sqlengine.util.BigQuerySQLEngineUtils;
import java.util.Collections;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQuerySelectDataset
implements SQLDataset,
BigQuerySQLDataset {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySelectDataset.class);
    private final String datasetName;
    private final Schema outputSchema;
    private final BigQuerySQLEngineConfig sqlEngineConfig;
    private final BigQuery bigQuery;
    private final String project;
    private final DatasetId bqDataset;
    private final String bqTable;
    private final String jobId;
    private final BigQueryJobType operation;
    private final String selectQuery;
    private final Metrics metrics;
    private Long numRows;

    public static BigQuerySelectDataset getInstance(String datasetName, Schema outputSchema, BigQuerySQLEngineConfig sqlEngineConfig, BigQuery bigQuery, String project, DatasetId bqDataset, String bqTable, String jobId, BigQueryJobType jobType, String selectQuery, Metrics metrics) {
        return new BigQuerySelectDataset(datasetName, outputSchema, sqlEngineConfig, bigQuery, project, bqDataset, bqTable, jobId, jobType, selectQuery, metrics);
    }

    private BigQuerySelectDataset(String datasetName, Schema outputSchema, BigQuerySQLEngineConfig sqlEngineConfig, BigQuery bigQuery, String project, DatasetId bqDataset, String bqTable, String jobId, BigQueryJobType operation, String selectQuery, Metrics metrics) {
        this.datasetName = datasetName;
        this.outputSchema = outputSchema;
        this.sqlEngineConfig = sqlEngineConfig;
        this.bigQuery = bigQuery;
        this.project = project;
        this.bqDataset = bqDataset;
        this.bqTable = bqTable;
        this.jobId = jobId;
        this.operation = operation;
        this.selectQuery = selectQuery;
        this.metrics = metrics;
    }

    public BigQuerySelectDataset execute() {
        TableId destinationTable = TableId.of((String)this.bqDataset.getProject(), (String)this.bqDataset.getDataset(), (String)this.bqTable);
        Dataset dataset = this.bigQuery.getDataset(this.bqDataset, new BigQuery.DatasetOption[0]);
        String location = dataset.getLocation();
        this.updateTableSchema(destinationTable, this.outputSchema);
        LOG.info("Creating table `{}` using job: {} with SQL statement: {}", new Object[]{this.bqTable, this.jobId, this.selectQuery});
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)this.selectQuery).setDestinationTable(destinationTable).setCreateDisposition(JobInfo.CreateDisposition.CREATE_NEVER).setWriteDisposition(JobInfo.WriteDisposition.WRITE_APPEND).setSchemaUpdateOptions(Collections.singletonList(JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION)).setPriority(this.sqlEngineConfig.getJobPriority()).setLabels(BigQuerySQLEngineUtils.getJobTags(this.operation)).build();
        JobId bqJobId = JobId.newBuilder().setJob(this.jobId).setLocation(location).setProject(this.project).build();
        Job queryJob = this.bigQuery.create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(bqJobId).build(), new BigQuery.JobOption[0]);
        try {
            queryJob = queryJob.waitFor(new RetryOption[0]);
        }
        catch (InterruptedException ie) {
            throw new SQLEngineException("Interrupted exception when executing Join operation", (Throwable)ie);
        }
        if (queryJob == null) {
            throw new SQLEngineException("BigQuery job not found: " + this.jobId);
        }
        if (queryJob.getStatus().getError() != null) {
            BigQuerySQLEngineUtils.logJobMetrics(queryJob, this.metrics);
            throw new SQLEngineException(String.format("Error executing BigQuery Job: '%s' in Project '%s', Dataset '%s', Location'%s' : %s", this.jobId, this.project, this.bqDataset, location, queryJob.getStatus().getError().toString()));
        }
        LOG.info("Created BigQuery table `{}` using Job: {}", (Object)this.bqTable, (Object)this.jobId);
        BigQuerySQLEngineUtils.logJobMetrics(queryJob, this.metrics);
        return this;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public Schema getSchema() {
        return this.outputSchema;
    }

    public long getNumRows() {
        if (this.numRows == null) {
            this.numRows = BigQuerySQLEngineUtils.getNumRows(this.bigQuery, this.bqDataset, this.bqTable);
        }
        return this.numRows;
    }

    @Override
    public String getBigQueryProject() {
        return this.bqDataset.getProject();
    }

    @Override
    public String getBigQueryDataset() {
        return this.bqDataset.getDataset();
    }

    @Override
    public String getBigQueryTable() {
        return this.bqTable;
    }

    @Override
    @Nullable
    public String getGCSPath() {
        return null;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    protected void updateTableSchema(TableId tableId, Schema schema) {
        com.google.cloud.bigquery.Schema bqSchema = BigQuerySinkUtils.convertCdapSchemaToBigQuerySchema(schema);
        Table table = this.bigQuery.getTable(tableId, new BigQuery.TableOption[0]);
        TableDefinition updatedDefinition = table.getDefinition().toBuilder().setSchema(bqSchema).build();
        Table updatedTable = table.toBuilder().setDefinition(updatedDefinition).build();
        this.bigQuery.update((TableInfo)updatedTable, new BigQuery.TableOption[0]);
    }
}

