/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.builder;

import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.plugin.gcp.bigquery.relational.SQLExpression;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public abstract class BigQueryBaseSQLBuilder {
    public static final String SELECT = "SELECT ";
    public static final String FROM = " FROM ";
    public static final String SPACE = " ";
    public static final String JOIN = " JOIN ";
    public static final String AS = " AS ";
    public static final String ON = " ON ";
    public static final String EQ = " = ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String CURRENT_ROW = " CURRENT ROW ";
    public static final String ROWS = "ROWS";
    public static final String RANGE = "RANGE";
    public static final String BETWEEN = " BETWEEN ";
    public static final String EMPTY = "";
    public static final String UNBOUNDED_PRECEDING = "UNBOUNDED PRECEDING";
    public static final String PRECEDING = " PRECEDING ";
    public static final String UNBOUNDED_FOLLOWING = "UNBOUNDED FOLLOWING";
    public static final String FOLLOWING = " FOLLOWING ";
    public static final String DOT = ".";
    public static final String COMMA = " , ";
    public static final String IS_NULL = " IS NULL";
    public static final String OPEN_GROUP = "(";
    public static final String CLOSE_GROUP = ")";
    public static final String WHERE = " WHERE ";
    public static final String GROUP_BY = " GROUP BY ";
    public static final String QUOTE = "`";
    public static final String ORDER_DESC = "DESC";
    public static final String ORDER_ASC = "ASC";
    public static final String SELECT_DEDUPLICATE_STATEMENT = "SELECT * EXCEPT(`%s`) FROM (%s) WHERE `%s` = 1";
    public static final String OVER = "OVER";
    public static final String ROW_NUMBER_PARTITION_COLUMN = "ROW_NUMBER() OVER ( %s ) AS `%s`";
    public static final String PARTITION_BY = "PARTITION BY ";
    public static final String ORDER_BY = "ORDER BY ";
    public static final String NULLS_LAST = "NULLS LAST";
    public static final String IF_FUNCTION = "IF";
    public static final String ZERO = "0";
    public static final String ONE = "1";

    public abstract String getQuery();

    public Stream<String> getSelectColumnsStream(Map<String, Expression> selectFields) {
        return selectFields.entrySet().stream().map(e -> ((SQLExpression)e.getValue()).extract() + AS + (String)e.getKey());
    }

    public Stream<String> getExpressionSQLStream(Collection<Expression> expressions) {
        return expressions.stream().map(e -> ((SQLExpression)e).extract());
    }
}

