/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.builder;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.etl.api.aggregation.DeduplicateAggregationDefinition;
import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.plugin.gcp.bigquery.relational.SQLExpression;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryBaseSQLBuilder;
import io.cdap.plugin.gcp.bigquery.sqlengine.util.BigQuerySQLEngineUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BigQueryDeduplicateSQLBuilder
extends BigQueryBaseSQLBuilder {
    private static final String ROW_NUM_PREFIX = "rn_";
    private final DeduplicateAggregationDefinition deduplicationDefinition;
    private final String source;
    private final String sourceAlias;
    private final String rowNumColumnAlias;

    public BigQueryDeduplicateSQLBuilder(DeduplicateAggregationDefinition deduplicationDefinition, String sourceExpression, String sourceAlias) {
        this(deduplicationDefinition, sourceExpression, sourceAlias, ROW_NUM_PREFIX + BigQuerySQLEngineUtils.newIdentifier());
    }

    @VisibleForTesting
    protected BigQueryDeduplicateSQLBuilder(DeduplicateAggregationDefinition deduplicationDefinition, String source, String sourceAlias, String rowNumColumnAlias) {
        this.deduplicationDefinition = deduplicationDefinition;
        this.source = source;
        this.sourceAlias = sourceAlias;
        this.rowNumColumnAlias = rowNumColumnAlias;
    }

    @Override
    public String getQuery() {
        return String.format("SELECT * EXCEPT(`%s`) FROM (%s) WHERE `%s` = 1", this.rowNumColumnAlias, this.getInnerSelect(), this.rowNumColumnAlias);
    }

    @VisibleForTesting
    protected String getInnerSelect() {
        return "SELECT " + this.getSelectedFields(this.deduplicationDefinition) + " FROM " + "(" + " " + this.source + " " + ")" + " AS " + this.sourceAlias;
    }

    @VisibleForTesting
    protected String getSelectedFields(DeduplicateAggregationDefinition def) {
        Set columns = this.getSelectColumnsStream(def.getSelectExpressions()).collect(Collectors.toCollection(LinkedHashSet::new));
        columns.add(this.getRowNumColumn(def));
        return String.join((CharSequence)" , ", columns);
    }

    @VisibleForTesting
    protected String getRowNumColumn(DeduplicateAggregationDefinition def) {
        StringBuilder window = new StringBuilder();
        window.append("PARTITION BY ").append(this.getPartitionByFields(def.getGroupByExpressions()));
        if (def.getFilterExpressions() != null && def.getFilterExpressions().size() > 0) {
            window.append(" ").append("ORDER BY ").append(this.getOrderByFields(def.getFilterExpressions()));
        }
        return String.format("ROW_NUMBER() OVER ( %s ) AS `%s`", window.toString(), this.rowNumColumnAlias);
    }

    @VisibleForTesting
    protected String getPartitionByFields(List<Expression> partitionByExpressions) {
        return this.getExpressionSQLStream(partitionByExpressions).collect(Collectors.joining(" , "));
    }

    @VisibleForTesting
    protected String getOrderByFields(List<DeduplicateAggregationDefinition.FilterExpression> orderByExpression) {
        return orderByExpression.stream().map(this::getOrderByField).collect(Collectors.joining(" , "));
    }

    protected String getOrderByField(DeduplicateAggregationDefinition.FilterExpression filterExpression) {
        String exp = ((SQLExpression)filterExpression.getExpression()).extract();
        switch (filterExpression.getFilterFunction()) {
            case MIN: {
                return exp + " " + "ASC" + " " + "NULLS LAST";
            }
            case MAX: {
                return exp + " " + "DESC" + " " + "NULLS LAST";
            }
            case ANY_NULLS_FIRST: {
                return "IF(" + exp + " IS NULL" + " , " + "0" + " , " + "1" + ")" + " " + "ASC";
            }
        }
        return "IF(" + exp + " IS NULL" + " , " + "0" + " , " + "1" + ")" + " " + "DESC";
    }
}

