/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.builder;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.etl.api.aggregation.AggregationDefinition;
import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryBaseSQLBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BigQueryGroupBySQLBuilder
extends BigQueryBaseSQLBuilder {
    private final AggregationDefinition aggregationDefinition;
    private final String sourceExpression;
    private final String sourceAlias;
    private final StringBuilder builder;

    public BigQueryGroupBySQLBuilder(AggregationDefinition aggregationDefinition, String sourceExpression, String sourceAlias) {
        this.aggregationDefinition = aggregationDefinition;
        this.sourceExpression = sourceExpression;
        this.sourceAlias = sourceAlias;
        this.builder = new StringBuilder();
    }

    @Override
    public String getQuery() {
        this.builder.append("SELECT ").append(this.getSelectedFields(this.aggregationDefinition.getSelectExpressions()));
        this.builder.append(" FROM ");
        this.builder.append("(").append(" ").append(this.sourceExpression).append(" ").append(")");
        this.builder.append(" AS ").append(this.sourceAlias);
        this.builder.append(" GROUP BY ").append(this.getGroupByFields(this.aggregationDefinition.getGroupByExpressions()));
        return this.builder.toString();
    }

    @VisibleForTesting
    protected String getSelectedFields(Map<String, Expression> selectedFields) {
        return this.getSelectColumnsStream(selectedFields).collect(Collectors.joining(" , "));
    }

    @VisibleForTesting
    protected String getGroupByFields(List<Expression> groupByExpressions) {
        return this.getExpressionSQLStream(groupByExpressions).collect(Collectors.joining(" , "));
    }
}

