/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.builder;

import com.google.cloud.bigquery.DatasetId;
import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.etl.api.engine.sql.SQLEngineException;
import io.cdap.cdap.etl.api.join.JoinCondition;
import io.cdap.cdap.etl.api.join.JoinDefinition;
import io.cdap.cdap.etl.api.join.JoinField;
import io.cdap.cdap.etl.api.join.JoinKey;
import io.cdap.cdap.etl.api.join.JoinStage;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryBaseSQLBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BigQueryJoinSQLBuilder
extends BigQueryBaseSQLBuilder {
    private final JoinDefinition joinDefinition;
    private final StringBuilder builder;
    private final DatasetId dataset;
    private final Map<String, String> stageToBQTableNameMap;
    private final Map<String, String> stageToFullTableNameMap;
    private final Map<String, String> stageToTableAliasMap;

    public BigQueryJoinSQLBuilder(JoinDefinition joinDefinition, DatasetId dataset, Map<String, String> stageToBQTableNameMap) {
        this(joinDefinition, dataset, stageToBQTableNameMap, new HashMap<String, String>(), new HashMap<String, String>(), new StringBuilder());
    }

    @VisibleForTesting
    protected BigQueryJoinSQLBuilder(JoinDefinition joinDefinition, DatasetId dataset, Map<String, String> stageToBQTableNameMap, Map<String, String> stageToFullTableNameMap, Map<String, String> stageToTableAliasMap, StringBuilder builder) {
        this.joinDefinition = joinDefinition;
        this.builder = builder;
        this.dataset = dataset;
        this.stageToBQTableNameMap = stageToBQTableNameMap;
        this.stageToFullTableNameMap = stageToFullTableNameMap;
        this.stageToTableAliasMap = stageToTableAliasMap;
    }

    @Override
    public String getQuery() {
        if (this.joinDefinition.getCondition().getOp() == JoinCondition.Op.KEY_EQUALITY) {
            return this.getFieldEqualityQuery();
        }
        return this.getExpressionQuery();
    }

    private String getFieldEqualityQuery() {
        this.addTableNamesAndAliasesForJoinDefinition();
        this.appendSelectStatement();
        this.appendFieldEqualityClause();
        return this.builder.toString();
    }

    private String getExpressionQuery() {
        JoinCondition.OnExpression onExpression = (JoinCondition.OnExpression)this.joinDefinition.getCondition();
        this.addTableNamesAndAliasesForJoinDefinition(onExpression.getDatasetAliases());
        this.appendSelectStatement();
        this.appendOnExpressionClause();
        return this.builder.toString();
    }

    private void appendSelectStatement() {
        this.builder.append("SELECT ").append(this.getSelectedFields()).append(" FROM ");
    }

    @VisibleForTesting
    protected String getSelectedFields() {
        return this.joinDefinition.getSelectedFields().stream().map(this::buildSelectedField).collect(Collectors.joining(" , "));
    }

    @VisibleForTesting
    protected String buildSelectedField(JoinField joinField) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTableAlias(joinField.getStageName()));
        builder.append(".");
        builder.append(joinField.getFieldName());
        if (joinField.getAlias() != null) {
            builder.append(" AS ");
            builder.append(BigQueryJoinSQLBuilder.quoteAlias(joinField.getAlias()));
        }
        return builder.toString();
    }

    private void appendFieldEqualityClause() {
        List stages = this.joinDefinition.getStages();
        HashMap<String, JoinKey> stageNameToJoinKeyMap = new HashMap<String, JoinKey>();
        for (JoinKey joinKey : ((JoinCondition.OnKeys)this.joinDefinition.getCondition()).getKeys()) {
            stageNameToJoinKeyMap.put(joinKey.getStageName(), joinKey);
        }
        boolean joinOnNullKeys = ((JoinCondition.OnKeys)this.joinDefinition.getCondition()).isNullSafe();
        this.appendFieldEqualityClause(stages, stageNameToJoinKeyMap, joinOnNullKeys);
    }

    @VisibleForTesting
    protected void appendFieldEqualityClause(List<JoinStage> stages, Map<String, JoinKey> stageNameToJoinKeyMap, boolean joinOnNullKeys) {
        JoinStage prev = null;
        for (JoinStage curr : stages) {
            if (prev == null) {
                this.appendFullTableNameAndAlias(curr.getStageName());
            } else {
                this.builder.append(" ");
                this.appendJoinOnKeyOperation(prev, curr, stageNameToJoinKeyMap, joinOnNullKeys);
            }
            prev = curr;
        }
    }

    private void appendOnExpressionClause() {
        JoinCondition.OnExpression onExpression = (JoinCondition.OnExpression)this.joinDefinition.getCondition();
        JoinStage left = (JoinStage)this.joinDefinition.getStages().get(0);
        JoinStage right = (JoinStage)this.joinDefinition.getStages().get(1);
        this.appendFullTableNameAndAlias(left.getStageName());
        this.builder.append(" ");
        this.appendJoinStatement(left, right);
        this.builder.append(onExpression.getExpression());
    }

    @VisibleForTesting
    protected void appendJoinOnKeyOperation(JoinStage left, JoinStage right, Map<String, JoinKey> stageNameToJoinKeyMap, boolean joinOnNullKeys) {
        this.appendJoinStatement(left, right);
        String leftAlias = this.getTableAlias(left.getStageName());
        String rightAlias = this.getTableAlias(right.getStageName());
        JoinKey leftKey = stageNameToJoinKeyMap.get(left.getStageName());
        JoinKey rightKey = stageNameToJoinKeyMap.get(right.getStageName());
        this.appendJoinOnKeyClause(leftAlias, leftKey, rightAlias, rightKey, joinOnNullKeys);
    }

    private void appendJoinStatement(JoinStage left, JoinStage right) {
        String joinType = left.isRequired() && right.isRequired() ? "INNER" : (left.isRequired() && !right.isRequired() ? "LEFT OUTER" : (!left.isRequired() && right.isRequired() ? "RIGHT OUTER" : "FULL OUTER"));
        this.builder.append(joinType);
        this.builder.append(" JOIN ");
        this.appendFullTableNameAndAlias(right.getStageName());
        this.builder.append(" ON ");
    }

    private void appendFullTableNameAndAlias(String stageName) {
        this.builder.append(this.getFullTableName(stageName)).append(" AS ").append(this.getTableAlias(stageName));
    }

    @VisibleForTesting
    protected void appendJoinOnKeyClause(String leftAlias, JoinKey leftKey, String rightAlias, JoinKey rightKey, boolean joinOnNullKeys) {
        this.appendEquals(leftAlias, (String)leftKey.getFields().get(0), rightAlias, (String)rightKey.getFields().get(0), joinOnNullKeys);
        for (int i = 1; i < leftKey.getFields().size(); ++i) {
            this.builder.append(" AND ");
            this.appendEquals(leftAlias, (String)leftKey.getFields().get(i), rightAlias, (String)rightKey.getFields().get(i), joinOnNullKeys);
        }
    }

    @VisibleForTesting
    protected void appendEquals(String leftTable, String leftField, String rightTable, String rightField, boolean joinOnNullKeys) {
        if (joinOnNullKeys) {
            this.builder.append("(");
        }
        this.builder.append(leftTable).append(".").append(leftField);
        this.builder.append(" = ");
        this.builder.append(rightTable).append(".").append(rightField);
        if (joinOnNullKeys) {
            this.builder.append(" OR ").append("(");
            this.builder.append(leftTable).append(".").append(leftField).append(" IS NULL");
            this.builder.append(" AND ");
            this.builder.append(rightTable).append(".").append(rightField).append(" IS NULL");
            this.builder.append(")").append(")");
        }
    }

    @VisibleForTesting
    protected String getBQTableName(String stageName) {
        String result = this.stageToBQTableNameMap.get(stageName);
        if (result == null) {
            throw new SQLEngineException(String.format("Unable to determine BQ table name for stage '%s'", stageName));
        }
        return result;
    }

    private void addTableNamesAndAliasesForJoinDefinition() {
        this.addTableNamesAndAliasesForJoinDefinition(Collections.emptyMap());
    }

    private void addTableNamesAndAliasesForJoinDefinition(Map<String, String> aliasOverrides) {
        for (JoinStage stage : this.joinDefinition.getStages()) {
            String stageName = stage.getStageName();
            if (!this.stageToFullTableNameMap.containsKey(stageName)) {
                this.addFullTableName(stageName);
            }
            if (this.stageToTableAliasMap.containsKey(stageName)) continue;
            this.addTableAlias(stageName, aliasOverrides.getOrDefault(stageName, stageName));
        }
    }

    @VisibleForTesting
    protected void addFullTableName(String stageName) {
        String bqTableName = this.getBQTableName(stageName);
        this.stageToFullTableNameMap.put(stageName, String.format("`%s.%s.%s`", this.dataset.getProject(), this.dataset.getDataset(), bqTableName));
    }

    private void addTableAlias(String stageName, String alias) {
        this.stageToTableAliasMap.put(stageName, BigQueryJoinSQLBuilder.quoteAlias(alias));
    }

    @VisibleForTesting
    protected static String quoteAlias(String alias) {
        return String.format("`%s`", alias);
    }

    @VisibleForTesting
    protected String getFullTableName(String stageName) {
        String fullTableName = this.stageToFullTableNameMap.get(stageName);
        if (fullTableName == null) {
            throw new SQLEngineException(String.format("Unable to determine full table name for stage '%s'", stageName));
        }
        return fullTableName;
    }

    private String getTableAlias(String stageName) {
        String tableAlias = this.stageToTableAliasMap.get(stageName);
        if (tableAlias == null) {
            throw new SQLEngineException(String.format("Unable to determine table alias for stage '%s'", stageName));
        }
        return tableAlias;
    }
}

