/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.builder;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryBaseSQLBuilder;
import java.util.Map;
import java.util.stream.Collectors;

public class BigQuerySelectSQLBuilder
extends BigQueryBaseSQLBuilder {
    protected final Map<String, Expression> columns;
    protected final String sourceTable;
    protected final String sourceAlias;
    protected final String filter;
    protected final StringBuilder builder;

    public BigQuerySelectSQLBuilder(Map<String, Expression> columns, String sourceTable, String sourceAlias, String filter) {
        this.columns = columns;
        this.sourceTable = sourceTable;
        this.sourceAlias = sourceAlias;
        this.filter = filter;
        this.builder = new StringBuilder();
    }

    @Override
    public String getQuery() {
        this.builder.append("SELECT ").append(this.getSelectedFields());
        this.builder.append(" FROM ").append(this.getFromSource()).append(" AS ").append(this.sourceAlias);
        if (this.filter != null) {
            this.builder.append(" WHERE ").append(this.filter);
        }
        return this.builder.toString();
    }

    protected String getFromSource() {
        return this.sourceTable;
    }

    @VisibleForTesting
    protected String getSelectedFields() {
        return this.getSelectColumnsStream(this.columns).collect(Collectors.joining(" , "));
    }
}

