/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.builder;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.etl.api.aggregation.WindowAggregationDefinition;
import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.plugin.gcp.bigquery.relational.SQLExpression;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryBaseSQLBuilder;
import io.cdap.plugin.gcp.bigquery.sqlengine.util.BigQuerySQLEngineUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryWindowsAggregationSQLBuilder
extends BigQueryBaseSQLBuilder {
    private static final String ROW_NUM_PREFIX = "rn_";
    private final WindowAggregationDefinition windowAggregationDefinition;
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryWindowsAggregationSQLBuilder.class);
    private final String source;
    private final String sourceAlias;
    private final String rowNumColumnAlias;
    private final StringBuilder builder;

    public BigQueryWindowsAggregationSQLBuilder(WindowAggregationDefinition windowAggregationDefinition, String sourceExpression, String sourceAlias) {
        this(windowAggregationDefinition, sourceExpression, sourceAlias, ROW_NUM_PREFIX + BigQuerySQLEngineUtils.newIdentifier());
    }

    protected BigQueryWindowsAggregationSQLBuilder(WindowAggregationDefinition windowAggregationDefinition, String source, String sourceAlias, String rowNumColumnAlias) {
        this.windowAggregationDefinition = windowAggregationDefinition;
        this.source = source;
        this.sourceAlias = sourceAlias;
        this.rowNumColumnAlias = rowNumColumnAlias;
        this.builder = new StringBuilder();
    }

    @VisibleForTesting
    protected String getSelectedFields(Map<String, Expression> selectedFields) {
        ArrayList<Expression> e = new ArrayList<Expression>(selectedFields.values());
        return this.getPartitionFields(e);
    }

    @Override
    public String getQuery() {
        String overClause = this.getOverClause();
        String aggregateFields = this.getAggregateFields(overClause);
        String query = "SELECT " + this.getSelectedFields(this.windowAggregationDefinition.getSelectExpressions()) + " , " + aggregateFields + " " + " FROM " + "(" + " " + this.source + " " + ")" + " " + " AS " + this.sourceAlias;
        LOG.debug("Query is " + query);
        return query;
    }

    @VisibleForTesting
    protected String getAggregateFields(String overClause) {
        Map aggregateExpressions = this.windowAggregationDefinition.getAggregateExpressions();
        return aggregateExpressions.keySet().stream().map(s -> {
            SQLExpression e = (SQLExpression)aggregateExpressions.get(s);
            return e.extract() + " " + overClause + " AS " + s;
        }).collect(Collectors.joining(" , "));
    }

    private String getOverClause() {
        return "OVER( PARTITION BY  " + this.getPartitionFields(this.windowAggregationDefinition.getPartitionExpressions()) + " " + this.getOrderByFields(this.windowAggregationDefinition.getOrderByExpressions()) + " " + this.getWindowFrameDefinition(this.windowAggregationDefinition) + " " + ")";
    }

    private String getWindowFrameDefinition(WindowAggregationDefinition windowAggregationDefinition) {
        int following;
        int preceding;
        String def = "";
        if (windowAggregationDefinition.getWindowFrameType() == WindowAggregationDefinition.WindowFrameType.NONE) {
            return def;
        }
        if (windowAggregationDefinition.getWindowFrameType() == WindowAggregationDefinition.WindowFrameType.RANGE) {
            def = def + "RANGE";
        } else if (windowAggregationDefinition.getWindowFrameType() == WindowAggregationDefinition.WindowFrameType.ROW) {
            def = def + "ROWS";
        }
        def = def + " BETWEEN ";
        def = windowAggregationDefinition.getUnboundedPreceding() ? def + "UNBOUNDED PRECEDING" : ((preceding = Integer.parseInt(windowAggregationDefinition.getPreceding())) == 0 ? def + " CURRENT ROW " : (preceding < 0 ? def + (preceding *= -1) + " PRECEDING " : def + preceding + " FOLLOWING "));
        def = def + " AND ";
        def = windowAggregationDefinition.getUnboundedFollowing() ? def + "UNBOUNDED FOLLOWING" : ((following = Integer.parseInt(windowAggregationDefinition.getFollowing())) == 0 ? def + " CURRENT ROW " : (following < 0 ? def + (following *= -1) + " PRECEDING " : def + following + " FOLLOWING "));
        return def;
    }

    @VisibleForTesting
    public String getPartitionFields(List<Expression> partitionFields) {
        return this.getExpressionSQLStream(partitionFields).collect(Collectors.joining(" , "));
    }

    @VisibleForTesting
    public String getOrderByFields(List<WindowAggregationDefinition.OrderByExpression> orderFields) {
        String order = "";
        for (WindowAggregationDefinition.OrderByExpression field : orderFields) {
            String type = field.getOrderBy().equals((Object)WindowAggregationDefinition.OrderBy.ASCENDING) ? "ASC" : "DESC";
            SQLExpression e = (SQLExpression)field.getExpression();
            if ("".equals(order)) {
                order = "ORDER BY  " + e.extract() + " " + type;
                continue;
            }
            order = order + " , " + e.extract() + " " + type;
        }
        return order;
    }
}

