/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.transform;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.engine.sql.SQLEngineException;
import io.cdap.plugin.gcp.bigquery.source.BigQueryAvroToStructuredTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class SQLEngineAvroToStructuredTransformer
extends BigQueryAvroToStructuredTransformer
implements Serializable {
    private static final String LONG_TO_INTEGER_CONVERSION_ERROR = "Could not convert Long value '%d' into Integer when reading from BigQuery";
    private static final String INTEGER_CONVERSION_ERROR = "Could not convert Object '%s' into Integer when reading from BigQuery";
    private static final String DOUBLE_TO_FLOAT_CONVERSION_ERROR = "Could not convert Double '%f' into Float when reading from BigQuery";
    private static final String FLOAT_CONVERSION_ERROR = "Could not convert Object '%s' into Float when reading from BigQuery";

    @Override
    @Nullable
    protected Object convertField(Object field, Schema fieldSchema) throws IOException {
        if (field == null) {
            return null;
        }
        Schema schema = fieldSchema;
        if (schema.isNullable()) {
            schema = schema.getNonNullable();
        }
        if (schema.getType() == Schema.Type.INT && schema.getLogicalType() == null) {
            return SQLEngineAvroToStructuredTransformer.mapInteger(field);
        }
        if (schema.getType() == Schema.Type.FLOAT && schema.getLogicalType() == null) {
            return SQLEngineAvroToStructuredTransformer.mapFloat(field);
        }
        if (schema.getType() == Schema.Type.STRING && schema.getLogicalType() == null && field instanceof ByteBuffer) {
            return StandardCharsets.UTF_8.decode((ByteBuffer)field).toString();
        }
        return super.convertField(field, fieldSchema);
    }

    @VisibleForTesting
    protected static Integer mapInteger(Object field) throws SQLEngineException {
        if (field instanceof Long) {
            Long value = (Long)field;
            Integer result = value.intValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE || (long)result.intValue() != value) {
                throw new SQLEngineException(String.format(LONG_TO_INTEGER_CONVERSION_ERROR, value));
            }
            return value.intValue();
        }
        throw new SQLEngineException(String.format(INTEGER_CONVERSION_ERROR, field));
    }

    @VisibleForTesting
    protected static Float mapFloat(Object field) {
        if (field instanceof Double) {
            Double value = (Double)field;
            Float result = Float.valueOf(value.floatValue());
            if (Math.abs(value - (double)result.floatValue()) > 1.0E-15) {
                throw new SQLEngineException(String.format(LONG_TO_INTEGER_CONVERSION_ERROR, value));
            }
            return result;
        }
        throw new SQLEngineException(String.format(FLOAT_CONVERSION_ERROR, field));
    }
}

