/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sqlengine.util;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.data.schema.Schema;
import java.util.ArrayList;
import java.util.List;

public final class BigQuerySchemaValidation {
    private final boolean isSupported;
    private final List<String> invalidFields;

    public BigQuerySchemaValidation(boolean isSupported, List<String> invalidFields) {
        this.isSupported = isSupported;
        this.invalidFields = invalidFields;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public List<String> getInvalidFields() {
        return this.invalidFields;
    }

    @VisibleForTesting
    protected static BigQuerySchemaValidation validateSchema(Schema schema) {
        ArrayList<String> invalidFields = new ArrayList<String>();
        for (Schema.Field field : schema.getFields()) {
            Schema fieldSchema = field.getSchema();
            if (fieldSchema.isNullable()) {
                fieldSchema = fieldSchema.getNonNullable();
            }
            if (fieldSchema.getType() != Schema.Type.ENUM && fieldSchema.getType() != Schema.Type.MAP && fieldSchema.getType() != Schema.Type.UNION) continue;
            invalidFields.add(field.getName());
        }
        return new BigQuerySchemaValidation(invalidFields.isEmpty(), invalidFields);
    }
}

