/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.util;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class BigQueryDataParser {
    private BigQueryDataParser() {
    }

    public static List<StructuredRecord> parse(TableResult result) {
        ArrayList<StructuredRecord> samples = new ArrayList<StructuredRecord>();
        com.google.cloud.bigquery.Schema schema = result.getSchema();
        Schema cdapSchema = BigQueryUtil.getTableSchema(schema, null);
        FieldList fields = schema.getFields();
        for (FieldValueList fieldValues : result.iterateAll()) {
            StructuredRecord record = BigQueryDataParser.getStructuredRecord(cdapSchema, fields, fieldValues);
            samples.add(record);
        }
        return samples;
    }

    public static StructuredRecord getStructuredRecord(Schema schema, FieldList fields, FieldValueList fieldValues) {
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)schema);
        for (Field field : fields) {
            String fieldName = field.getName();
            FieldValue fieldValue = fieldValues.get(fieldName);
            FieldValue.Attribute attribute = fieldValue.getAttribute();
            if (fieldValue.isNull()) {
                recordBuilder.set(fieldName, null);
                continue;
            }
            Schema.Field localField = schema.getField(fieldName);
            if (localField == null) continue;
            Schema localSchema = localField.getSchema();
            FieldList subFields = field.getSubFields();
            if (attribute == FieldValue.Attribute.REPEATED) {
                ArrayList<Object> list = new ArrayList<Object>();
                List fieldValueList = fieldValue.getRepeatedValue();
                for (FieldValue localValue : fieldValueList) {
                    if (localValue.getValue() instanceof FieldValueList) {
                        FieldValueList localFieldValueListNoSchema = localValue.getRecordValue();
                        FieldValueList localFieldValueList = FieldValueList.of((List)localFieldValueListNoSchema, (FieldList)subFields);
                        StructuredRecord componentRecord = BigQueryDataParser.getStructuredRecord(localSchema.getComponentSchema(), subFields, localFieldValueList);
                        list.add(componentRecord);
                        continue;
                    }
                    list.add(BigQueryDataParser.convertValue(field, localValue));
                }
                recordBuilder.set(fieldName, list);
                continue;
            }
            if (attribute == FieldValue.Attribute.RECORD) {
                Object value;
                FieldValue localValue = fieldValue;
                if (localValue.getValue() instanceof FieldValueList) {
                    FieldValueList localFieldValueListNoSchema = localValue.getRecordValue();
                    FieldValueList localFieldValueList = FieldValueList.of((List)localFieldValueListNoSchema, (FieldList)subFields);
                    value = BigQueryDataParser.getStructuredRecord(localSchema.getNonNullable(), subFields, localFieldValueList);
                } else {
                    value = BigQueryDataParser.convertValue(field, localValue);
                }
                BigQueryDataParser.addToRecordBuilder(recordBuilder, fieldName, value);
                continue;
            }
            Object value = BigQueryDataParser.convertValue(field, fieldValue);
            BigQueryDataParser.addToRecordBuilder(recordBuilder, fieldName, value);
        }
        StructuredRecord record = recordBuilder.build();
        return record;
    }

    private static void addToRecordBuilder(StructuredRecord.Builder recordBuilder, String fieldName, Object value) {
        if (value instanceof ZonedDateTime) {
            recordBuilder.setTimestamp(fieldName, (ZonedDateTime)value);
        } else if (value instanceof LocalTime) {
            recordBuilder.setTime(fieldName, (LocalTime)value);
        } else if (value instanceof LocalDate) {
            recordBuilder.setDate(fieldName, (LocalDate)value);
        } else if (value instanceof LocalDateTime) {
            recordBuilder.setDateTime(fieldName, (LocalDateTime)value);
        } else if (value instanceof BigDecimal) {
            recordBuilder.setDecimal(fieldName, (BigDecimal)value);
        } else {
            recordBuilder.set(fieldName, value);
        }
    }

    public static Object convertValue(Field field, FieldValue fieldValue) {
        LegacySQLTypeName type = field.getType();
        StandardSQLTypeName standardType = type.getStandardType();
        switch (standardType) {
            case TIME: {
                return LocalTime.parse(fieldValue.getStringValue());
            }
            case DATE: {
                return LocalDate.parse(fieldValue.getStringValue());
            }
            case TIMESTAMP: {
                long tsMicroValue = fieldValue.getTimestampValue();
                return BigQueryDataParser.getZonedDateTime(tsMicroValue);
            }
            case NUMERIC: {
                BigDecimal decimal = fieldValue.getNumericValue();
                if (decimal.scale() < 9) {
                    decimal = decimal.setScale(9);
                }
                return decimal;
            }
            case BIGNUMERIC: {
                BigDecimal bigDecimal = fieldValue.getNumericValue();
                if (bigDecimal.scale() < 38) {
                    bigDecimal = bigDecimal.setScale(38);
                }
                return bigDecimal;
            }
            case DATETIME: {
                return LocalDateTime.parse(fieldValue.getStringValue());
            }
            case STRING: {
                return fieldValue.getStringValue();
            }
            case BOOL: {
                return fieldValue.getBooleanValue();
            }
            case FLOAT64: {
                return fieldValue.getDoubleValue();
            }
            case INT64: {
                return fieldValue.getLongValue();
            }
            case BYTES: {
                return fieldValue.getBytesValue();
            }
        }
        throw new RuntimeException(String.format("BigQuery type %s is not supported.", standardType));
    }

    public static ZonedDateTime getZonedDateTime(long microTs) {
        long tsInSeconds = TimeUnit.MICROSECONDS.toSeconds(microTs);
        long mod = TimeUnit.MICROSECONDS.convert(1L, TimeUnit.SECONDS);
        int fraction = (int)(microTs % mod);
        Instant instant = Instant.ofEpochSecond(tsInSeconds, TimeUnit.MICROSECONDS.toNanos(fraction));
        return ZonedDateTime.ofInstant(instant, ZoneId.ofOffset("UTC", ZoneOffset.UTC));
    }
}

