/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.common;

public class HBaseColumn {
    private static final String FAMILY_QUALIFIER_DELIMITER = ":";
    private final String family;
    private final String qualifier;

    private HBaseColumn(String family, String qualifier) {
        this.family = family;
        this.qualifier = qualifier;
    }

    public static HBaseColumn fromFamilyAndQualifier(String family, String qualifier) {
        return new HBaseColumn(family, qualifier);
    }

    public static HBaseColumn fromFullName(String fullName) {
        if (!fullName.contains(FAMILY_QUALIFIER_DELIMITER)) {
            throw new IllegalArgumentException("Wrong name format. Expected format is 'family:qualifier'");
        }
        int delimiterIndex = fullName.indexOf(FAMILY_QUALIFIER_DELIMITER);
        String family = fullName.substring(0, delimiterIndex);
        String qualifier = fullName.substring(delimiterIndex + FAMILY_QUALIFIER_DELIMITER.length());
        return new HBaseColumn(family, qualifier);
    }

    public String getFamily() {
        return this.family;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getQualifiedName() {
        return String.format("%s%s%s", this.family, FAMILY_QUALIFIER_DELIMITER, this.qualifier);
    }
}

