/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.sink;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;

public class BigtableOutputFormat<KEY>
extends TableOutputFormat<KEY> {
    public RecordWriter<KEY, Mutation> getRecordWriter(final TaskAttemptContext context) throws IOException, InterruptedException {
        final RecordWriter recordWriter = super.getRecordWriter(context);
        return new RecordWriter<KEY, Mutation>(){

            public void close(TaskAttemptContext context2) throws IOException, InterruptedException {
                recordWriter.close(context2);
            }

            public void write(KEY key, Mutation value) throws IOException, InterruptedException {
                context.getCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN).increment((long)value.getRow().length);
                recordWriter.write(key, (Object)value);
            }
        };
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.setConf(context.getConfiguration());
        super.checkOutputSpecs(context);
    }
}

