/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.sink;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.gcp.bigtable.common.HBaseColumn;
import io.cdap.plugin.gcp.common.GCPReferenceSinkConfig;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class BigtableSinkConfig
extends GCPReferenceSinkConfig {
    public static final String TABLE = "table";
    public static final String INSTANCE = "instance";
    public static final String KEY_ALIAS = "keyAlias";
    public static final String COLUMN_MAPPINGS = "columnMappings";
    public static final String BIGTABLE_OPTIONS = "bigtableOptions";
    @Name(value="table")
    @Macro
    @Description(value="The table to read from. A table contains individual records organized in rows. Each record is composed of columns (also called fields). Every table is defined by a schema that describes the column names, data types, and other information.")
    final String table;
    @Name(value="instance")
    @Macro
    @Description(value="BigTable instance id. Uniquely identifies BigTable instance within your Google Cloud Platform project.")
    final String instance;
    @Name(value="keyAlias")
    @Description(value="Name of the field for row key.")
    @Macro
    final String keyAlias;
    @Name(value="columnMappings")
    @Description(value="Mappings from record field to Bigtable column name. Column names must be formatted as <family>:<qualifier>.")
    @Macro
    private final String columnMappings;
    @Name(value="bigtableOptions")
    @Description(value="Additional connection properties for Bigtable")
    @Macro
    @Nullable
    private final String bigtableOptions;

    public BigtableSinkConfig(String referenceName, String table, String instance, @Nullable String project, @Nullable String serviceAccountType, @Nullable String serviceFilePath, String keyAlias, String columnMappings, @Nullable String bigtableOptions) {
        this.referenceName = referenceName;
        this.table = table;
        this.instance = instance;
        this.project = project;
        this.serviceAccountType = serviceAccountType;
        this.serviceFilePath = serviceFilePath;
        this.keyAlias = keyAlias;
        this.columnMappings = columnMappings;
        this.bigtableOptions = bigtableOptions;
    }

    @Override
    public void validate(FailureCollector collector) {
        File serviceAccountFile;
        super.validate(collector);
        if (!this.containsMacro(TABLE) && Strings.isNullOrEmpty((String)this.table)) {
            collector.addFailure("Table name must be specified.", null).withConfigProperty(TABLE);
        }
        if (!this.containsMacro(INSTANCE) && Strings.isNullOrEmpty((String)this.instance)) {
            collector.addFailure("Instance ID must be specified.", null).withConfigProperty(INSTANCE);
        }
        String serviceAccount = this.getServiceAccount();
        if (!this.containsMacro("serviceFilePath") && !this.containsMacro("serviceAccountJSON") && serviceAccount != null && this.isServiceAccountFilePath().booleanValue() && !(serviceAccountFile = new File(serviceAccount)).exists()) {
            collector.addFailure(String.format("Service account file '%s' does not exist.", serviceAccount), "Ensure the service account file is available on the local filesystem.").withConfigProperty("serviceFilePath");
        }
    }

    public Map<String, HBaseColumn> getColumnMappings(FailureCollector collector) {
        Map specifiedMappings = Strings.isNullOrEmpty((String)this.columnMappings) ? Collections.emptyMap() : ConfigUtil.parseKeyValueConfig((String)this.columnMappings, (String)",", (String)"=");
        HashMap<String, HBaseColumn> mappings = new HashMap<String, HBaseColumn>(specifiedMappings.size());
        for (Map.Entry entry : specifiedMappings.entrySet()) {
            try {
                String field = (String)entry.getKey();
                HBaseColumn column = HBaseColumn.fromFullName((String)entry.getValue());
                mappings.put(field, column);
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Invalid column in mapping '%s'. Reason: %s", entry.getKey(), e.getMessage());
                collector.addFailure(errorMessage, "Specify valid column mappings.").withConfigElement(COLUMN_MAPPINGS, ConfigUtil.getKVPair((String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)"="));
            }
        }
        return mappings;
    }

    public Map<String, String> getBigtableOptions() {
        return Strings.isNullOrEmpty((String)this.bigtableOptions) ? Collections.emptyMap() : ConfigUtil.parseKeyValueConfig((String)this.bigtableOptions, (String)",", (String)"=");
    }

    public boolean connectionParamsConfigured() {
        return !this.containsMacro(INSTANCE) && Strings.isNullOrEmpty((String)this.instance) && !this.containsMacro("project") && Strings.isNullOrEmpty((String)this.project) && !this.containsMacro(TABLE) && Strings.isNullOrEmpty((String)this.table) && !this.containsMacro("serviceAccountType") && !this.containsMacro("serviceFilePath") && !this.containsMacro("serviceAccountJSON") && this.tryGetProject() != null && !this.autoServiceAccountUnavailable();
    }
}

