/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.bigtable.common.HBaseColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public class RecordToHBaseMutationTransformer {
    private final String keyAlias;
    private final Map<String, HBaseColumn> columnMappings;

    public RecordToHBaseMutationTransformer(String keyAlias, Map<String, HBaseColumn> columnMappings) {
        this.keyAlias = keyAlias;
        this.columnMappings = new HashMap<String, HBaseColumn>(columnMappings);
    }

    public Mutation transform(StructuredRecord record) {
        List fields = Objects.requireNonNull(record.getSchema().getFields(), "Schema fields cannot be empty");
        Schema.Field keyField = record.getSchema().getField(this.keyAlias);
        if (keyField == null) {
            throw new UnexpectedFormatException(String.format("Record does not contain key field '%s'. Keys are required", this.keyAlias));
        }
        byte[] rowKeyBytes = RecordToHBaseMutationTransformer.convertFieldValueToBytes(record.get(this.keyAlias), keyField);
        if (rowKeyBytes == null) {
            throw new UnexpectedFormatException(String.format("Key field '%s' contained a null value. Keys cannot be null", this.keyAlias));
        }
        Put put = new Put(rowKeyBytes);
        for (Schema.Field field : fields) {
            String fieldName = field.getName();
            if (fieldName.equals(this.keyAlias) || !this.columnMappings.containsKey(fieldName)) continue;
            HBaseColumn column = this.columnMappings.get(fieldName);
            byte[] valueBytes = RecordToHBaseMutationTransformer.convertFieldValueToBytes(record.get(fieldName), field);
            put.addColumn(Bytes.toBytes((String)column.getFamily()), Bytes.toBytes((String)column.getQualifier()), valueBytes);
        }
        return put;
    }

    @Nullable
    private static byte[] convertFieldValueToBytes(@Nullable Object value, Schema.Field field) {
        try {
            return RecordToHBaseMutationTransformer.convertFieldValueToBytes(value, field.getSchema());
        }
        catch (Exception e) {
            throw new UnexpectedFormatException(String.format("Failed to transform value for field '%s'. Reason: %s", field.getName(), e.getMessage()));
        }
    }

    @Nullable
    private static byte[] convertFieldValueToBytes(@Nullable Object value, Schema fieldSchema) {
        if (fieldSchema.isNullable()) {
            if (value == null) {
                return null;
            }
            return RecordToHBaseMutationTransformer.convertFieldValueToBytes(value, fieldSchema.getNonNullable());
        }
        switch (fieldSchema.getType()) {
            case STRING: {
                return Bytes.toBytes((String)((String)value));
            }
            case BYTES: {
                return (byte[])value;
            }
            case INT: {
                return Bytes.toBytes((int)((Integer)value));
            }
            case LONG: {
                return Bytes.toBytes((long)((Long)value));
            }
            case FLOAT: {
                return Bytes.toBytes((float)((Float)value).floatValue());
            }
            case DOUBLE: {
                return Bytes.toBytes((double)((Double)value));
            }
            case BOOLEAN: {
                return Bytes.toBytes((boolean)((Boolean)value));
            }
        }
        throw new UnexpectedFormatException("Field type '" + fieldSchema.getDisplayName() + "' is not supported");
    }
}

