/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.source;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;

public class BigtableInputFormat
extends TableInputFormat {
    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        final RecordReader recordReader = super.createRecordReader(split, context);
        return new RecordReader<ImmutableBytesWritable, Result>(){
            private Counter readBytes;

            public void close() throws IOException {
                recordReader.close();
            }

            public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                return (ImmutableBytesWritable)recordReader.getCurrentKey();
            }

            public Result getCurrentValue() throws IOException, InterruptedException {
                Result value = (Result)recordReader.getCurrentValue();
                this.readBytes.increment((long)value.getRow().length);
                return value;
            }

            public float getProgress() throws IOException, InterruptedException {
                return recordReader.getProgress();
            }

            public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                this.readBytes = context.getCounter((Enum)FileInputFormatCounter.BYTES_READ);
                recordReader.initialize(inputsplit, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return recordReader.nextKeyValue();
            }
        };
    }
}

