/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.source;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.gcp.bigtable.common.HBaseColumn;
import io.cdap.plugin.gcp.common.ErrorHandling;
import io.cdap.plugin.gcp.common.GCPReferenceSourceConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class BigtableSourceConfig
extends GCPReferenceSourceConfig {
    public static final String TABLE = "table";
    public static final String INSTANCE = "instance";
    public static final String KEY_ALIAS = "keyAlias";
    public static final String COLUMN_MAPPINGS = "columnMappings";
    public static final String SCAN_ROW_START = "scanRowStart";
    public static final String SCAN_ROW_STOP = "scanRowStop";
    public static final String SCAN_TIME_RANGE_START = "scanTimeRangeStart";
    public static final String SCAN_TIME_RANGE_STOP = "scanTimeRangeStop";
    public static final String BIGTABLE_OPTIONS = "bigtableOptions";
    public static final String SCHEMA = "schema";
    public static final String ON_ERROR = "on-error";
    private static final Set<Schema.Type> SUPPORTED_FIELD_TYPES = ImmutableSet.of((Object)Schema.Type.BOOLEAN, (Object)Schema.Type.INT, (Object)Schema.Type.LONG, (Object)Schema.Type.FLOAT, (Object)Schema.Type.DOUBLE, (Object)Schema.Type.BYTES, (Object[])new Schema.Type[]{Schema.Type.STRING});
    @Name(value="table")
    @Macro
    @Description(value="The table to read from. A table contains individual records organized in rows. Each record is composed of columns (also called fields). Every table is defined by a schema that describes the column names, data types, and other information.")
    final String table;
    @Name(value="instance")
    @Macro
    @Description(value="BigTable instance id. Uniquely identifies BigTable instance within your Google Cloud Platform project.")
    final String instance;
    @Name(value="keyAlias")
    @Description(value="Name of the field for row key.")
    @Macro
    @Nullable
    final String keyAlias;
    @Name(value="columnMappings")
    @Description(value="Mappings from Bigtable column name to record field. Column names must be formatted as <family>:<qualifier>.")
    @Macro
    final String columnMappings;
    @Name(value="scanRowStart")
    @Description(value="Scan start row.")
    @Macro
    @Nullable
    final String scanRowStart;
    @Name(value="scanRowStop")
    @Description(value="Scan stop row.")
    @Macro
    @Nullable
    final String scanRowStop;
    @Name(value="scanTimeRangeStart")
    @Description(value="Starting timestamp used to filter columns with a specific range of versions. Inclusive.")
    @Macro
    @Nullable
    final Long scanTimeRangeStart;
    @Name(value="scanTimeRangeStop")
    @Description(value="Ending timestamp used to filter columns with a specific range of versions. Exclusive.")
    @Macro
    @Nullable
    final Long scanTimeRangeStop;
    @Name(value="bigtableOptions")
    @Description(value="Additional connection properties for Bigtable")
    @Macro
    @Nullable
    private final String bigtableOptions;
    @Name(value="on-error")
    @Description(value="How to handle error in record processing. Error will be thrown if failed to parse value according to provided schema.")
    @Macro
    final String onError;
    @Name(value="schema")
    @Macro
    @Description(value="The schema of the table to read.")
    final String schema;

    public BigtableSourceConfig(String referenceName, String table, String instance, @Nullable String project, @Nullable String serviceAccountType, @Nullable String serviceFilePath, @Nullable String keyAlias, @Nullable String columnMappings, @Nullable String scanRowStart, @Nullable String scanRowStop, @Nullable Long scanTimeRangeStart, @Nullable Long scanTimeRangeStop, @Nullable String bigtableOptions, String onError, String schema) {
        this.referenceName = referenceName;
        this.table = table;
        this.instance = instance;
        this.columnMappings = columnMappings;
        this.bigtableOptions = bigtableOptions;
        this.project = project;
        this.serviceAccountType = serviceAccountType;
        this.serviceFilePath = serviceFilePath;
        this.keyAlias = keyAlias;
        this.scanRowStart = scanRowStart;
        this.scanRowStop = scanRowStop;
        this.scanTimeRangeStart = scanTimeRangeStart;
        this.scanTimeRangeStop = scanTimeRangeStop;
        this.onError = onError;
        this.schema = schema;
    }

    @Override
    public void validate(FailureCollector collector) {
        File serviceAccountFile;
        super.validate(collector);
        if (!this.containsMacro(TABLE) && Strings.isNullOrEmpty((String)this.table)) {
            collector.addFailure("Table name must be specified.", null).withConfigProperty(TABLE);
        }
        if (!this.containsMacro(INSTANCE) && Strings.isNullOrEmpty((String)this.instance)) {
            collector.addFailure("Instance ID must be specified.", null).withConfigProperty(INSTANCE);
        }
        String serviceAccount = this.getServiceAccount();
        if (!this.containsMacro("serviceFilePath") && !this.containsMacro("serviceAccountJSON") && serviceAccount != null && this.isServiceAccountFilePath().booleanValue() && !(serviceAccountFile = new File(serviceAccount)).exists()) {
            collector.addFailure(String.format("Service account file '%s' does not exist.", serviceAccount), "Ensure the service account file is available on the local filesystem.").withConfigProperty("serviceFilePath");
        }
        if (!this.containsMacro(ON_ERROR)) {
            if (Strings.isNullOrEmpty((String)this.onError)) {
                collector.addFailure("Error handling must be specified.", null).withConfigProperty(ON_ERROR);
            }
            if (!Strings.isNullOrEmpty((String)this.onError) && ErrorHandling.fromDisplayName(this.onError) == null) {
                collector.addFailure(String.format("Invalid record error handling strategy name '%s'.", this.onError), String.format("Supported error handling strategies are: %s.", ErrorHandling.getSupportedErrorHandling())).withConfigProperty(ON_ERROR);
            }
        }
        Map<String, String> columnMappings = this.getColumnMappings();
        if (!this.containsMacro(COLUMN_MAPPINGS)) {
            if (columnMappings.isEmpty()) {
                collector.addFailure("Column mappings are missing.", "Specify column mappings.").withConfigProperty(COLUMN_MAPPINGS);
            }
            columnMappings.forEach((columnName, fieldName) -> {
                try {
                    HBaseColumn.fromFullName(columnName);
                }
                catch (IllegalArgumentException e) {
                    String errorMessage = String.format("Invalid column in mapping '%s'. Reason: %s", columnName, e.getMessage());
                    collector.addFailure(errorMessage, "Specify valid column mappings.").withConfigElement(COLUMN_MAPPINGS, ConfigUtil.getKVPair((String)columnName, (String)((String)columnMappings.get(columnName)), (String)"="));
                }
            });
        }
        if (!this.containsMacro(SCHEMA)) {
            Schema parsedSchema = this.getSchema(collector);
            if (parsedSchema == null) {
                collector.addFailure("Output schema must be specified.", null).withConfigProperty(SCHEMA);
                throw collector.getOrThrowException();
            }
            if (Schema.Type.RECORD != parsedSchema.getType()) {
                String message = String.format("Schema is of invalid type '%s'.", parsedSchema.getType());
                collector.addFailure(message, "The schema must be a record.").withConfigProperty(SCHEMA);
                throw collector.getOrThrowException();
            }
            List fields = parsedSchema.getFields();
            if (null == fields || fields.isEmpty()) {
                collector.addFailure("Schema must contain fields.", null).withConfigProperty(SCHEMA);
                throw collector.getOrThrowException();
            }
            if (!columnMappings.isEmpty()) {
                HashSet mappedFieldNames = Sets.newHashSet(columnMappings.values());
                Set schemaFieldNames = fields.stream().map(Schema.Field::getName).filter(name -> !name.equals(this.keyAlias)).collect(Collectors.toSet());
                Sets.SetView nonMappedColumns = Sets.difference(schemaFieldNames, (Set)mappedFieldNames);
                for (String nonMappedColumn : nonMappedColumns) {
                    collector.addFailure(String.format("Field '%s' does not have corresponding column mapping.", nonMappedColumn), String.format("Add column mapping for field '%s'.", nonMappedColumn)).withOutputSchemaField(nonMappedColumn);
                }
            }
            for (Schema.Field field : fields) {
                Schema nonNullableSchema;
                Schema schema = nonNullableSchema = field.getSchema().isNullable() ? field.getSchema().getNonNullable() : field.getSchema();
                if (SUPPORTED_FIELD_TYPES.contains(nonNullableSchema.getType()) && (nonNullableSchema.getLogicalType() == Schema.LogicalType.DATETIME || nonNullableSchema.getLogicalType() == null)) continue;
                String supportedTypes = SUPPORTED_FIELD_TYPES.stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", "));
                String errorMessage = String.format("Field '%s' is of unsupported type '%s'.", field.getName(), nonNullableSchema.getDisplayName());
                collector.addFailure(errorMessage, String.format("Supported types are: datetime, %s.", supportedTypes)).withOutputSchemaField(field.getName());
            }
        }
    }

    @Nullable
    public Schema getSchema(FailureCollector collector) {
        try {
            return Strings.isNullOrEmpty((String)this.schema) ? null : Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    public Map<String, String> getColumnMappings() {
        return Strings.isNullOrEmpty((String)this.columnMappings) ? Collections.emptyMap() : ConfigUtil.parseKeyValueConfig((String)this.columnMappings, (String)",", (String)"=");
    }

    public Map<String, String> getBigtableOptions() {
        return Strings.isNullOrEmpty((String)this.bigtableOptions) ? Collections.emptyMap() : ConfigUtil.parseKeyValueConfig((String)this.bigtableOptions, (String)",", (String)"=");
    }

    public ErrorHandling getErrorHandling() {
        return Objects.requireNonNull(ErrorHandling.fromDisplayName(this.onError));
    }

    public boolean connectionParamsConfigured() {
        return !this.containsMacro(INSTANCE) && Strings.isNullOrEmpty((String)this.instance) && !this.containsMacro("project") && Strings.isNullOrEmpty((String)this.project) && !this.containsMacro(TABLE) && Strings.isNullOrEmpty((String)this.table) && !this.containsMacro("serviceAccountType") && !this.containsMacro("serviceFilePath") && !this.containsMacro("serviceAccountJSON");
    }

    public List<HBaseColumn> getRequestedColumns(FailureCollector collector) {
        ArrayList<HBaseColumn> columns = new ArrayList<HBaseColumn>();
        for (Map.Entry<String, String> entry : this.getColumnMappings().entrySet()) {
            try {
                columns.add(HBaseColumn.fromFullName(entry.getKey()));
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Invalid column in mapping '%s'. Reason: %s", entry.getKey(), e.getMessage());
                collector.addFailure(errorMessage, "Specify valid column mappings.").withConfigElement(COLUMN_MAPPINGS, ConfigUtil.getKVPair((String)entry.getKey(), (String)entry.getValue(), (String)"="));
            }
        }
        return columns;
    }
}

