/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigtable.source;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseResultToRecordTransformer {
    private final Schema schema;
    private final String keyAlias;
    private final Map<String, String> columnMappings;

    public HBaseResultToRecordTransformer(Schema schema, String keyAlias, Map<String, String> columnMappings) {
        this.schema = schema;
        this.keyAlias = keyAlias;
        this.columnMappings = new HashMap<String, String>(columnMappings);
    }

    public StructuredRecord transform(Result result) {
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)this.schema);
        if (this.keyAlias != null) {
            Object value = this.convertBytesToFieldValue(result.getRow(), this.keyAlias);
            recordBuilder.set(this.keyAlias, value);
        }
        for (Cell cell : result.rawCells()) {
            String columnName = Bytes.toString((byte[])cell.getFamilyArray()) + ':' + Bytes.toString((byte[])cell.getQualifierArray());
            String fieldName = this.columnMappings.get(columnName);
            if (fieldName == null) continue;
            Object value = this.convertBytesToFieldValue(cell.getValueArray(), fieldName);
            recordBuilder.set(fieldName, value);
        }
        return recordBuilder.build();
    }

    private Object convertBytesToFieldValue(byte[] valueArray, String fieldName) {
        try {
            Schema.Field field = this.schema.getField(fieldName);
            return HBaseResultToRecordTransformer.convertBytesToFieldValue(valueArray, field.getSchema());
        }
        catch (Exception e) {
            throw new UnexpectedFormatException(String.format("Failed to transform field '%s'. Reason: %s", fieldName, e.getMessage()));
        }
    }

    private static Object convertBytesToFieldValue(byte[] bytes, Schema fieldSchema) {
        if (fieldSchema.isNullable()) {
            if (bytes == null) {
                return null;
            }
            return HBaseResultToRecordTransformer.convertBytesToFieldValue(bytes, fieldSchema.getNonNullable());
        }
        switch (fieldSchema.getType()) {
            case STRING: {
                String stringValue = Bytes.toString((byte[])bytes);
                if (fieldSchema.getLogicalType() == Schema.LogicalType.DATETIME) {
                    try {
                        LocalDateTime.parse(stringValue);
                    }
                    catch (DateTimeParseException exception) {
                        throw new UnexpectedFormatException(String.format("Datetime field with value '%s' is not in ISO-8601 format.", stringValue), (Throwable)exception);
                    }
                }
                return stringValue;
            }
            case BYTES: {
                return bytes;
            }
            case INT: {
                return Bytes.toInt((byte[])bytes);
            }
            case LONG: {
                return Bytes.toLong((byte[])bytes);
            }
            case FLOAT: {
                return Float.valueOf(Bytes.toFloat((byte[])bytes));
            }
            case DOUBLE: {
                return Bytes.toDouble((byte[])bytes);
            }
            case BOOLEAN: {
                return Bytes.toBoolean((byte[])bytes);
            }
        }
        throw new UnexpectedFormatException("Field type '" + fieldSchema.getDisplayName() + "' is not supported");
    }
}

