/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.common;

import com.google.api.pathtemplate.ValidationException;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Strings;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.gcs.GCSPath;
import java.util.Map;
import javax.annotation.Nullable;

public class CmekUtils {
    public static final String CMEK_KEY = "gcp.cmek.key.name";
    private static final String errorMessageTemplate = "CMEK key '%s' is in location '%s' while the %s '%s' will be created in location '%s'.";
    private static final String correctiveActionTemplate = "Modify the CMEK key or %s location to be the same";

    public static void validateCmekKeyAndBucketLocation(Storage storage, @Nullable GCSPath gcsPath, CryptoKeyName cmekKey, @Nullable String location, FailureCollector collector) {
        String cmekKeyLocation;
        Bucket bucket = null;
        if (Strings.isNullOrEmpty((String)location)) {
            location = "US";
        }
        try {
            bucket = gcsPath == null ? null : storage.get(gcsPath.getBucket(), new Storage.BucketGetOption[0]);
        }
        catch (StorageException e) {
            return;
        }
        if (bucket == null && !(cmekKeyLocation = cmekKey.getLocation()).equalsIgnoreCase(location)) {
            collector.addFailure(String.format(errorMessageTemplate, cmekKey.getCryptoKey(), cmekKeyLocation, "bucket", gcsPath == null ? "temporary GCS bucket" : gcsPath.getBucket(), location), String.format(correctiveActionTemplate, "bucket")).withConfigProperty("cmekKey");
        }
    }

    @Nullable
    public static CryptoKeyName getCmekKey(@Nullable String cmekKey, FailureCollector collector) {
        CryptoKeyName cmekKeyName = null;
        if (Strings.isNullOrEmpty((String)cmekKey)) {
            return cmekKeyName;
        }
        try {
            cmekKeyName = CryptoKeyName.parse((String)cmekKey);
        }
        catch (ValidationException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty("cmekKey").withStacktrace(e.getStackTrace());
        }
        return cmekKeyName;
    }

    public static Dataset validateCmekKeyAndDatasetOrTableLocation(BigQuery bigQuery, DatasetId datasetId, @Nullable TableId tableId, CryptoKeyName cmekKey, @Nullable String location, FailureCollector collector) {
        Dataset dataset = null;
        Table table = null;
        if (Strings.isNullOrEmpty((String)location)) {
            location = "US";
        }
        try {
            dataset = bigQuery.getDataset(datasetId, new BigQuery.DatasetOption[0]);
            table = tableId == null ? null : bigQuery.getTable(tableId, new BigQuery.TableOption[0]);
        }
        catch (BigQueryException e) {
            return dataset;
        }
        String cmekKeyLocation = cmekKey.getLocation();
        if (dataset == null) {
            if (!cmekKeyLocation.equalsIgnoreCase(location)) {
                collector.addFailure(String.format(errorMessageTemplate, cmekKey.getCryptoKey(), cmekKeyLocation, "dataset", datasetId.getDataset(), location), String.format(correctiveActionTemplate, "dataset")).withConfigProperty("cmekKey");
            }
        } else if (table == null && tableId != null && !cmekKeyLocation.equalsIgnoreCase(location = dataset.getLocation())) {
            collector.addFailure(String.format(errorMessageTemplate, cmekKey.getCryptoKey(), cmekKeyLocation, "table", tableId.getTable(), location), String.format(correctiveActionTemplate, "table")).withConfigProperty("cmekKey");
        }
        return dataset;
    }

    public static CryptoKeyName getCmekKey(@Nullable String configKey, Map<String, String> arguments, FailureCollector collector) {
        String cmekKey = configKey;
        if (Strings.isNullOrEmpty((String)cmekKey)) {
            cmekKey = arguments.get(CMEK_KEY);
        }
        return CmekUtils.getCmekKey(cmekKey, collector);
    }
}

