/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum ErrorHandling {
    SKIP("skip-error"),
    FAIL_PIPELINE("fail-pipeline");

    private static final Map<String, ErrorHandling> BY_DISPLAY_NAME;
    private final String displayName;

    private ErrorHandling(String displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public static ErrorHandling fromDisplayName(String displayName) {
        return BY_DISPLAY_NAME.get(displayName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static String getSupportedErrorHandling() {
        return Arrays.stream(ErrorHandling.values()).map(ErrorHandling::getDisplayName).collect(Collectors.joining(", "));
    }

    static {
        BY_DISPLAY_NAME = Arrays.stream(ErrorHandling.values()).collect(Collectors.toMap(ErrorHandling::getDisplayName, Function.identity()));
    }
}

