/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class FileSetUtil {
    private static final String AVRO_OUTPUT_CODEC = "avro.output.codec";
    private static final String MAPRED_OUTPUT_COMPRESS = "mapred.output.compress";
    private static final String AVRO_SCHEMA_OUTPUT_KEY = "avro.schema.output.key";
    private static final String CODEC_SNAPPY = "snappy";
    private static final String CODEC_DEFLATE = "deflate";
    public static final Set<String> AVRO_CODECS = new HashSet<String>(Arrays.asList("snappy", "deflate"));
    private static final String CODEC_GZIP = "gzip";
    public static final Set<String> PARQUET_CODECS = new HashSet<String>(Arrays.asList("snappy", "gzip"));
    private static final String PARQUET_AVRO_SCHEMA = "parquet.avro.schema";
    private static final String PARQUET_COMPRESSION = "parquet.compression";
    public static final String NONE = "None";

    public static Map<String, String> getAvroCompressionConfiguration(String format, String compressionCodec, String schema, Boolean isOutputProperty) {
        HashMap<String, String> conf = new HashMap<String, String>();
        String prefix = "";
        if (isOutputProperty.booleanValue()) {
            prefix = "output.properties.";
        }
        if (FileSetUtil.isCompressionRequired(format, compressionCodec, AVRO_CODECS)) {
            String codec = compressionCodec.toLowerCase();
            conf.put(prefix + MAPRED_OUTPUT_COMPRESS, "true");
            conf.put(prefix + AVRO_SCHEMA_OUTPUT_KEY, schema);
            conf.put(prefix + AVRO_OUTPUT_CODEC, codec);
        }
        return conf;
    }

    public static Map<String, String> getParquetCompressionConfiguration(String format, String compressionCodec, String schema, Boolean isOutputProperty) {
        HashMap<String, String> conf = new HashMap<String, String>();
        String prefix = "";
        if (isOutputProperty.booleanValue()) {
            prefix = "output.properties.";
        }
        conf.put(prefix + PARQUET_AVRO_SCHEMA, schema);
        if (FileSetUtil.isCompressionRequired(format, compressionCodec, PARQUET_CODECS)) {
            conf.put(prefix + PARQUET_COMPRESSION, compressionCodec.toUpperCase());
        }
        return conf;
    }

    public static boolean isCompressionRequired(String format, String codec, Set<String> supportedCodecs) {
        if (codec != null && !codec.equalsIgnoreCase(NONE)) {
            if (!supportedCodecs.contains(codec.toLowerCase())) {
                throw new IllegalArgumentException("Unsupported compression codec " + codec + " for format " + format);
            }
            return true;
        }
        return false;
    }
}

