/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.common;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import javax.annotation.Nullable;

public class GCPConnectorConfig
extends PluginConfig {
    public static final String NAME_PROJECT = "project";
    public static final String NAME_SERVICE_ACCOUNT_TYPE = "serviceAccountType";
    public static final String NAME_SERVICE_ACCOUNT_FILE_PATH = "serviceFilePath";
    public static final String NAME_SERVICE_ACCOUNT_JSON = "serviceAccountJSON";
    public static final String AUTO_DETECT = "auto-detect";
    public static final String SERVICE_ACCOUNT_FILE_PATH = "filePath";
    public static final String SERVICE_ACCOUNT_JSON = "JSON";
    @Name(value="project")
    @Description(value="Google Cloud Project ID. It can be found on the Dashboard in the Google Cloud Platform Console.")
    @Macro
    @Nullable
    protected String project;
    @Name(value="serviceAccountType")
    @Description(value="Service account type, file path where the service account is located or the JSON content of the service account.")
    @Macro
    @Nullable
    protected String serviceAccountType;
    @Name(value="serviceFilePath")
    @Description(value="Path on the local file system of the service account key used for authorization. Can be set to 'auto-detect' when running on a Dataproc cluster. When running on other clusters, the file must be present on every node in the cluster.")
    @Macro
    @Nullable
    protected String serviceFilePath;
    @Name(value="serviceAccountJSON")
    @Description(value="Content of the service account file.")
    @Macro
    @Nullable
    protected String serviceAccountJson;

    public GCPConnectorConfig(@Nullable String project, @Nullable String serviceAccountType, @Nullable String serviceFilePath, @Nullable String serviceAccountJson) {
        this.project = project;
        this.serviceAccountType = serviceAccountType;
        this.serviceFilePath = serviceFilePath;
        this.serviceAccountJson = serviceAccountJson;
    }

    public String getProject() {
        String projectId = this.tryGetProject();
        if (projectId == null) {
            throw new IllegalArgumentException("Could not detect Google Cloud project id from the environment. Please specify a project id.");
        }
        return projectId;
    }

    @Nullable
    public String tryGetProject() {
        if (this.containsMacro(NAME_PROJECT) && Strings.isNullOrEmpty((String)this.project)) {
            return null;
        }
        String projectId = this.project;
        if (Strings.isNullOrEmpty((String)this.project) || AUTO_DETECT.equals(this.project)) {
            projectId = ServiceOptions.getDefaultProjectId();
        }
        return projectId;
    }

    @Nullable
    public String getServiceAccountFilePath() {
        if (this.containsMacro(NAME_SERVICE_ACCOUNT_FILE_PATH) || this.serviceFilePath == null || this.serviceFilePath.isEmpty() || AUTO_DETECT.equals(this.serviceFilePath)) {
            return null;
        }
        return this.serviceFilePath;
    }

    @Nullable
    public String getServiceAccountJson() {
        if (this.containsMacro(NAME_SERVICE_ACCOUNT_JSON) || Strings.isNullOrEmpty((String)this.serviceAccountJson)) {
            return null;
        }
        return this.serviceAccountJson;
    }

    @Nullable
    public String getServiceAccountType() {
        if (this.containsMacro(NAME_SERVICE_ACCOUNT_TYPE)) {
            return null;
        }
        return Strings.isNullOrEmpty((String)this.serviceAccountType) ? SERVICE_ACCOUNT_FILE_PATH : this.serviceAccountType;
    }

    @Nullable
    public Boolean isServiceAccountJson() {
        String serviceAccountType = this.getServiceAccountType();
        return Strings.isNullOrEmpty((String)serviceAccountType) ? null : Boolean.valueOf(serviceAccountType.equals(SERVICE_ACCOUNT_JSON));
    }

    @Nullable
    public Boolean isServiceAccountFilePath() {
        String serviceAccountType = this.getServiceAccountType();
        return Strings.isNullOrEmpty((String)serviceAccountType) ? null : Boolean.valueOf(serviceAccountType.equals(SERVICE_ACCOUNT_FILE_PATH));
    }

    @Nullable
    public String getServiceAccount() {
        Boolean serviceAccountJson = this.isServiceAccountJson();
        if (serviceAccountJson == null) {
            return null;
        }
        return serviceAccountJson != false ? this.getServiceAccountJson() : this.getServiceAccountFilePath();
    }

    public boolean canConnect() {
        return !this.containsMacro(NAME_SERVICE_ACCOUNT_TYPE) && !this.containsMacro(NAME_SERVICE_ACCOUNT_FILE_PATH) && !this.containsMacro(NAME_SERVICE_ACCOUNT_JSON) && !this.containsMacro(NAME_PROJECT);
    }

    @Nullable
    public Credentials getCredentials(FailureCollector collector) {
        Boolean isServiceAccountFilePath = this.isServiceAccountFilePath();
        GoogleCredentials credentials = null;
        try {
            credentials = this.getServiceAccount() == null ? null : GCPUtils.loadServiceAccountCredentials(this.getServiceAccount(), isServiceAccountFilePath);
        }
        catch (IOException e) {
            collector.addFailure(e.getMessage(), null);
        }
        return credentials;
    }

    public boolean autoServiceAccountUnavailable() {
        if (this.getServiceAccountFilePath() == null && SERVICE_ACCOUNT_FILE_PATH.equals(this.getServiceAccountType())) {
            try {
                ServiceAccountCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }
}

