/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.common;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.bigtable.repackaged.com.google.gson.Gson;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.gson.reflect.TypeToken;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.gcs.GCSPath;
import io.cdap.plugin.gcp.gcs.ServiceAccountAccessTokenProvider;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.threeten.bp.Duration;

public class GCPUtils {
    public static final String FS_GS_PROJECT_ID = "fs.gs.project.id";
    private static final Gson GSON = new Gson();
    private static final Type SCOPES_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final String SERVICE_ACCOUNT_TYPE = "cdap.auth.service.account.type";
    private static final String SERVICE_ACCOUNT = "cdap.auth.service.account";
    private static final String SERVICE_ACCOUNT_SCOPES = "cdap.auth.service.account.scopes";
    private static final String SERVICE_ACCOUNT_TYPE_FILE_PATH = "filePath";
    private static final String GCS_PREFIX = "fs.gs";
    private static final String BQ_PREFIX = "mapred.bq";
    public static final List<String> BIGQUERY_SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/bigquery");

    public static GoogleCredentials loadServiceAccountFileCredentials(String path) throws IOException {
        return GCPUtils.loadServiceAccountCredentials(path, true);
    }

    public static GoogleCredentials loadServiceAccountCredentials(String serviceAccount, boolean isServiceAccountFilePath) throws IOException {
        try (InputStream inputStream = GCPUtils.openServiceAccount(serviceAccount, isServiceAccountFilePath);){
            GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)inputStream);
            return googleCredentials;
        }
    }

    public static InputStream openServiceAccount(String serviceAccount, boolean isFile) throws FileNotFoundException {
        if (isFile) {
            return new FileInputStream(serviceAccount);
        }
        return new ByteArrayInputStream(serviceAccount.getBytes(StandardCharsets.UTF_8));
    }

    public static Map<String, String> generateGCSAuthProperties(@Nullable String serviceAccount, String serviceAccountType) {
        return GCPUtils.generateAuthProperties(serviceAccount, serviceAccountType, (Collection<String>)CredentialFactory.GCS_SCOPES, GCS_PREFIX);
    }

    public static Map<String, String> generateBigQueryAuthProperties(@Nullable String serviceAccount, String serviceAccountType) {
        ArrayList<String> scopes = new ArrayList<String>((Collection<String>)CredentialFactory.GCS_SCOPES);
        scopes.addAll(BIGQUERY_SCOPES);
        return GCPUtils.generateAuthProperties(serviceAccount, serviceAccountType, scopes, GCS_PREFIX, BQ_PREFIX);
    }

    private static Map<String, String> generateAuthProperties(@Nullable String serviceAccount, String serviceAccountType, Collection<String> scopes, String ... prefixes) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(SERVICE_ACCOUNT_TYPE, serviceAccountType);
        if (serviceAccount != null) {
            properties.put(SERVICE_ACCOUNT, serviceAccount);
        }
        if (!scopes.isEmpty()) {
            properties.put(SERVICE_ACCOUNT_SCOPES, GSON.toJson(scopes));
        }
        for (String prefix : prefixes) {
            properties.put(prefix + ".auth.access.token.provider.impl", ServiceAccountAccessTokenProvider.class.getName());
        }
        return properties;
    }

    public static GoogleCredentials loadCredentialsFromConf(Configuration conf) throws IOException {
        GoogleCredentials credentials;
        List scopes;
        String serviceAccountType = conf.get(SERVICE_ACCOUNT_TYPE);
        String serviceAccount = conf.get(SERVICE_ACCOUNT);
        String scopesStr = conf.get(SERVICE_ACCOUNT_SCOPES);
        List list = scopes = scopesStr == null ? null : (List)GSON.fromJson(scopesStr, SCOPES_TYPE);
        if (serviceAccount == null) {
            credentials = GoogleCredentials.getApplicationDefault().createScoped(new String[0]);
        } else {
            boolean isFile = SERVICE_ACCOUNT_TYPE_FILE_PATH.equals(serviceAccountType);
            credentials = GCPUtils.loadServiceAccountCredentials(serviceAccount, isFile);
        }
        if (scopes != null && scopes.size() > 0) {
            return credentials.createScoped((Collection)scopes);
        }
        return credentials;
    }

    public static Map<String, String> getFileSystemProperties(GCPConnectorConfig config, String path, Map<String, String> properties) {
        return GCPUtils.getFileSystemProperties(config.getProject(), config.getServiceAccount(), config.getServiceAccountType(), path, properties);
    }

    private static Map<String, String> getFileSystemProperties(String project, String serviceAccount, String serviceAccountType, String path, Map<String, String> properties) {
        try {
            properties.putAll(GCPUtils.generateGCSAuthProperties(serviceAccount, serviceAccountType));
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties.put("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        properties.put("fs.AbstractFileSystem.gs.impl", GoogleHadoopFS.class.getName());
        properties.put(FS_GS_PROJECT_ID, project);
        properties.put("fs.gs.system.bucket", GCSPath.from(path).getBucket());
        properties.put("fs.gs.path.encoding", "uri-path");
        properties.put("fs.gs.working.dir", "/");
        properties.put("fs.gs.impl.disable.cache", "true");
        return properties;
    }

    public static BigQuery getBigQuery(String project, @Nullable Credentials credentials) {
        BigQueryOptions.Builder bigqueryBuilder = (BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(project);
        if (credentials != null) {
            Collection currentScopes;
            HashSet<String> scopes = new HashSet<String>(BIGQUERY_SCOPES);
            if (credentials instanceof ServiceAccountCredentials) {
                scopes.addAll(((ServiceAccountCredentials)credentials).getScopes());
            } else if (credentials instanceof ExternalAccountCredentials && (currentScopes = ((ExternalAccountCredentials)credentials).getScopes()) != null) {
                scopes.addAll(currentScopes);
            }
            if (credentials instanceof GoogleCredentials) {
                credentials = ((GoogleCredentials)credentials).createScoped(scopes);
            }
            bigqueryBuilder.setCredentials(credentials);
        }
        return (BigQuery)bigqueryBuilder.build().getService();
    }

    public static Storage getStorage(String project, @Nullable Credentials credentials) {
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(project);
        if (credentials != null) {
            builder.setCredentials(credentials);
        }
        builder.setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)1L)).setMaxRetryDelay(Duration.ofSeconds((long)30L)).setRetryDelayMultiplier(1.5).setInitialRpcTimeout(Duration.ofSeconds((long)50L)).setMaxRpcTimeout(Duration.ofSeconds((long)50L)).setMaxAttempts(60).setTotalTimeout(Duration.ofMinutes((long)15L)).build());
        return (Storage)builder.build().getService();
    }

    public static void createBucket(Storage storage, String bucket, @Nullable String location, @Nullable CryptoKeyName cmekKeyName) throws StorageException {
        BucketInfo.Builder builder = BucketInfo.newBuilder((String)bucket);
        if (location != null) {
            builder.setLocation(location);
        }
        if (cmekKeyName != null) {
            builder.setDefaultKmsKeyName(cmekKeyName.toString());
        }
        storage.create(builder.build(), new Storage.BucketTargetOption[0]);
    }
}

