/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.common;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;

public class Schemas {
    private Schemas() {
    }

    public static void validateFieldsMatch(Schema trueSchema, Schema providedSchema, FailureCollector failureCollector) {
        for (Schema.Field field : providedSchema.getFields()) {
            Schema providedNonNullable;
            Schema.Field trueField = trueSchema.getField(field.getName());
            if (trueField == null) {
                failureCollector.addFailure(String.format("Field '%s' does not exist in the schema.", field.getName()), null).withOutputSchemaField(field.getName());
                return;
            }
            Schema trueFieldSchema = trueField.getSchema();
            Schema providedFieldSchema = field.getSchema();
            boolean isTrueFieldNullable = trueFieldSchema.isNullable();
            boolean isProvidedFieldNullable = providedFieldSchema.isNullable();
            Schema trueNonNullable = isTrueFieldNullable ? trueFieldSchema.getNonNullable() : trueFieldSchema;
            Schema schema = providedNonNullable = isProvidedFieldNullable ? providedFieldSchema.getNonNullable() : providedFieldSchema;
            if (Schemas.incompatibleLogicalTypes(trueNonNullable, providedNonNullable) || trueNonNullable.getType() != providedNonNullable.getType()) {
                failureCollector.addFailure(String.format("Field '%s' is of unexpected type '%s'.", field.getName(), providedNonNullable.getDisplayName()), String.format("It must be of type '%s'.", trueNonNullable.getDisplayName())).withOutputSchemaField(field.getName());
            }
            if (isTrueFieldNullable || !isProvidedFieldNullable) continue;
            failureCollector.addFailure(String.format("Field '%s' must not be nullable.", field.getName()), null).withOutputSchemaField(field.getName());
        }
    }

    private static boolean incompatibleLogicalTypes(Schema trueNonNullable, Schema providedNonNullable) {
        if (providedNonNullable.getLogicalType() == Schema.LogicalType.DATETIME) {
            return trueNonNullable.getType() != Schema.Type.STRING;
        }
        return trueNonNullable.getLogicalType() != providedNonNullable.getLogicalType();
    }
}

