/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.crypto;

import io.cdap.plugin.gcp.crypto.Decryptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedFileSystem
extends FilterFileSystem {
    private static final String CONF_PREFIX = "io.cdap.crypto.fs.";
    private static final String FS_SCHEME = "io.cdap.crypto.fs.scheme";
    private static final String FS_IMPL = "io.cdap.crypto.fs.impl";
    private static final String DECRYPTOR_IMPL = "io.cdap.crypto.fs.decryptor.impl";
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedFileSystem.class);
    private Decryptor decryptor;

    public static Map<String, String> configure(String scheme, Class<? extends Decryptor> decryptorClass, Map<String, String> properties) {
        String fsClass = properties.get("fs." + scheme + ".impl");
        if (fsClass == null) {
            throw new IllegalArgumentException("Missing implementation for FileSystem scheme " + scheme);
        }
        properties.put(FS_SCHEME, scheme);
        properties.put(FS_IMPL, fsClass);
        properties.put("fs." + scheme + ".impl", EncryptedFileSystem.class.getName());
        properties.put(DECRYPTOR_IMPL, decryptorClass.getName());
        LOG.debug("Configured FileSystem scheme {} to use {}", (Object)scheme, (Object)EncryptedFileSystem.class.getName());
        return properties;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        String scheme = conf.get(FS_SCHEME);
        Class fsClass = conf.getClass(FS_IMPL, null, FileSystem.class);
        Class decryptorClass = conf.getClass(DECRYPTOR_IMPL, null, Decryptor.class);
        if (scheme == null) {
            throw new IllegalArgumentException("Missing configuration 'io.cdap.crypto.fs.scheme'");
        }
        if (fsClass == null) {
            throw new IllegalArgumentException("Missing configuration 'io.cdap.crypto.fs.impl'");
        }
        if (decryptorClass == null) {
            throw new IllegalArgumentException("Missing configuration 'io.cdap.crypto.fs.decryptor.impl'");
        }
        LOG.debug("Initializing for scheme {} with class {}", (Object)scheme, (Object)fsClass.getName());
        Configuration copyConf = new Configuration(conf);
        copyConf.setClass("fs." + scheme + ".impl", fsClass, FileSystem.class);
        this.fs = FileSystem.get((URI)name, (Configuration)copyConf);
        this.statistics = FileSystem.getStatistics((String)this.fs.getScheme(), this.fs.getClass());
        try {
            this.decryptor = (Decryptor)decryptorClass.newInstance();
            if (this.decryptor instanceof Configurable) {
                ((Configurable)this.decryptor).setConf(copyConf);
            }
            LOG.debug("Decryptor class used for decryption is {}", (Object)decryptorClass.getName());
        }
        catch (Exception e) {
            throw new IOException("Failed to instantiate Decryptor class " + decryptorClass, e);
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)((Object)new SeekableByteChannelFSInputStream(this.decryptor.open(this.fs, path, bufferSize))));
    }

    private static final class SeekableByteChannelFSInputStream
    extends FSInputStream {
        private final SeekableByteChannel seekableChannel;
        private final InputStream is;

        SeekableByteChannelFSInputStream(SeekableByteChannel seekableChannel) {
            this.seekableChannel = seekableChannel;
            this.is = Channels.newInputStream(seekableChannel);
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] bytes, int off, int len) throws IOException {
            return this.is.read(bytes, off, len);
        }

        public synchronized void seek(long position) throws IOException {
            this.seekableChannel.position(position);
        }

        public synchronized long getPos() throws IOException {
            return this.seekableChannel.position();
        }

        public boolean seekToNewSource(long l) {
            return false;
        }
    }
}

