/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class FSInputSeekableByteChannel
implements SeekableByteChannel {
    private final long size;
    private final FSDataInputStream is;
    private final ReadableByteChannel readChannel;

    public FSInputSeekableByteChannel(FileSystem fs, Path path, int bufferSize) throws IOException {
        this.size = fs.getFileStatus(path).getLen();
        this.is = fs.open(path, bufferSize);
        this.readChannel = Channels.newChannel((InputStream)this.is);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.readChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) {
        throw new UnsupportedOperationException("write is not support");
    }

    @Override
    public long position() throws IOException {
        return this.is.getPos();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.is.seek(newPosition);
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("truncate is not support");
    }

    @Override
    public boolean isOpen() {
        return this.readChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.readChannel.close();
    }
}

