/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.dataplex.common.config;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataplexBaseConfig
extends PluginConfig {
    protected static final String REFERENCE_NAME = "referenceName";
    protected static final String NAME_LAKE = "lake";
    protected static final String NAME_ZONE = "zone";
    protected static final String NAME_LOCATION = "location";
    protected static final String NAME_CONNECTION = "connection";
    private static final Logger LOG = LoggerFactory.getLogger(DataplexBaseConfig.class);
    @Name(value="referenceName")
    @Nullable
    @Description(value="Name used to uniquely identify this plugin for lineage, annotating metadata, etc.")
    protected String referenceName;
    @Name(value="location")
    @Macro
    @Description(value="ID of the location in which the Dataplex lake has been created, which can be found on the details page of the lake.")
    protected String location;
    @Name(value="lake")
    @Macro
    @Description(value="ID of the Dataplex lake, which can be found on the details page of the lake.")
    protected String lake;
    @Name(value="zone")
    @Macro
    @Description(value="ID of the Dataplex zone, which can be found on the details page of the zone.")
    protected String zone;
    @Name(value="connection")
    @Nullable
    @Macro
    @Description(value="The existing connection to use.")
    protected GCPConnectorConfig connection;

    public String getReferenceName(String fqn) {
        return Strings.isNullOrEmpty((String)this.referenceName) ? ReferenceNames.normalizeFqn((String)fqn) : this.referenceName;
    }

    public String getLake() {
        return this.lake;
    }

    public String getZone() {
        return this.zone;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean autoServiceAccountUnavailable() {
        if (this.connection == null || this.connection.getServiceAccountFilePath() == null && this.connection.isServiceAccountFilePath().booleanValue()) {
            try {
                ServiceAccountCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public GoogleCredentials getCredentials(FailureCollector failureCollector) {
        GoogleCredentials credentials = null;
        if (this.connection.isServiceAccountJson().booleanValue() || this.connection.getServiceAccountFilePath() != null) {
            credentials = (GoogleCredentials)this.connection.getCredentials(failureCollector);
            return credentials;
        }
        try {
            credentials = ServiceAccountCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            failureCollector.addFailure(e.getMessage(), null);
        }
        return credentials;
    }

    public String getProject() {
        if (this.connection == null) {
            throw new IllegalArgumentException("Could not get project information, connection should not be null!");
        }
        return this.connection.getProject();
    }

    public GCPConnectorConfig getConnection() {
        return this.connection;
    }

    @Nullable
    public String tryGetProject() {
        return this.connection == null ? null : this.connection.tryGetProject();
    }

    @Nullable
    public String getServiceAccount() {
        return this.connection == null ? null : this.connection.getServiceAccount();
    }

    @Nullable
    public String getServiceAccountType() {
        return this.connection == null ? null : this.connection.getServiceAccountType();
    }

    @Nullable
    public Boolean isServiceAccountFilePath() {
        return this.connection == null ? null : this.connection.isServiceAccountFilePath();
    }

    public GoogleCredentials validateAndGetServiceAccountCredentials(FailureCollector failureCollector) {
        GoogleCredentials credentials = null;
        credentials = this.getCredentials(failureCollector);
        if (credentials == null) {
            failureCollector.addFailure(String.format("Unable to load credentials from %s.", this.connection.isServiceAccountFilePath() != false ? this.connection.getServiceAccountFilePath() : "provided JSON key"), "Ensure the service account file is available on the local filesystem.").withConfigProperty("serviceFilePath").withConfigProperty("serviceAccountJSON");
        }
        return credentials;
    }

    protected void configureDataplexException(String dataplexConfigProperty, String dataplexConfigPropType, ApiException e, FailureCollector failureCollector) {
        if (StatusCode.Code.NOT_FOUND.equals((Object)e.getStatusCode().getCode()) || StatusCode.Code.INVALID_ARGUMENT.equals((Object)e.getStatusCode().getCode())) {
            failureCollector.addFailure(String.format("'%s' could not be found. Please ensure that it exists in Dataplex.", dataplexConfigProperty), null).withConfigProperty(dataplexConfigPropType);
            return;
        }
        if (StatusCode.Code.PERMISSION_DENIED.equals((Object)e.getStatusCode().getCode()) || StatusCode.Code.UNAUTHENTICATED.equals((Object)e.getStatusCode().getCode())) {
            failureCollector.addFailure(String.format("'%s' could not be accessed. Please ensure that you have required permissions.", dataplexConfigProperty), null).withConfigProperty(dataplexConfigPropType);
            return;
        }
        failureCollector.addFailure(e.getCause().getMessage(), null).withConfigProperty(dataplexConfigPropType);
    }

    @Nullable
    public String getServiceAccountFilePath() {
        return this.connection == null ? null : this.connection.getServiceAccountFilePath();
    }

    public String getServiceAccountEmail() throws IOException {
        if (this.connection.isServiceAccountJson().booleanValue() || this.connection.getServiceAccountFilePath() != null) {
            try (InputStream inputStream = GCPUtils.openServiceAccount(this.getServiceAccount(), this.isServiceAccountFilePath());){
                ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
                String string = credentials.getClientEmail();
                return string;
            }
        }
        ComputeEngineCredentials credentials = (ComputeEngineCredentials)ServiceAccountCredentials.getApplicationDefault();
        if (credentials.getAccount().startsWith("service-")) {
            return credentials.getAccount().substring(8, credentials.getAccount().indexOf("@")) + "-compute@developer.gserviceaccount.com";
        }
        return credentials.getAccount();
    }
}

