/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.dataplex.common.util;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.dataplex.v1.DataplexServiceClient;
import com.google.cloud.dataplex.v1.DataplexServiceSettings;
import com.google.cloud.dataplex.v1.Entity;
import com.google.cloud.dataplex.v1.Job;
import com.google.cloud.dataplex.v1.JobName;
import com.google.cloud.dataplex.v1.MetadataServiceClient;
import com.google.cloud.dataplex.v1.MetadataServiceSettings;
import com.google.cloud.dataplex.v1.Partition;
import com.google.cloud.dataplex.v1.Schema;
import com.google.cloud.dataplex.v1.TaskName;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataplexUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DataplexUtil.class);
    private static final String SERVICE_ACCOUNT_JSON = "google.cloud.auth.service.account.json";
    private static final String SERVICE_ACCOUNT_KEYFILE = "google.cloud.auth.service.account.json.keyfile";

    public static io.cdap.cdap.api.data.schema.Schema getTableSchema(Schema dataplexTableSchema, @Nullable FailureCollector collector) {
        Schema.Field schemaField;
        List fields = dataplexTableSchema.getFieldsList();
        ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>();
        for (Schema.SchemaField field : fields) {
            schemaField = DataplexUtil.getPartitionField(field, collector, null);
            if (schemaField == null) continue;
            schemaFields.add(schemaField);
        }
        if (dataplexTableSchema.getPartitionFieldsList() != null && !dataplexTableSchema.getPartitionFieldsList().isEmpty()) {
            for (Schema.PartitionField partitionField : dataplexTableSchema.getPartitionFieldsList()) {
                schemaField = DataplexUtil.getPartitionField(partitionField, collector, null);
                if (schemaField == null) continue;
                schemaFields.add(schemaField);
            }
        }
        if (!schemaFields.isEmpty() && collector != null && !collector.getValidationFailures().isEmpty()) {
            collector.getOrThrowException();
        }
        if (schemaFields.isEmpty()) {
            return null;
        }
        return io.cdap.cdap.api.data.schema.Schema.recordOf((String)"output", schemaFields);
    }

    @Nullable
    private static Schema.Field getPartitionField(Schema.SchemaField field, @Nullable FailureCollector collector, @Nullable String recordPrefix) {
        io.cdap.cdap.api.data.schema.Schema schema = DataplexUtil.convertFieldTypeForPartitionFields(field, collector, recordPrefix);
        if (schema == null) {
            return null;
        }
        Schema.Mode mode = field.getMode() == null ? Schema.Mode.NULLABLE : field.getMode();
        switch (mode) {
            case NULLABLE: {
                return Schema.Field.of((String)field.getName(), (io.cdap.cdap.api.data.schema.Schema)io.cdap.cdap.api.data.schema.Schema.nullableOf((io.cdap.cdap.api.data.schema.Schema)schema));
            }
            case REQUIRED: {
                return Schema.Field.of((String)field.getName(), (io.cdap.cdap.api.data.schema.Schema)schema);
            }
            case REPEATED: {
                return Schema.Field.of((String)field.getName(), (io.cdap.cdap.api.data.schema.Schema)io.cdap.cdap.api.data.schema.Schema.arrayOf((io.cdap.cdap.api.data.schema.Schema)schema));
            }
        }
        String error = String.format("Field '%s' has unsupported mode '%s'.", field.getName(), mode);
        if (collector == null) {
            throw new RuntimeException(error);
        }
        collector.addFailure(error, null);
        return null;
    }

    @Nullable
    private static io.cdap.cdap.api.data.schema.Schema convertFieldTypeForPartitionFields(Schema.SchemaField field, @Nullable FailureCollector collector, @Nullable String recordPrefix) {
        Schema.Type standardType = field.getType();
        if (standardType.equals((Object)Schema.Type.RECORD)) {
            List fields = field.getFieldsList();
            ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>();
            String recordName = "";
            if (recordPrefix != null) {
                recordName = recordPrefix + '.';
            }
            recordName = recordName + field.getName();
            for (Schema.SchemaField f : fields) {
                Schema.Field schemaField = DataplexUtil.getPartitionField(f, collector, recordName);
                if (schemaField == null) continue;
                schemaFields.add(schemaField);
            }
            if (!schemaFields.isEmpty()) {
                return io.cdap.cdap.api.data.schema.Schema.recordOf((String)recordName, schemaFields);
            }
            return null;
        }
        return DataplexUtil.convertFieldBasedOnStandardType(standardType, field.getName(), collector);
    }

    private static io.cdap.cdap.api.data.schema.Schema convertFieldBasedOnStandardType(Schema.Type standardType, String fieldName, FailureCollector collector) {
        switch (standardType) {
            case FLOAT: 
            case DOUBLE: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.DOUBLE);
            }
            case BOOLEAN: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BOOLEAN);
            }
            case BYTE: 
            case INT16: 
            case INT32: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.INT);
            }
            case INT64: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.LONG);
            }
            case STRING: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.STRING);
            }
            case BINARY: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.BYTES);
            }
            case TIME: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.LogicalType)Schema.LogicalType.TIME_MICROS);
            }
            case DATE: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.LogicalType)Schema.LogicalType.DATE);
            }
            case TIMESTAMP: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.LogicalType)Schema.LogicalType.TIMESTAMP_MICROS);
            }
            case DECIMAL: {
                return io.cdap.cdap.api.data.schema.Schema.decimalOf((int)38, (int)9);
            }
            case NULL: {
                return io.cdap.cdap.api.data.schema.Schema.of((Schema.Type)Schema.Type.NULL);
            }
        }
        String error = String.format("Entity column '%s' is of unsupported type '%s'.", fieldName, standardType.name());
        String action = String.format("Supported column types are: %s.", BigQueryUtil.BQ_TYPE_MAP.keySet().stream().map(t -> t.getStandardType().name()).collect(Collectors.joining(", ")));
        if (collector == null) {
            throw new RuntimeException(error + action);
        }
        collector.addFailure(error, action);
        return null;
    }

    @Nullable
    private static Schema.Field getPartitionField(Schema.PartitionField field, @Nullable FailureCollector collector, @Nullable String recordPrefix) {
        io.cdap.cdap.api.data.schema.Schema schema = DataplexUtil.convertFieldTypeForPartitionFields(field, collector, recordPrefix);
        if (schema == null) {
            return null;
        }
        return Schema.Field.of((String)field.getName(), (io.cdap.cdap.api.data.schema.Schema)io.cdap.cdap.api.data.schema.Schema.nullableOf((io.cdap.cdap.api.data.schema.Schema)schema));
    }

    @Nullable
    private static io.cdap.cdap.api.data.schema.Schema convertFieldTypeForPartitionFields(Schema.PartitionField field, @Nullable FailureCollector collector, @Nullable String recordPrefix) {
        Schema.Type standardType = field.getType();
        return DataplexUtil.convertFieldBasedOnStandardType(standardType, field.getName(), collector);
    }

    public static void getJobCompletion(Configuration conf) throws IOException {
        GoogleCredentials googleCredentials = DataplexUtil.getCredentialsFromConfiguration(conf);
        String projectID = conf.get("dataplex.gcp.project.id");
        String location = conf.get("dataplex.location.id");
        String lake = conf.get("dataplex.lake.id");
        String taskId = conf.get("dataplex.task.id");
        try (DataplexServiceClient dataplexServiceClient = DataplexUtil.getDataplexServiceClient(googleCredentials);){
            DataplexServiceClient.ListJobsPagedResponse jobList = dataplexServiceClient.listJobs(TaskName.newBuilder().setProject(projectID).setLake(lake).setLocation(location).setTask(taskId).build());
            Job dataplexJob = (Job)jobList.iterateAll().iterator().next();
            try {
                Awaitility.await().atMost(30L, TimeUnit.MINUTES).pollInterval(15L, TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).until(() -> {
                    Job currentJob = dataplexServiceClient.getJob(JobName.newBuilder().setProject(projectID).setLocation(location).setLake(lake).setTask(taskId).setJob(dataplexJob.getUid()).build());
                    LOG.debug("State of the Job is still " + currentJob.getState());
                    return currentJob.getState() != null && !Job.State.RUNNING.equals((Object)currentJob.getState()) && !Job.State.STATE_UNSPECIFIED.equals((Object)currentJob.getState());
                });
            }
            catch (ConditionTimeoutException e) {
                throw new IOException("Job timed out.", e);
            }
            Job completedJob = dataplexServiceClient.getJob(JobName.newBuilder().setProject(projectID).setLocation(location).setLake(lake).setTask(taskId).setJob(dataplexJob.getUid()).build());
            if (!Job.State.SUCCEEDED.equals((Object)completedJob.getState())) {
                throw new IOException("Job failed with message: " + completedJob.getMessage());
            }
            String outputLocation = conf.get("mapreduce.input.fileinputformat.inputdir");
            outputLocation = outputLocation + completedJob.getName().replace("/jobs/", "/") + "-0/0/";
            conf.set("mapreduce.input.fileinputformat.inputdir", outputLocation);
        }
    }

    private static GoogleCredentials getCredentialsFromConfiguration(Configuration configuration) throws IOException {
        String serviceAccount;
        String serviceAccountType = configuration.get("cdap.gcs.auth.service.account.type.flag");
        Boolean isServiceAccountJson = false;
        if (serviceAccountType == "JSON") {
            isServiceAccountJson = true;
            serviceAccount = configuration.get(SERVICE_ACCOUNT_JSON);
        } else {
            serviceAccount = configuration.get(SERVICE_ACCOUNT_KEYFILE);
        }
        String filePath = configuration.get("cdap.gcs.auth.service.account.type.filepath");
        return DataplexUtil.getCredentialsFromServiceAccount(isServiceAccountJson, filePath, serviceAccount);
    }

    private static GoogleCredentials getCredentialsFromServiceAccount(Boolean isServiceAccountJson, String filePath, String serviceAccount) throws IOException {
        if (isServiceAccountJson.booleanValue() || filePath != null && !filePath.equalsIgnoreCase("none")) {
            return GCPUtils.loadServiceAccountCredentials(serviceAccount, isServiceAccountJson == false);
        }
        return GoogleCredentials.getApplicationDefault();
    }

    public static DataplexServiceClient getDataplexServiceClient(GoogleCredentials credentials) throws IOException {
        DataplexServiceSettings dataplexServiceSettings = null;
        DataplexServiceClient dataplexServiceClient = null;
        try {
            dataplexServiceSettings = ((DataplexServiceSettings.Builder)DataplexServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
            dataplexServiceClient = DataplexServiceClient.create((DataplexServiceSettings)dataplexServiceSettings);
        }
        catch (IOException e) {
            LOG.error("Failed to get DataplexServiceClient. Check the credentials");
            throw new IOException("Failed to get DataplexServiceClient");
        }
        return dataplexServiceClient;
    }

    public static MetadataServiceClient getMetadataServiceClient(GoogleCredentials credentials) throws IOException {
        MetadataServiceSettings metadataServiceSettings = null;
        MetadataServiceClient metadataServiceClient = null;
        try {
            metadataServiceSettings = ((MetadataServiceSettings.Builder)MetadataServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
            metadataServiceClient = MetadataServiceClient.create((MetadataServiceSettings)metadataServiceSettings);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Failed to get MetadataServiceClient. Check the credentials");
            throw new IOException("Failed to get DataplexServiceClient");
        }
        return metadataServiceClient;
    }

    public static String getStorageFormatForEntity(String format) {
        switch (format) {
            case "avro": {
                return "application/x-avro";
            }
            case "csv": {
                return "text/csv";
            }
            case "json": {
                return "application/json";
            }
            case "orc": {
                return "application/x-orc";
            }
            case "parquet": {
                return "application/x-parquet";
            }
        }
        return "undefined";
    }

    public static Schema getDataplexSchema(io.cdap.cdap.api.data.schema.Schema schema) throws IOException {
        Schema.Builder dataplexSchemaBuilder = Schema.newBuilder();
        dataplexSchemaBuilder.setUserManaged(true);
        if (schema == null) {
            return dataplexSchemaBuilder.build();
        }
        dataplexSchemaBuilder.addAllFields((Iterable)Objects.requireNonNull(schema.getFields()).stream().filter(avroField -> !avroField.getName().equals("ts")).map(DataplexUtil::toDataplexSchemaField).collect(Collectors.toList()));
        Schema.Field partitionField = Schema.Field.of((String)"ts", (io.cdap.cdap.api.data.schema.Schema)schema);
        dataplexSchemaBuilder.setPartitionStyle(Schema.PartitionStyle.HIVE_COMPATIBLE);
        dataplexSchemaBuilder.addPartitionFields(DataplexUtil.toDataplexPartitionField(partitionField));
        return dataplexSchemaBuilder.build();
    }

    private static Schema.SchemaField toDataplexSchemaField(Schema.Field avroField) {
        Schema.SchemaField.Builder fieldBuilder = Schema.SchemaField.newBuilder();
        fieldBuilder.setName(avroField.getName());
        fieldBuilder.setType(DataplexUtil.dataplexFieldType(avroField));
        fieldBuilder.setMode(DataplexUtil.dataplexFieldMode(avroField));
        if (avroField.getSchema().getType() == Schema.Type.RECORD) {
            fieldBuilder.addAllFields((Iterable)avroField.getSchema().getFields().stream().filter(schemaField -> !schemaField.getName().equals("ts")).map(DataplexUtil::toDataplexSchemaField).collect(Collectors.toList()));
        }
        return fieldBuilder.build();
    }

    private static Schema.PartitionField toDataplexPartitionField(Schema.Field avroField) {
        Schema.PartitionField.Builder partitionFieldBuilder = Schema.PartitionField.newBuilder();
        partitionFieldBuilder.setName(avroField.getName());
        partitionFieldBuilder.setType(Schema.Type.STRING);
        return partitionFieldBuilder.build();
    }

    private static Schema.Mode dataplexFieldMode(Schema.Field field) {
        Schema.Type type = field.getSchema().getType();
        if (type == Schema.Type.ARRAY) {
            return Schema.Mode.REPEATED;
        }
        if (type == Schema.Type.UNION) {
            for (io.cdap.cdap.api.data.schema.Schema innerSchema : field.getSchema().getUnionSchemas()) {
                if (innerSchema.getType() != Schema.Type.NULL) continue;
                return Schema.Mode.NULLABLE;
            }
        }
        return Schema.Mode.REQUIRED;
    }

    private static Schema.Type dataplexFieldType(Schema.Field field) {
        io.cdap.cdap.api.data.schema.Schema schema = field.getSchema();
        if (schema.getType() == Schema.Type.UNION) {
            if (schema.isNullable()) {
                return DataplexUtil.dataplexPrimitiveFieldType(schema.getNonNullable());
            }
            return Schema.Type.TYPE_UNSPECIFIED;
        }
        if (schema.getType() == Schema.Type.ARRAY) {
            return DataplexUtil.dataplexPrimitiveFieldType(schema.getComponentSchema());
        }
        return DataplexUtil.dataplexPrimitiveFieldType(schema);
    }

    private static Schema.Type dataplexPrimitiveFieldType(io.cdap.cdap.api.data.schema.Schema schema) {
        Schema.Type type;
        if (schema.getLogicalType() != null && (type = DataplexUtil.dataplexLogicalFieldType(schema)) != null) {
            return type;
        }
        Schema.Type avroType = schema.getType();
        switch (avroType) {
            case RECORD: {
                return Schema.Type.RECORD;
            }
            case STRING: {
                return Schema.Type.STRING;
            }
            case FLOAT: {
                return Schema.Type.FLOAT;
            }
            case DOUBLE: {
                return Schema.Type.DOUBLE;
            }
            case BOOLEAN: {
                return Schema.Type.BOOLEAN;
            }
            case NULL: {
                return Schema.Type.NULL;
            }
            case BYTES: {
                return Schema.Type.BINARY;
            }
            case INT: {
                return Schema.Type.INT32;
            }
            case LONG: {
                return Schema.Type.INT64;
            }
        }
        return Schema.Type.TYPE_UNSPECIFIED;
    }

    private static Schema.Type dataplexLogicalFieldType(io.cdap.cdap.api.data.schema.Schema schema) {
        Schema.LogicalType logicalType = schema.getLogicalType();
        if (logicalType == Schema.LogicalType.DECIMAL) {
            return Schema.Type.DECIMAL;
        }
        if (logicalType == Schema.LogicalType.DATE) {
            return Schema.Type.DATE;
        }
        if (logicalType == Schema.LogicalType.TIME_MICROS || logicalType == Schema.LogicalType.TIME_MILLIS) {
            return Schema.Type.TIME;
        }
        if (logicalType == Schema.LogicalType.TIMESTAMP_MICROS || logicalType == Schema.LogicalType.TIMESTAMP_MILLIS) {
            return Schema.Type.TIMESTAMP;
        }
        return null;
    }

    public static void addPartitionInfo(Entity entity, GoogleCredentials credentials, String bucketName, String tableName, String project) throws IOException {
        Storage storage = GCPUtils.getStorage(project, (Credentials)credentials);
        String delimiter = "/";
        String partitionPrefix = "ts=";
        Page blobs = storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(tableName + delimiter + partitionPrefix)), Storage.BlobListOption.currentDirectory()});
        String lastPartition = null;
        for (Blob blob : blobs.iterateAll()) {
            lastPartition = blob.getName();
        }
        String location = "gs://" + bucketName + delimiter + lastPartition.substring(0, lastPartition.length() - 1);
        String[] lastPartitionParts = lastPartition.split(delimiter);
        Partition.Builder dataplexPartitionBuilder = Partition.newBuilder();
        try (MetadataServiceClient metadataServiceClient = DataplexUtil.getMetadataServiceClient(credentials);){
            Partition partition = dataplexPartitionBuilder.setLocation(location).addValues(lastPartitionParts[lastPartitionParts.length - 1].substring(partitionPrefix.length())).build();
            metadataServiceClient.createPartition(entity.getName(), partition);
        }
    }
}

