/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.dataplex.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.validation.FormatContext;
import io.cdap.cdap.etl.api.validation.ValidatingOutputFormat;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryOutputFormat;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.dataplex.sink.DataplexOutputCommitter;
import io.cdap.plugin.gcp.gcs.sink.GCSOutputFormatProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DataplexOutputFormatProvider
implements ValidatingOutputFormat {
    public static final String DATAPLEX_ASSET_TYPE = "dataplexsink.assettype";
    public static final String DATAPLEX_OUTPUT_BASE_DIR = "dataplex.output.fileoutputformat.baseoutputdir";
    private static DataplexOutputCommitter dataplexOutputCommitter;
    private final ValidatingOutputFormat delegate;
    private final Configuration configuration;
    private final Schema tableSchema;

    public DataplexOutputFormatProvider(@Nullable Configuration configuration, @Nullable Schema tableSchema, @Nullable ValidatingOutputFormat delegate) {
        this.configuration = configuration;
        this.tableSchema = tableSchema;
        this.delegate = delegate;
    }

    public void validate(FormatContext context) {
        this.delegate.validate(context);
    }

    public String getOutputFormatClassName() {
        return DataplexOutputFormat.class.getName();
    }

    public Map<String, String> getOutputFormatConfiguration() {
        if (this.delegate == null) {
            Map<String, String> configToMap = BigQueryUtil.configToMap(this.configuration);
            if (this.tableSchema != null) {
                configToMap.put("cdap.bq.sink.output.schema", this.tableSchema.toString());
            }
            return configToMap;
        }
        HashMap<String, String> outputFormatConfiguration = new HashMap<String, String>(this.delegate.getOutputFormatConfiguration());
        outputFormatConfiguration.put("gcssink.delegate.outputformat.classname", this.delegate.getOutputFormatClassName());
        return outputFormatConfiguration;
    }

    public static class DataplexRecordWriter
    extends RecordWriter<Object, Object> {
        private final RecordWriter originalWriter;
        private long recordCount;

        public DataplexRecordWriter(RecordWriter originalWriter) {
            this.originalWriter = originalWriter;
        }

        public void write(Object keyOut, Object valOut) throws IOException, InterruptedException {
            this.originalWriter.write(keyOut, valOut);
            ++this.recordCount;
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.originalWriter.close(taskAttemptContext);
            taskAttemptContext.getConfiguration().setLong(String.format("recordcount.%s", taskAttemptContext.getTaskAttemptID()), this.recordCount);
        }
    }

    public static class DataplexOutputFormat
    extends OutputFormat<Object, Object> {
        private final OutputFormat<NullWritable, StructuredRecord> gcsDelegateFormat = new GCSOutputFormatProvider.GCSOutputFormat();
        private final OutputFormat<StructuredRecord, NullWritable> bqDelegateFormat = new BigQueryOutputFormat();

        private OutputFormat getDelegateFormatInstance(Configuration configuration) throws IOException {
            String assetType = configuration.get(DataplexOutputFormatProvider.DATAPLEX_ASSET_TYPE);
            if (assetType.equalsIgnoreCase("BIGQUERY_DATASET")) {
                return this.bqDelegateFormat;
            }
            return this.gcsDelegateFormat;
        }

        public RecordWriter<Object, Object> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            RecordWriter originalWriter = this.getDelegateFormatInstance(taskAttemptContext.getConfiguration()).getRecordWriter(taskAttemptContext);
            return new DataplexRecordWriter(originalWriter);
        }

        public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
            this.getDelegateFormatInstance(jobContext.getConfiguration()).checkOutputSpecs(jobContext);
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            OutputCommitter delegateCommitter = this.getDelegateFormatInstance(taskAttemptContext.getConfiguration()).getOutputCommitter(taskAttemptContext);
            dataplexOutputCommitter = new DataplexOutputCommitter(delegateCommitter);
            return dataplexOutputCommitter;
        }
    }
}

