/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.dataplex.sink.config;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.dataplex.v1.Asset;
import com.google.cloud.dataplex.v1.AssetName;
import com.google.cloud.dataplex.v1.DataplexServiceClient;
import com.google.cloud.dataplex.v1.LakeName;
import com.google.cloud.dataplex.v1.Zone;
import com.google.cloud.dataplex.v1.ZoneName;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.InvalidPluginConfigException;
import io.cdap.cdap.api.plugin.InvalidPluginProperty;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.validation.FormatContext;
import io.cdap.cdap.etl.api.validation.ValidatingOutputFormat;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.format.FileFormat;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sink.Operation;
import io.cdap.plugin.gcp.bigquery.sink.PartitionType;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.dataplex.common.config.DataplexBaseConfig;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataplexBatchSinkConfig
extends DataplexBaseConfig {
    private static final Set<Schema.Type> SUPPORTED_CLUSTERING_TYPES = ImmutableSet.of((Object)Schema.Type.INT, (Object)Schema.Type.LONG, (Object)Schema.Type.STRING, (Object)Schema.Type.BOOLEAN, (Object)Schema.Type.BYTES);
    private static final Set<FileFormat> SUPPORTED_FORMATS_FOR_CURATED_ZONE = ImmutableSet.of((Object)FileFormat.AVRO, (Object)FileFormat.ORC, (Object)FileFormat.PARQUET);
    private static final int MAX_NUMBER_OF_COLUMNS = 4;
    private static final String NAME_SUFFIX = "suffix";
    private static final String NAME_TABLE = "table";
    private static final String NAME_ASSET = "asset";
    private static final String NAME_ASSET_TYPE = "assetType";
    private static final Logger LOG = LoggerFactory.getLogger(DataplexBatchSinkConfig.class);
    private static final String WHERE = "WHERE";
    protected static final String NAME_FORMAT = "format";
    private static final String NAME_TABLE_KEY = "tableKey";
    private static final String NAME_DEDUPE_BY = "dedupeBy";
    private static final String NAME_OPERATION = "operation";
    private static final String NAME_PARTITION_FILTER = "partitionFilter";
    private static final String NAME_PARTITIONING_TYPE = "partitioningType";
    private static final String NAME_TRUNCATE_TABLE = "truncateTable";
    private static final String NAME_UPDATE_DATAPLEX_METADATA = "updateDataplexMetadata";
    private static final String NAME_UPDATE_SCHEMA = "allowSchemaRelaxation";
    private static final String NAME_PARTITION_BY_FIELD = "partitionField";
    private static final String NAME_REQUIRE_PARTITION_FIELD = "requirePartitionField";
    private static final String NAME_CLUSTERING_ORDER = "clusteringOrder";
    private static final String NAME_RANGE_START = "rangeStart";
    private static final String NAME_RANGE_END = "rangeEnd";
    private static final String NAME_RANGE_INTERVAL = "rangeInterval";
    private static final String NAME_SCHEMA = "schema";
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_APPLICATION_AVRO = "application/x-avro";
    private static final String CONTENT_TYPE_APPLICATION_PARQUET = "application/x-parquet";
    private static final String CONTENT_TYPE_APPLICATION_ORC = "application/x-orc";
    private static final String CONTENT_TYPE_TEXT_CSV = "text/csv";
    private static final String FORMAT_AVRO = "avro";
    private static final String FORMAT_CSV = "csv";
    private static final String FORMAT_JSON = "json";
    private static final String FORMAT_ORC = "orc";
    private static final String FORMAT_PARQUET = "parquet";
    private static final Pattern FIELD_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    private static final Map<String, String> contentTypeMap = ImmutableMap.of((Object)"avro", (Object)"application/x-avro", (Object)"csv", (Object)"text/csv", (Object)"json", (Object)"application/json", (Object)"parquet", (Object)"application/x-parquet", (Object)"orc", (Object)"application/x-orc");
    @Name(value="asset")
    @Macro
    @Description(value="ID of the Dataplex asset. It represents a cloud resource that is being managed within a lake as a member of a zone.")
    protected String asset;
    @Name(value="assetType")
    @Nullable
    @Description(value="Type of asset selected to ingest the data in Dataplex.")
    protected String assetType;
    @Name(value="format")
    @Nullable
    @Macro
    @Description(value="The format to write the records in. The format for a raw zone must be one of \u2018json\u2019, \u2018avro\u2019, \u2018csv\u2019,\u2018orc\u2019, or \u2018parquet\u2019.  The format for a curated zone must be one of \u2018avro\u2019, \u2018orc\u2019, or \u2018parquet\u2019.")
    protected String format;
    @Name(value="table")
    @Nullable
    @Macro
    @Description(value="The table to write to. It can be BigQuery table if Asset is of Type 'BigQuery Dataset' or a directory if Asset is of type 'Storage Bucket'")
    protected String table;
    @Name(value="tableKey")
    @Nullable
    @Macro
    @Description(value="List of fields that determine relation between tables during Update and Upsert operations.")
    protected String tableKey;
    @Name(value="dedupeBy")
    @Nullable
    @Macro
    @Description(value="Column names and sort order used to choose which input record to update/upsert when there are multiple input records with the same key. For example, if this is set to \u2018updated_time desc\u2019, then if there are multiple input records with the same key, the one with the largest value for \u2018updated_time\u2019 will be applied.")
    protected String dedupeBy;
    @Name(value="operation")
    @Nullable
    @Macro
    @Description(value="Type of write operation to perform. This can be set to Insert, Update, or Upsert.")
    protected String operation;
    @Name(value="partitionFilter")
    @Nullable
    @Macro
    @Description(value="Partition filter that can be used for partition elimination during Update or Upsert operations. Only Use with Update or Upsert operations for tables where Require Partition Filter is enabled. For example, if the table is partitioned and the Partition Filter  is \u2018_PARTITIONTIME > \u201c2020-01-01\u201d and _PARTITIONTIME < \u201c2020-03-01\u201d\u2018, the update operation will be performed only in the partitions meeting the criteria.")
    protected String partitionFilter;
    @Name(value="partitioningType")
    @Nullable
    @Macro
    @Description(value="Specifies the partitioning type. Can either be Integer, Time, or None. Defaults to Time. This value is ignored if the table already exists.")
    protected String partitioningType;
    @Name(value="rangeStart")
    @Nullable
    @Macro
    @Description(value="Start value for range partitioning. The start value is inclusive. Ignored when table already exists")
    protected Long rangeStart;
    @Name(value="rangeEnd")
    @Nullable
    @Macro
    @Description(value="End value for range partitioning. The end value is exclusive. Ignored when table already exists")
    protected Long rangeEnd;
    @Name(value="rangeInterval")
    @Nullable
    @Macro
    @Description(value="Interval value for range partitioning. The interval value must be a positive integer. Ignored when table already exists")
    protected Long rangeInterval;
    @Name(value="truncateTable")
    @Nullable
    @Macro
    @Description(value="Whether or not to truncate the table before writing to it. Only use with the Insert operation.")
    protected Boolean truncateTable;
    @Name(value="updateDataplexMetadata")
    @Nullable
    @Macro
    @Description(value="Whether to update Dataplex metadata for the newly created entities.If enabled, the pipeline will automatically copy the output schema to the destination Dataplex entities, and the automated Dataplex Discovery won't run for them.")
    protected Boolean updateDataplexMetadata;
    @Name(value="allowSchemaRelaxation")
    @Nullable
    @Macro
    @Description(value="Whether the BigQuery table schema should be modified when it does not match the schema expected by the pipeline.")
    protected Boolean allowSchemaRelaxation;
    @Name(value="partitionField")
    @Nullable
    @Macro
    @Description(value="Partitioning column for the BigQuery table. Leave blank if the BigQuery table is an ingestion-time partitioned table.")
    protected String partitionByField;
    @Name(value="requirePartitionField")
    @Nullable
    @Macro
    @Description(value="Whether to create a table that requires a partition filter. This value is ignored if the table already exists.")
    protected Boolean requirePartitionField;
    @Name(value="clusteringOrder")
    @Nullable
    @Macro
    @Description(value="List of fields that determines the sort order of the data. Fields must be of type INT, LONG, STRING, DATE, TIMESTAMP, BOOLEAN, or DECIMAL. Tables cannot be clustered on more than 4 fields. This value is only used when the BigQuery table is automatically created and ignored if the table already exists.")
    protected String clusteringOrder;
    @Nullable
    @Macro
    @Description(value="The time format for the output directory that will be appended to the path. For example, the format 'yyyy-MM-dd-HH-mm' will result in a directory of the form '2015-01-01-20-42'.")
    private String suffix;
    @Name(value="schema")
    @Nullable
    @Macro
    @Description(value="The schema of the data to write. If provided, must be compatible with the table schema.")
    private String schema;

    public String getAsset() {
        return this.asset;
    }

    public String getAssetType() {
        return this.assetType;
    }

    @Nullable
    public FileFormat getFormat() {
        return FileFormat.from((String)this.format, FileFormat::canWrite);
    }

    @Nullable
    public String getFormatStr() {
        return this.format;
    }

    @Nullable
    public String getTable() {
        return this.table;
    }

    @Nullable
    public String getTableKey() {
        return Strings.isNullOrEmpty((String)this.tableKey) ? null : this.tableKey;
    }

    @Nullable
    public String getDedupeBy() {
        return Strings.isNullOrEmpty((String)this.dedupeBy) ? null : this.dedupeBy;
    }

    @Nullable
    public Operation getOperation() {
        return Strings.isNullOrEmpty((String)this.operation) ? Operation.INSERT : Operation.valueOf(this.operation.toUpperCase());
    }

    @Nullable
    public String getPartitionFilter() {
        if (Strings.isNullOrEmpty((String)this.partitionFilter)) {
            return null;
        }
        this.partitionFilter = this.partitionFilter.trim();
        if (this.partitionFilter.toUpperCase().startsWith(WHERE)) {
            this.partitionFilter = this.partitionFilter.substring(WHERE.length());
        }
        return this.partitionFilter;
    }

    @Nullable
    public PartitionType getPartitioningType() {
        return Strings.isNullOrEmpty((String)this.partitioningType) ? PartitionType.TIME : PartitionType.valueOf(this.partitioningType.toUpperCase());
    }

    @Nullable
    public Long getRangeStart() {
        return this.rangeStart;
    }

    @Nullable
    public Long getRangeEnd() {
        return this.rangeEnd;
    }

    @Nullable
    public Long getRangeInterval() {
        return this.rangeInterval;
    }

    @Nullable
    public Boolean isTruncateTable() {
        return this.truncateTable != null && this.truncateTable != false;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.isTruncateTable() != false ? JobInfo.WriteDisposition.WRITE_TRUNCATE : JobInfo.WriteDisposition.WRITE_APPEND;
    }

    @Nullable
    public Boolean isUpdateDataplexMetadata() {
        return this.updateDataplexMetadata != null && this.updateDataplexMetadata != false;
    }

    @Nullable
    public Boolean isUpdateTableSchema() {
        return this.allowSchemaRelaxation != null && this.allowSchemaRelaxation != false;
    }

    @Nullable
    public String getPartitionByField() {
        return Strings.isNullOrEmpty((String)this.partitionByField) ? null : this.partitionByField;
    }

    @Nullable
    public Boolean isRequirePartitionField() {
        return this.requirePartitionField != null && this.requirePartitionField != false;
    }

    @Nullable
    public String getClusteringOrder() {
        return Strings.isNullOrEmpty((String)this.clusteringOrder) ? null : this.clusteringOrder;
    }

    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    public void validateBigQueryDataset(FailureCollector collector) {
        if (!this.containsMacro(NAME_TABLE)) {
            if (this.table == null) {
                collector.addFailure(String.format("Required property '%s' has no value.", NAME_TABLE), null).withConfigProperty(NAME_TABLE);
                collector.getOrThrowException();
            }
            BigQueryUtil.validateTable(this.table, NAME_TABLE, collector);
        }
        if (this.getWriteDisposition().equals((Object)JobInfo.WriteDisposition.WRITE_TRUNCATE) && !this.getOperation().equals((Object)Operation.INSERT)) {
            collector.addFailure("Truncate must only be used with operation 'Insert'.", "Set Truncate to false, or change the Operation to 'Insert'.").withConfigProperty(NAME_TRUNCATE_TABLE).withConfigProperty(NAME_OPERATION);
        }
    }

    @Nullable
    public io.cdap.cdap.api.data.schema.Schema getSchema(FailureCollector collector) {
        if (Strings.isNullOrEmpty((String)this.schema)) {
            return null;
        }
        try {
            return io.cdap.cdap.api.data.schema.Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(NAME_SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    public void validateAssetConfiguration(FailureCollector collector, DataplexServiceClient dataplexServiceClient) {
        if (!Strings.isNullOrEmpty((String)this.referenceName)) {
            IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        }
        String projectID = this.tryGetProject();
        if (!(Strings.isNullOrEmpty((String)this.location) || this.containsMacro("location") || Strings.isNullOrEmpty((String)this.lake) || this.containsMacro("lake"))) {
            try {
                dataplexServiceClient.getLake(LakeName.newBuilder().setProject(projectID).setLocation(this.location).setLake(this.lake).build());
            }
            catch (ApiException e) {
                if (e.getMessage().contains("Location")) {
                    this.configureDataplexException(this.location, "location", e, collector);
                } else {
                    this.configureDataplexException(this.lake, "lake", e, collector);
                }
                return;
            }
            if (!Strings.isNullOrEmpty((String)this.zone) && !this.containsMacro("zone")) {
                Zone zoneBean;
                try {
                    zoneBean = dataplexServiceClient.getZone(ZoneName.newBuilder().setProject(projectID).setLocation(this.location).setLake(this.lake).setZone(this.zone).build());
                }
                catch (ApiException e) {
                    this.configureDataplexException(this.zone, "zone", e, collector);
                    return;
                }
                if (!Strings.isNullOrEmpty((String)this.asset) && !this.containsMacro(NAME_ASSET)) {
                    try {
                        FileFormat fileFormat;
                        Asset assetBean = dataplexServiceClient.getAsset(AssetName.newBuilder().setProject(projectID).setLocation(this.location).setLake(this.lake).setZone(this.zone).setAsset(this.asset).build());
                        if (!this.assetType.equalsIgnoreCase(assetBean.getResourceSpec().getType().toString())) {
                            collector.addFailure("Asset type doesn't match with actual asset. ", null).withConfigProperty(NAME_ASSET_TYPE);
                        }
                        if (zoneBean != null && assetBean != null && assetBean.getResourceSpec().getType().equals((Object)Asset.ResourceSpec.Type.STORAGE_BUCKET) && zoneBean.getType().equals((Object)Zone.Type.CURATED) && !this.containsMacro(NAME_FORMAT) && !Strings.isNullOrEmpty((String)this.format) && !SUPPORTED_FORMATS_FOR_CURATED_ZONE.contains(fileFormat = this.getFormat())) {
                            collector.addFailure(String.format("Format '%s' is not supported for curated zone", fileFormat.toString().toLowerCase()), null).withConfigProperty(NAME_FORMAT);
                        }
                    }
                    catch (ApiException e) {
                        this.configureDataplexException(this.asset, NAME_ASSET, e, collector);
                        return;
                    }
                }
            }
        }
        collector.getOrThrowException();
    }

    public void validateBigQueryDataset(@Nullable io.cdap.cdap.api.data.schema.Schema inputSchema, @Nullable io.cdap.cdap.api.data.schema.Schema outputSchema, FailureCollector collector, DataplexServiceClient dataplexServiceClient) {
        if (this.containsMacro("location") || this.containsMacro("lake") || this.containsMacro("zone") || this.containsMacro(NAME_ASSET)) {
            return;
        }
        this.validateBigQueryDataset(collector);
        if (!this.containsMacro(NAME_SCHEMA)) {
            io.cdap.cdap.api.data.schema.Schema schema = outputSchema == null ? inputSchema : outputSchema;
            try {
                Asset assetBean = dataplexServiceClient.getAsset(AssetName.newBuilder().setProject(this.tryGetProject()).setLocation(this.location).setLake(this.lake).setZone(this.zone).setAsset(this.asset).build());
                String[] assetValues = assetBean.getResourceSpec().getName().split("/");
                String dataset = assetValues[assetValues.length - 1];
                String datasetProject = assetValues[assetValues.length - 3];
                this.validatePartitionProperties(schema, collector, dataset, datasetProject);
                this.validateClusteringOrder(schema, collector);
                this.validateOperationProperties(schema, collector);
                this.validateConfiguredSchema(schema, collector, dataset);
            }
            catch (Exception e) {
                LOG.debug(String.format("%s: %s", e.getLocalizedMessage(), e.getMessage()));
            }
            if (outputSchema == null) {
                return;
            }
            List<String> schemaFields = Objects.requireNonNull(schema.getFields()).stream().map(Schema.Field::getName).map(String::toLowerCase).collect(Collectors.toList());
            Set<String> duplicatedFields = BigQuerySinkUtils.getDuplicatedFields(schemaFields);
            for (Schema.Field field : outputSchema.getFields()) {
                String name = field.getName();
                if (!FIELD_PATTERN.matcher(name).matches()) {
                    collector.addFailure(String.format("Output field '%s' must only contain alphanumeric characters and '_'.", name), null).withOutputSchemaField(name);
                }
                if (!field.getSchema().isNullable() && inputSchema != null && inputSchema.getField(field.getName()) == null) {
                    collector.addFailure(String.format("Required output field '%s' must be present in input schema.", field.getName()), "Change the field to be nullable.").withOutputSchemaField(name);
                }
                if (!duplicatedFields.contains(name.toLowerCase())) continue;
                collector.addFailure(String.format("Output field '%s' is duplicated.", name), "BigQuery is case insensitive and does not allow two fields with the same name.").withOutputSchemaField(name);
            }
        }
    }

    private void validateConfiguredSchema(io.cdap.cdap.api.data.schema.Schema schema, FailureCollector collector, String dataset) {
        if (!this.shouldConnect()) {
            return;
        }
        String tableName = this.getTable();
        Table table = BigQueryUtil.getBigQueryTable(this.tryGetProject(), dataset, tableName, this.connection.getServiceAccount(), this.connection.isServiceAccountFilePath(), collector);
        if (table != null && !this.containsMacro(NAME_UPDATE_SCHEMA)) {
            Schema bqSchema = table.getDefinition().getSchema();
            if (this.getOperation().equals((Object)Operation.INSERT)) {
                BigQuerySinkUtils.validateInsertSchema(table, schema, this.isUpdateTableSchema(), this.isTruncateTable(), dataset, collector);
            } else if (this.getOperation().equals((Object)Operation.UPSERT)) {
                BigQuerySinkUtils.validateSchema(tableName, bqSchema, schema, this.isUpdateTableSchema(), this.isTruncateTable(), dataset, collector);
            }
        }
    }

    private void validatePartitionProperties(@Nullable io.cdap.cdap.api.data.schema.Schema schema, FailureCollector collector, String dataset, String datasetProject) {
        if (this.tryGetProject() == null) {
            return;
        }
        String project = datasetProject;
        String tableName = this.getTable();
        String serviceAccount = this.getServiceAccount();
        if (project == null || dataset == null || tableName == null || serviceAccount == null) {
            return;
        }
        Table table = BigQueryUtil.getBigQueryTable(project, dataset, tableName, serviceAccount, this.isServiceAccountFilePath(), collector);
        if (table != null) {
            StandardTableDefinition tableDefinition = (StandardTableDefinition)table.getDefinition();
            TimePartitioning timePartitioning = tableDefinition.getTimePartitioning();
            if (timePartitioning == null) {
                LOG.warn(String.format("The plugin is configured to auto-create a partitioned table, but table '%s' already exists without partitioning. Please verify the partitioning configuration.", table.getTableId().getTable()));
            }
            RangePartitioning rangePartitioning = tableDefinition.getRangePartitioning();
            if (timePartitioning == null && rangePartitioning == null) {
                LOG.warn(String.format("The plugin is configured to auto-create a partitioned table, but table '%s' already exists without partitioning. Please verify the partitioning configuration.", table.getTableId().getTable()));
            } else if (timePartitioning != null) {
                this.validateTimePartitionTableWithInputConfiguration(table, timePartitioning, collector);
            } else {
                this.validateRangePartitionTableWithInputConfiguration(table, rangePartitioning, collector);
            }
            this.validateColumnForPartition(this.partitionByField, schema, collector);
        }
    }

    private void validateTimePartitionTableWithInputConfiguration(Table table, TimePartitioning timePartitioning, FailureCollector collector) {
        PartitionType partitioningType = this.getPartitioningType();
        if (partitioningType == PartitionType.TIME && timePartitioning.getField() != null && !timePartitioning.getField().equals(this.partitionByField)) {
            collector.addFailure(String.format("Destination table '%s' is partitioned by column '%s'.", table.getTableId().getTable(), timePartitioning.getField()), String.format("Set the partition field to '%s'.", timePartitioning.getField())).withConfigProperty(NAME_PARTITION_BY_FIELD);
        } else if (partitioningType != PartitionType.TIME) {
            LOG.warn(String.format("The plugin is configured to %s, but table '%s' already exists with Time partitioning. Please verify the partitioning configuration.", partitioningType == PartitionType.INTEGER ? "auto-create a Integer partitioned table" : "auto-create table without partition", table.getTableId().getTable()));
        }
    }

    private void validateRangePartitionTableWithInputConfiguration(Table table, RangePartitioning rangePartitioning, FailureCollector collector) {
        PartitionType partitioningType = this.getPartitioningType();
        if (partitioningType != PartitionType.INTEGER) {
            LOG.warn(String.format("The plugin is configured to %s, but table '%s' already exists with Integer partitioning. Please verify the partitioning configuration.", partitioningType == PartitionType.TIME ? "auto-create a Time partitioned table" : "auto-create table without partition", table.getTableId().getTable()));
        } else if (rangePartitioning.getField() != null && !rangePartitioning.getField().equals(this.partitionByField)) {
            collector.addFailure(String.format("Destination table '%s' is partitioned by column '%s'.", table.getTableId().getTable(), rangePartitioning.getField()), String.format("Set the partition field to '%s'.", rangePartitioning.getField())).withConfigProperty(NAME_PARTITION_BY_FIELD);
        }
    }

    private void validateColumnForPartition(@Nullable String columnName, @Nullable io.cdap.cdap.api.data.schema.Schema schema, FailureCollector collector) {
        if (this.containsMacro(NAME_PARTITION_BY_FIELD) || this.containsMacro(NAME_PARTITIONING_TYPE) || schema == null) {
            return;
        }
        PartitionType partitioningType = this.getPartitioningType();
        if (Strings.isNullOrEmpty((String)columnName)) {
            if (partitioningType == PartitionType.INTEGER) {
                collector.addFailure("Partition column not provided.", "Set the column for integer partitioning.").withConfigProperty(NAME_PARTITION_BY_FIELD);
            }
            return;
        }
        Schema.Field field = schema.getField(columnName);
        if (field == null) {
            collector.addFailure(String.format("Partition column '%s' must be present in the schema.", columnName), "Change the Partition column to be one of the schema fields.").withConfigProperty(NAME_PARTITION_BY_FIELD);
            return;
        }
        io.cdap.cdap.api.data.schema.Schema fieldSchema = field.getSchema();
        io.cdap.cdap.api.data.schema.Schema schema2 = fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
        if (partitioningType == PartitionType.TIME) {
            this.validateTimePartitioningColumn(columnName, collector, fieldSchema);
        } else if (partitioningType == PartitionType.INTEGER) {
            this.validateIntegerPartitioningColumn(columnName, collector, fieldSchema);
            this.validateIntegerPartitioningRange(this.getRangeStart(), this.getRangeEnd(), this.getRangeInterval(), collector);
        }
    }

    private void validateTimePartitioningColumn(String columnName, FailureCollector collector, io.cdap.cdap.api.data.schema.Schema fieldSchema) {
        Schema.LogicalType logicalType = fieldSchema.getLogicalType();
        if (logicalType != Schema.LogicalType.DATE && logicalType != Schema.LogicalType.TIMESTAMP_MICROS && logicalType != Schema.LogicalType.TIMESTAMP_MILLIS) {
            collector.addFailure(String.format("Partition column '%s' is of invalid type '%s'.", columnName, fieldSchema.getDisplayName()), "Partition column must be a date or timestamp.").withConfigProperty(NAME_PARTITION_BY_FIELD).withOutputSchemaField(columnName).withInputSchemaField(columnName);
        }
    }

    private void validateIntegerPartitioningRange(Long rangeStart, Long rangeEnd, Long rangeInterval, FailureCollector collector) {
        if (!this.containsMacro(NAME_RANGE_START) && rangeStart == null) {
            collector.addFailure("Range Start is not defined.", "For Integer Partitioning, Range Start must be defined.").withConfigProperty(NAME_RANGE_START);
        }
        if (!this.containsMacro(NAME_RANGE_END) && rangeEnd == null) {
            collector.addFailure("Range End is not defined.", "For Integer Partitioning, Range End must be defined.").withConfigProperty(NAME_RANGE_END);
        }
        if (!this.containsMacro(NAME_RANGE_INTERVAL)) {
            if (rangeInterval == null) {
                collector.addFailure("Range Interval is not defined.", "For Integer Partitioning, Range Interval must be defined.").withConfigProperty(NAME_RANGE_INTERVAL);
            } else if (rangeInterval <= 0L) {
                collector.addFailure("Range Interval is not a positive number.", "Range interval must be a valid positive integer.").withConfigProperty(NAME_RANGE_INTERVAL);
            }
        }
    }

    private void validateIntegerPartitioningColumn(String columnName, FailureCollector collector, io.cdap.cdap.api.data.schema.Schema fieldSchema) {
        if (fieldSchema.getType() != Schema.Type.INT && fieldSchema.getType() != Schema.Type.LONG) {
            collector.addFailure(String.format("Partition column '%s' is of invalid type '%s'.", columnName, fieldSchema.getDisplayName()), "Partition column must be a int  or long.").withConfigProperty(NAME_PARTITION_BY_FIELD).withOutputSchemaField(columnName).withInputSchemaField(columnName);
        }
    }

    private void validateClusteringOrder(@Nullable io.cdap.cdap.api.data.schema.Schema schema, FailureCollector collector) {
        if (Strings.isNullOrEmpty((String)this.clusteringOrder) || schema == null) {
            return;
        }
        if (!this.containsMacro(NAME_PARTITION_BY_FIELD) && !this.containsMacro(NAME_CLUSTERING_ORDER) && !Strings.isNullOrEmpty((String)this.clusteringOrder) && Strings.isNullOrEmpty((String)this.partitionByField)) {
            collector.addFailure("Clustering order cannot be validated.", "Partition field must have a value.");
            return;
        }
        List columnsNames = Arrays.stream(this.clusteringOrder.split(",")).map(String::trim).collect(Collectors.toList());
        if (columnsNames.size() > 4) {
            collector.addFailure(String.format("Found '%d' number of clustering fields.", columnsNames.size()), String.format("Expected at most '%d' clustering fields.", 4)).withConfigProperty(NAME_CLUSTERING_ORDER);
            return;
        }
        for (String column : columnsNames) {
            Schema.Field field = schema.getField(column);
            if (field == null) {
                collector.addFailure(String.format("Clustering field '%s' does not exist in the schema.", column), "Ensure all clustering fields exist in the schema.").withConfigElement(NAME_CLUSTERING_ORDER, column);
                continue;
            }
            io.cdap.cdap.api.data.schema.Schema nonNullSchema = BigQueryUtil.getNonNullableSchema(field.getSchema());
            Schema.Type type = nonNullSchema.getType();
            Schema.LogicalType logicalType = nonNullSchema.getLogicalType();
            if (SUPPORTED_CLUSTERING_TYPES.contains(type) || BigQuerySinkUtils.isSupportedLogicalType(logicalType)) continue;
            collector.addFailure(String.format("Field '%s' is of unsupported type '%s'.", column, nonNullSchema.getDisplayName()), "Supported types are : string, bytes, int, long, boolean, date, timestamp and decimal.").withConfigElement(NAME_CLUSTERING_ORDER, column).withInputSchemaField(column).withOutputSchemaField(column);
        }
    }

    private void validateOperationProperties(@Nullable io.cdap.cdap.api.data.schema.Schema schema, FailureCollector collector) {
        boolean updateOrUpsertOperation;
        if (this.containsMacro(NAME_OPERATION) || this.containsMacro(NAME_TABLE_KEY) || this.containsMacro(NAME_DEDUPE_BY)) {
            return;
        }
        Operation assetOperation = this.getOperation();
        if (Arrays.stream(Operation.values()).noneMatch(assetOperation::equals)) {
            collector.addFailure(String.format("Operation has incorrect value '%s'.", new Object[]{assetOperation}), "Set the operation to 'Insert', 'Update', or 'Upsert'.").withConfigElement(NAME_OPERATION, assetOperation.name().toLowerCase());
            return;
        }
        if (Operation.INSERT.equals((Object)assetOperation)) {
            return;
        }
        boolean bl = updateOrUpsertOperation = Operation.UPDATE.equals((Object)assetOperation) || Operation.UPSERT.equals((Object)assetOperation);
        if (updateOrUpsertOperation && this.getTableKey() == null) {
            collector.addFailure("Table key must be set if the operation is 'Update' or 'Upsert'.", null).withConfigProperty(NAME_TABLE_KEY).withConfigProperty(NAME_OPERATION);
            return;
        }
        if (schema == null) {
            return;
        }
        List fields = Objects.requireNonNull(schema.getFields()).stream().map(Schema.Field::getName).collect(Collectors.toList());
        List<String> keyFields = Arrays.stream(Objects.requireNonNull(this.getTableKey()).split(",")).map(String::trim).collect(Collectors.toList());
        for (String keyField : keyFields) {
            if (fields.contains(keyField)) continue;
            collector.addFailure(String.format("Table key field '%s' does not exist in the schema.", keyField), "Change the Table key field to be one of the schema fields.").withConfigElement(NAME_TABLE_KEY, keyField);
        }
        Map<String, Integer> keyMap = BigQuerySinkUtils.calculateDuplicates(keyFields);
        keyMap.keySet().stream().filter(key -> (Integer)keyMap.get(key) != 1).forEach(key -> collector.addFailure(String.format("Table key field '%s' is duplicated.", key), String.format("Remove duplicates of Table key field '%s'.", key)).withConfigElement(NAME_TABLE_KEY, key));
        if (updateOrUpsertOperation && this.getDedupeBy() != null) {
            List<String> dedupeByList = Arrays.stream(Objects.requireNonNull(this.getDedupeBy()).split(",")).collect(Collectors.toList());
            dedupeByList.stream().filter(v -> !fields.contains(v.split(" ")[0])).forEach(v -> collector.addFailure(String.format("Dedupe by field '%s' does not exist in the schema.", v.split(" ")[0]), "Change the Dedupe by field to be one of the schema fields.").withConfigElement(NAME_DEDUPE_BY, v));
            Map<String, Integer> orderedByFieldMap = BigQuerySinkUtils.calculateDuplicates(dedupeByList);
            Map<String, String> orderedByFieldValueMap = dedupeByList.stream().collect(Collectors.toMap(p -> p.split(" ")[0], p -> p, (x, y) -> y));
            orderedByFieldMap.keySet().stream().filter(key -> (Integer)orderedByFieldMap.get(key) != 1).forEach(key -> collector.addFailure(String.format("Dedupe by field '%s' is duplicated.", key), String.format("Remove duplicates of Dedupe by field '%s'.", key)).withConfigElement(NAME_DEDUPE_BY, (String)orderedByFieldValueMap.get(key)));
        }
    }

    public boolean shouldConnect() {
        return !this.containsMacro(NAME_ASSET) && !this.containsMacro(NAME_TABLE) && !this.containsMacro("serviceAccountType") && !this.containsMacro("serviceFilePath") && !this.containsMacro("serviceAccountJSON") && !this.containsMacro("project") && !this.containsMacro(NAME_SCHEMA);
    }

    protected ValidatingOutputFormat getValidatingOutputFormat(PipelineConfigurer pipelineConfigurer) {
        return (ValidatingOutputFormat)pipelineConfigurer.usePlugin("validatingOutputFormat", this.format.toLowerCase(), this.format.toLowerCase(), this.getRawProperties());
    }

    public void validateFormatForStorageBucket(PipelineConfigurer pipelineConfigurer, FailureCollector collector) {
        if (!this.containsMacro(NAME_FORMAT) && Strings.isNullOrEmpty((String)this.format)) {
            collector.addFailure(String.format("Required field '%s' has no value.", NAME_FORMAT), null).withConfigProperty(NAME_FORMAT);
            collector.getOrThrowException();
        }
        if (!this.containsMacro(NAME_FORMAT)) {
            String fileFormat = null;
            try {
                fileFormat = this.getFormat().toString().toLowerCase();
            }
            catch (IllegalArgumentException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_FORMAT).withStacktrace(e.getStackTrace());
            }
            ValidatingOutputFormat validatingOutputFormat = this.getValidatingOutputFormat(pipelineConfigurer);
            FormatContext context = new FormatContext(collector, pipelineConfigurer.getStageConfigurer().getInputSchema());
            this.validateOutputFormatProvider(context, fileFormat, validatingOutputFormat);
        } else {
            for (FileFormat f : FileFormat.values()) {
                try {
                    pipelineConfigurer.usePlugin("validatingOutputFormat", f.name().toLowerCase(), f.name().toLowerCase(), this.getRawProperties());
                }
                catch (InvalidPluginConfigException var8) {
                    LOG.warn("Failed to register format '{}', which means it cannot be used when the pipeline is run. Missing properties: {}, invalid properties: {}", new Object[]{f.name(), var8.getMissingProperties(), var8.getInvalidProperties().stream().map(InvalidPluginProperty::getName).collect(Collectors.toList())});
                }
            }
        }
    }

    public void validateOutputFormatProvider(FormatContext context, String format, @Nullable ValidatingOutputFormat validatingOutputFormat) {
        FailureCollector collector = context.getFailureCollector();
        if (validatingOutputFormat == null) {
            collector.addFailure(String.format("Could not find the '%s' output format plugin.", format), null).withPluginNotFound(format, format, "validatingOutputFormat");
        } else {
            validatingOutputFormat.validate(context);
        }
    }

    public void validateStorageBucket(FailureCollector collector) {
        if (this.containsMacro("location") || this.containsMacro("lake") || this.containsMacro("zone") || this.containsMacro(NAME_ASSET)) {
            return;
        }
        if (!this.containsMacro(NAME_TABLE) && this.table == null) {
            collector.addFailure(String.format("Required property '%s' has no value.", NAME_TABLE), null).withConfigProperty(NAME_TABLE);
            collector.getOrThrowException();
        }
        if (!Strings.isNullOrEmpty((String)this.suffix) && !this.containsMacro(NAME_SUFFIX)) {
            try {
                new SimpleDateFormat(this.suffix);
            }
            catch (IllegalArgumentException e) {
                collector.addFailure("Invalid suffix.", "Ensure provided suffix is valid.").withConfigProperty(NAME_SUFFIX).withStacktrace(e.getStackTrace());
            }
        }
        try {
            this.getSchema(collector);
        }
        catch (IllegalArgumentException e) {
            collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_SCHEMA).withStacktrace(e.getStackTrace());
        }
    }

    @Nullable
    public String getContentType(String format) {
        return contentTypeMap.get(format.toLowerCase());
    }

    private DataplexBatchSinkConfig(@Nullable String referenceName, String asset, @Nullable String assetType, @Nullable String location, @Nullable String lake, @Nullable String zone, @Nullable String format, @Nullable GCPConnectorConfig connection, @Nullable String table, @Nullable String tableKey, @Nullable String dedupeBy, @Nullable String operation, @Nullable String partitionFilter, @Nullable String partitioningType, @Nullable Long rangeStart, @Nullable Long rangeEnd, @Nullable Long rangeInterval, @Nullable Boolean truncateTable, @Nullable Boolean updateDataplexMetadata, @Nullable Boolean allowSchemaRelaxation, @Nullable String partitionByField, @Nullable Boolean requirePartitionField, @Nullable String clusteringOrder, @Nullable String suffix, @Nullable String schema) {
        this.referenceName = referenceName;
        this.connection = connection;
        this.location = location;
        this.lake = lake;
        this.zone = zone;
        this.asset = asset;
        this.assetType = assetType;
        this.format = format;
        this.table = table;
        this.tableKey = tableKey;
        this.dedupeBy = dedupeBy;
        this.operation = operation;
        this.partitionFilter = partitionFilter;
        this.partitioningType = partitioningType;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.rangeInterval = rangeInterval;
        this.truncateTable = truncateTable;
        this.updateDataplexMetadata = updateDataplexMetadata;
        this.allowSchemaRelaxation = allowSchemaRelaxation;
        this.partitionByField = partitionByField;
        this.requirePartitionField = requirePartitionField;
        this.clusteringOrder = clusteringOrder;
        this.suffix = suffix;
        this.schema = schema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String asset;
        private String assetType;
        private String format;
        private String table;
        private String tableKey;
        private String dedupeBy;
        private String operation;
        private String partitionFilter;
        private String partitioningType;
        private Long rangeStart;
        private Long rangeEnd;
        private Long rangeInterval;
        private Boolean truncateTable;
        private Boolean updateDataplexMetadata;
        private Boolean allowSchemaRelaxation;
        private String partitionByField;
        private Boolean requirePartitionField;
        private String clusteringOrder;
        private String suffix;
        private String schema;
        private String location;
        private String lake;
        private String zone;
        private GCPConnectorConfig connection;
        private String referenceName;

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        public Builder setAssetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setTableKey(String tableKey) {
            this.tableKey = tableKey;
            return this;
        }

        public Builder setDedupeBy(String dedupeBy) {
            this.dedupeBy = dedupeBy;
            return this;
        }

        public Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder setPartitionFilter(String partitionFilter) {
            this.partitionFilter = partitionFilter;
            return this;
        }

        public Builder setPartitioningType(String partitioningType) {
            this.partitioningType = partitioningType;
            return this;
        }

        public Builder setRangeStart(Long rangeStart) {
            this.rangeStart = rangeStart;
            return this;
        }

        public Builder setRangeEnd(Long rangeEnd) {
            this.rangeEnd = rangeEnd;
            return this;
        }

        public Builder setRangeInterval(Long rangeInterval) {
            this.rangeInterval = rangeInterval;
            return this;
        }

        public Builder setTruncateTable(Boolean truncateTable) {
            this.truncateTable = truncateTable;
            return this;
        }

        public Builder setUpdateDataplexMetadata(Boolean updateDataplexMetadata) {
            this.updateDataplexMetadata = updateDataplexMetadata;
            return this;
        }

        public Builder setAllowSchemaRelaxation(Boolean allowSchemaRelaxation) {
            this.allowSchemaRelaxation = allowSchemaRelaxation;
            return this;
        }

        public Builder setPartitionByField(String partitionByField) {
            this.partitionByField = partitionByField;
            return this;
        }

        public Builder setRequirePartitionField(Boolean requirePartitionField) {
            this.requirePartitionField = requirePartitionField;
            return this;
        }

        public Builder setClusteringOrder(String clusteringOrder) {
            this.clusteringOrder = clusteringOrder;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setConnection(GCPConnectorConfig connection) {
            this.connection = connection;
            return this;
        }

        public Builder setReferenceName(String referenceName) {
            this.referenceName = referenceName;
            return this;
        }

        public DataplexBatchSinkConfig build() {
            return new DataplexBatchSinkConfig(this.referenceName, this.asset, this.assetType, this.location, this.lake, this.zone, this.format, this.connection, this.table, this.tableKey, this.dedupeBy, this.operation, this.partitionFilter, this.partitioningType, this.rangeStart, this.rangeEnd, this.rangeInterval, this.truncateTable, this.updateDataplexMetadata, this.allowSchemaRelaxation, this.partitionByField, this.requirePartitionField, this.clusteringOrder, this.suffix, this.schema);
        }
    }
}

