/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.dataplex.source;

import com.google.cloud.dataplex.v1.StorageSystem;
import io.cdap.cdap.api.data.batch.InputFormatProvider;
import io.cdap.plugin.common.batch.ConfigurationUtils;
import io.cdap.plugin.format.avro.input.CombineAvroInputFormat;
import io.cdap.plugin.gcp.bigquery.source.PartitionedBigQueryInputFormat;
import io.cdap.plugin.gcp.dataplex.common.util.DataplexUtil;
import io.cdap.plugin.gcp.dataplex.source.DataplexBatchSource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataplexInputFormatProvider
implements InputFormatProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DataplexBatchSource.class);
    private static Configuration configuration;
    protected static Map<String, String> inputFormatConfiguration;

    public DataplexInputFormatProvider(Configuration conf) {
        configuration = conf;
        if (conf != null) {
            String entityType = conf.get("dataplex.source.entity.type");
            if (entityType.equalsIgnoreCase(StorageSystem.BIGQUERY.toString())) {
                inputFormatConfiguration = StreamSupport.stream(conf.spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            } else if (entityType.equalsIgnoreCase(StorageSystem.CLOUD_STORAGE.toString())) {
                inputFormatConfiguration = ConfigurationUtils.getNonDefaultConfigurations((Configuration)conf);
            }
        }
    }

    public String getInputFormatClassName() {
        if (configuration != null) {
            String entityType = configuration.get("dataplex.source.entity.type");
            if (entityType.equalsIgnoreCase(StorageSystem.BIGQUERY.toString())) {
                return PartitionedBigQueryInputFormat.class.getName();
            }
            if (entityType.equalsIgnoreCase(StorageSystem.CLOUD_STORAGE.toString())) {
                return DataplexInputFormat.class.getName();
            }
        }
        return null;
    }

    public Map<String, String> getInputFormatConfiguration() {
        return inputFormatConfiguration;
    }

    public static class DataplexInputFormat
    extends InputFormat<Object, Object> {
        private final InputFormat delegateFormat = new CombineAvroInputFormat();

        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            try {
                DataplexUtil.getJobCompletion(jobContext.getConfiguration());
            }
            catch (Exception e) {
                LOG.error("Job failed in getSplits.");
                throw new IOException("Job creation failed in dataproc.", e);
            }
            return this.delegateFormat.getSplits(jobContext);
        }

        public RecordReader<Object, Object> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return this.delegateFormat.createRecordReader(inputSplit, taskAttemptContext);
        }
    }
}

