/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.dataplex.source.config;

import com.google.api.gax.rpc.ApiException;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.dataplex.v1.DataplexServiceClient;
import com.google.cloud.dataplex.v1.Entity;
import com.google.cloud.dataplex.v1.EntityName;
import com.google.cloud.dataplex.v1.GetEntityRequest;
import com.google.cloud.dataplex.v1.Lake;
import com.google.cloud.dataplex.v1.LakeName;
import com.google.cloud.dataplex.v1.MetadataServiceClient;
import com.google.cloud.dataplex.v1.ZoneName;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.InvalidPluginConfigException;
import io.cdap.cdap.api.plugin.InvalidPluginProperty;
import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchSourceContext;
import io.cdap.cdap.etl.api.validation.FormatContext;
import io.cdap.cdap.etl.api.validation.ValidatingInputFormat;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.dataplex.common.config.DataplexBaseConfig;
import io.cdap.plugin.gcp.dataplex.common.util.DataplexUtil;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;

public class DataplexBatchSourceConfig
extends DataplexBaseConfig {
    private static final String NAME_ENTITY = "entity";
    private static final String NAME_PARTITION_FROM = "partitionFrom";
    private static final String NAME_PARTITION_TO = "partitionTo";
    private static final String NAME_FILTER = "filter";
    private static final String NAME_SCHEMA = "schema";
    public static final String INPUT_FORMAT = "avro";
    @Name(value="entity")
    @Macro
    @Description(value="ID of the Dataplex entity, which can be found on the entity detail page.")
    protected String entity;
    @Name(value="partitionFrom")
    @Macro
    @Nullable
    @Description(value="Inclusive partition start date. Must be a string with format \u2018yyyy-MM-dd\u2019. The value is ignored if the table does not support partitioning.")
    private final String partitionFrom;
    @Name(value="partitionTo")
    @Macro
    @Nullable
    @Description(value="Inclusive partition end date. Must be a string with format \u2018yyyy-MM-dd\u2019. The value is ignored if the table does not support partitioning.")
    private final String partitionTo;
    @Name(value="filter")
    @Macro
    @Nullable
    @Description(value="The WHERE clause filters out rows by evaluating each row against boolean expression, and discards all rows that do not return TRUE (that is, rows that return FALSE or NULL).")
    private String filter;
    @Name(value="schema")
    @Nullable
    @Macro
    @Description(value="The schema of the data to write. If provided, must be compatible with the table schema.")
    private final String schema;

    @Nullable
    public String getPartitionFrom() {
        return Strings.isNullOrEmpty((String)this.partitionFrom) ? null : this.partitionFrom;
    }

    @Nullable
    public String getPartitionTo() {
        return Strings.isNullOrEmpty((String)this.partitionTo) ? null : this.partitionTo;
    }

    @Nullable
    public String getFilter() {
        if (this.filter != null) {
            this.filter = this.filter.trim();
            if (this.filter.isEmpty()) {
                return null;
            }
        }
        return this.filter;
    }

    @Nullable
    public Schema getSchema(FailureCollector collector) {
        if (Strings.isNullOrEmpty((String)this.schema)) {
            return null;
        }
        try {
            return Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(NAME_SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity getAndValidateEntityConfiguration(FailureCollector collector, GoogleCredentials credentials) throws IOException {
        Throwable throwable;
        DataplexServiceClient dataplexServiceClient;
        if (!Strings.isNullOrEmpty((String)this.referenceName)) {
            IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        }
        String projectID = this.tryGetProject();
        if (Strings.isNullOrEmpty((String)this.location)) return null;
        if (this.containsMacro("location")) return null;
        if (Strings.isNullOrEmpty((String)this.lake)) return null;
        if (this.containsMacro("lake")) return null;
        try {
            dataplexServiceClient = DataplexUtil.getDataplexServiceClient(credentials);
            throwable = null;
            try {
                dataplexServiceClient.getLake(LakeName.newBuilder().setProject(projectID).setLocation(this.location).setLake(this.lake).build());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataplexServiceClient != null) {
                    if (throwable != null) {
                        try {
                            dataplexServiceClient.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataplexServiceClient.close();
                    }
                }
            }
        }
        catch (ApiException e) {
            if (e.getMessage().contains("Location")) {
                this.configureDataplexException(this.location, "location", e, collector);
                return null;
            }
            this.configureDataplexException(this.lake, "lake", e, collector);
            return null;
        }
        if (Strings.isNullOrEmpty((String)this.zone)) return null;
        if (this.containsMacro("zone")) return null;
        try {
            dataplexServiceClient = DataplexUtil.getDataplexServiceClient(credentials);
            throwable = null;
            try {
                dataplexServiceClient.getZone(ZoneName.of((String)projectID, (String)this.location, (String)this.lake, (String)this.zone).toString());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dataplexServiceClient != null) {
                    if (throwable != null) {
                        try {
                            dataplexServiceClient.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dataplexServiceClient.close();
                    }
                }
            }
        }
        catch (ApiException e) {
            this.configureDataplexException(this.zone, "zone", e, collector);
            return null;
        }
        if (Strings.isNullOrEmpty((String)this.entity)) return null;
        if (this.containsMacro(NAME_ENTITY)) return null;
        try {
            throwable = null;
            try (MetadataServiceClient metadataServiceClient = DataplexUtil.getMetadataServiceClient(credentials);){
                Entity entityBean;
                Entity entity = entityBean = metadataServiceClient.getEntity(GetEntityRequest.newBuilder().setName(EntityName.of((String)projectID, (String)this.location, (String)this.lake, (String)this.zone, (String)this.entity).toString()).setView(GetEntityRequest.EntityView.FULL).build());
                return entity;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (ApiException e) {
            this.configureDataplexException(this.entity, NAME_ENTITY, e, collector);
            return null;
        }
    }

    public void validateBigQueryDataset(FailureCollector collector, String project, String dataset, String tableName) {
        TimePartitioning timePartitioning;
        BigQueryUtil.validateTable(tableName, NAME_ENTITY, collector);
        Table sourceTable = BigQueryUtil.getBigQueryTable(project, dataset, tableName, this.getServiceAccount(), this.isServiceAccountFilePath(), collector);
        if (sourceTable == null) {
            return;
        }
        if (sourceTable.getDefinition() instanceof StandardTableDefinition && (timePartitioning = ((StandardTableDefinition)sourceTable.getDefinition()).getTimePartitioning()) == null) {
            return;
        }
        String partitionFromDate = this.getPartitionFrom();
        String partitionToDate = this.getPartitionTo();
        if (partitionFromDate == null && partitionToDate == null) {
            return;
        }
        LocalDate fromDate = null;
        if (partitionFromDate != null) {
            try {
                fromDate = LocalDate.parse(partitionFromDate);
            }
            catch (DateTimeException ex) {
                collector.addFailure("Invalid partition from date format.", "Ensure partition from date is of format 'yyyy-MM-dd'.").withConfigProperty(NAME_PARTITION_FROM);
            }
        }
        LocalDate toDate = null;
        if (partitionToDate != null) {
            try {
                toDate = LocalDate.parse(partitionToDate);
            }
            catch (DateTimeException ex) {
                collector.addFailure("Invalid partition to date format.", "Ensure partition to date is of format 'yyyy-MM-dd'.").withConfigProperty(NAME_PARTITION_TO);
            }
        }
        if (fromDate != null && toDate != null && fromDate.isAfter(toDate) && !fromDate.isEqual(toDate)) {
            collector.addFailure("'Partition From Date' must be before or equal 'Partition To Date'.", null).withConfigProperty(NAME_PARTITION_FROM).withConfigProperty(NAME_PARTITION_TO);
        }
    }

    private boolean canConnect() {
        return !this.containsMacro(NAME_SCHEMA) && this.connection != null && this.connection.canConnect();
    }

    public TableDefinition.Type getSourceTableType(String datasetProject, String dataSet, String tableId) {
        Table sourceTable = BigQueryUtil.getBigQueryTable(datasetProject, dataSet, tableId, this.getServiceAccount(), this.isServiceAccountFilePath());
        return sourceTable != null ? sourceTable.getDefinition().getType() : null;
    }

    public void setupValidatingInputFormat(PipelineConfigurer pipelineConfigurer, FailureCollector collector, @Nullable Entity entity) {
        String fileFormat = INPUT_FORMAT;
        collector.getOrThrowException();
        if (entity != null && this.getSchema(collector) == null) {
            Schema schema = DataplexUtil.getTableSchema(entity.getSchema(), collector);
            pipelineConfigurer.getStageConfigurer().setOutputSchema(schema);
        }
        PluginProperties.Builder builder = PluginProperties.builder();
        builder.addAll(this.getRawProperties().getProperties());
        pipelineConfigurer.usePlugin("validatingInputFormat", fileFormat, fileFormat, builder.build());
    }

    public Map<String, String> getFileSystemProperties(String path) {
        Map<String, String> properties = GCPUtils.getFileSystemProperties(this.getConnection(), path, new HashMap<String, String>());
        return properties;
    }

    private void validateInputFormatProvider(FormatContext context, String fileFormat, @Nullable ValidatingInputFormat validatingInputFormat) {
        FailureCollector collector = context.getFailureCollector();
        if (validatingInputFormat == null) {
            collector.addFailure(String.format("Could not find the '%s' input format.", fileFormat), null).withPluginNotFound(fileFormat, fileFormat, "validatingInputFormat");
        } else {
            validatingInputFormat.validate(context);
        }
    }

    public ValidatingInputFormat getValidatingInputFormat(BatchSourceContext batchSourceContext) throws InstantiationException {
        ValidatingInputFormat validatingInputFormat;
        FailureCollector collector = batchSourceContext.getFailureCollector();
        String fileFormat = INPUT_FORMAT;
        try {
            validatingInputFormat = (ValidatingInputFormat)batchSourceContext.newPluginInstance(fileFormat);
        }
        catch (InvalidPluginConfigException exception) {
            HashSet<String> properties = new HashSet<String>(exception.getMissingProperties());
            for (InvalidPluginProperty invalidProperty : exception.getInvalidProperties()) {
                properties.add(invalidProperty.getName());
            }
            String errorMessage = String.format("Format '%s' cannot be used because properties %s were not provided or were invalid when the pipeline was deployed. Set the format to a different value, or re-create the pipeline with all required properties.", fileFormat, properties);
            throw new IllegalArgumentException(errorMessage, exception);
        }
        FormatContext formatContext = new FormatContext(collector, batchSourceContext.getInputSchema());
        this.validateInputFormatProvider(formatContext, fileFormat, validatingInputFormat);
        collector.getOrThrowException();
        return validatingInputFormat;
    }

    public String getEntity() {
        return this.entity;
    }

    public void checkMetastoreForGCSEntity(FailureCollector collector, GoogleCredentials credentials) {
        if (!Strings.isNullOrEmpty((String)this.lake) && !this.containsMacro("lake")) {
            try (DataplexServiceClient dataplexServiceClient = DataplexUtil.getDataplexServiceClient(credentials);){
                Lake lakeBean = dataplexServiceClient.getLake(LakeName.newBuilder().setProject(this.tryGetProject()).setLocation(this.location).setLake(this.lake).build());
                if (lakeBean.getMetastore() == null || lakeBean.getMetastore() != null && lakeBean.getMetastore().getService() == null) {
                    collector.addFailure(String.format("Metastore not attached with the lake '%s'.", lakeBean.getDisplayName()), "").withConfigProperty("lake");
                }
            }
            catch (ApiException e) {
                this.configureDataplexException(this.lake, "lake", e, collector);
            }
            catch (IOException e) {
                collector.addFailure(e.getMessage(), "Please check credentials");
            }
            collector.getOrThrowException();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataplexBatchSourceConfig(String entity, String schema, String location, String lake, String zone, GCPConnectorConfig connection, @Nullable String referenceName, String partitionTo, String partitionFrom, String filter) {
        this.entity = entity;
        this.schema = schema;
        this.location = location;
        this.lake = lake;
        this.zone = zone;
        this.connection = connection;
        this.referenceName = referenceName;
        this.partitionTo = partitionTo;
        this.partitionFrom = partitionFrom;
        this.filter = filter;
    }

    public static class Builder {
        private String entity;
        private String schema;
        private String location;
        private String lake;
        private String zone;
        private GCPConnectorConfig connection;
        private String referenceName;
        private String partitionTo;
        private String partitionFrom;
        private String filter;

        public Builder setEntity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setConnection(GCPConnectorConfig connection) {
            this.connection = connection;
            return this;
        }

        public Builder setReferenceName(String referenceName) {
            this.referenceName = referenceName;
            return this;
        }

        public Builder setPartitionTo(String partitionTo) {
            this.partitionTo = partitionTo;
            return this;
        }

        public Builder setpartitionFrom(String partitionFrom) {
            this.partitionFrom = partitionFrom;
            return this;
        }

        public Builder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public DataplexBatchSourceConfig build() {
            return new DataplexBatchSourceConfig(this.entity, this.schema, this.location, this.lake, this.zone, this.connection, this.referenceName, this.partitionTo, this.partitionFrom, this.filter);
        }
    }
}

