/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.sink;

import com.google.common.collect.ImmutableMap;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.plugin.gcp.datastore.sink.DatastoreOutputFormat;
import java.util.Map;
import java.util.Objects;

public class DatastoreOutputFormatProvider
implements OutputFormatProvider {
    private final Map<String, String> configMap;

    public DatastoreOutputFormatProvider(String project, String serviceAccount, Boolean isServiceAccountFilePath, String shouldUseAutoGeneratedKey, String batchSize, String shouldUseTransactions) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"mapred.gcd.output.project", (Object)project).put((Object)"mapred.gcd.output.use.autogenerated.key", (Object)shouldUseAutoGeneratedKey).put((Object)"mapred.gcd.output.batch.size", (Object)batchSize).put((Object)"mapred.gcd.output.use.transactions", (Object)shouldUseTransactions);
        if (Objects.nonNull(serviceAccount)) {
            builder.put((Object)"mapred.gcd.output.service.account", (Object)serviceAccount);
            builder.put((Object)"mapred.gcd.output.service.account.isfilepath", (Object)isServiceAccountFilePath.toString());
        }
        this.configMap = builder.build();
    }

    public String getOutputFormatClassName() {
        return DatastoreOutputFormat.class.getName();
    }

    public Map<String, String> getOutputFormatConfiguration() {
        return this.configMap;
    }
}

